/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Richtung der TMCLocation.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
@Wertebereich(
	minimum = -1L,
	maximum = 1L,
	einheit = ""
)
public class AttTmcRichtung extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Byte
	 MIN_VALUE =
				Byte
		.valueOf("-1");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Byte
	 MAX_VALUE =
				Byte
		.valueOf("1");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "";
	
	/**
	Fahrtrichtung gegen die Richtung der TMC Location Codes.
	<p>
	
	</p>
	*/
	public static final AttTmcRichtung ZUSTAND_1N_NEGATIV = new AttTmcRichtung("negativ", 		Byte
	.valueOf("-1"));

	/**
	Location Code hat keine Richtung (z. B. bei Flächen).
	<p>
	
	</p>
	*/
	public static final AttTmcRichtung ZUSTAND_0_OHNE_RICHTUNG = new AttTmcRichtung("ohne Richtung", 		Byte
	.valueOf("0"));

	/**
	Fahrtrichtung in Richtung der TMC Location Codes.
	<p>
	
	</p>
	*/
	public static final AttTmcRichtung ZUSTAND_1_POSITIV = new AttTmcRichtung("positiv", 		Byte
	.valueOf("1"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTmcRichtung getZustand(final 		Byte
	 value) {
		for (AttTmcRichtung e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTmcRichtung getZustand(final String value) {
		for (AttTmcRichtung e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTmcRichtung> getZustaende() {
		List<AttTmcRichtung> list = new ArrayList<AttTmcRichtung>();
		list.add(ZUSTAND_1N_NEGATIV);
		list.add(ZUSTAND_0_OHNE_RICHTUNG);
		list.add(ZUSTAND_1_POSITIV);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TmcRichtung.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTmcRichtung(final 		Byte
	 value) {
		super(value);
	}
	
	private AttTmcRichtung(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
