/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Daten der Meldung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class AtlTmcDaten implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AtlTmcVerwaltung
			 _verwaltungsInformationen
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AtlTmcVerwaltung
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AtlTmcEreignisse
			 _ereignisInformationen
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AtlTmcEreignisse
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AtlTmcVerortung
			 _verortungsInformationen
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AtlTmcVerortung
			()
			;
	
		/**
		Verwaltungsinformationen.
		<p>
		Verwaltungsinformationen der Meldung.
		</p>
		
		@return der Wert von VerwaltungsInformationen.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AtlTmcVerwaltung
			 getVerwaltungsInformationen() {
			return _verwaltungsInformationen;
		}
	
		/**
		Verwaltungsinformationen.
		<p>
		Verwaltungsinformationen der Meldung.
		</p>
		
		@param _verwaltungsInformationen der neue Wert von VerwaltungsInformationen.
		*/
		public void setVerwaltungsInformationen(de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AtlTmcVerwaltung
		 _verwaltungsInformationen) {
			this._verwaltungsInformationen = _verwaltungsInformationen;
		}
	
		/**
		Verkehrsinformationen.
		<p>
		Verkehrsinformationen der Meldung.
		</p>
		
		@return der Wert von EreignisInformationen.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AtlTmcEreignisse
			 getEreignisInformationen() {
			return _ereignisInformationen;
		}
	
		/**
		Verkehrsinformationen.
		<p>
		Verkehrsinformationen der Meldung.
		</p>
		
		@param _ereignisInformationen der neue Wert von EreignisInformationen.
		*/
		public void setEreignisInformationen(de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AtlTmcEreignisse
		 _ereignisInformationen) {
			this._ereignisInformationen = _ereignisInformationen;
		}
	
		/**
		Verortungsinformationen.
		<p>
		Verortungsinformationen der Meldung.
		</p>
		
		@return der Wert von VerortungsInformationen.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AtlTmcVerortung
			 getVerortungsInformationen() {
			return _verortungsInformationen;
		}
	
		/**
		Verortungsinformationen.
		<p>
		Verortungsinformationen der Meldung.
		</p>
		
		@param _verortungsInformationen der neue Wert von VerortungsInformationen.
		*/
		public void setVerortungsInformationen(de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AtlTmcVerortung
		 _verortungsInformationen) {
			this._verortungsInformationen = _verortungsInformationen;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// AttributListenDefinition
					getVerwaltungsInformationen().bean2Atl(datum.getItem("VerwaltungsInformationen"), factory);
				// AttributListenDefinition
					getEreignisInformationen().bean2Atl(datum.getItem("EreignisInformationen"), factory);
				// AttributListenDefinition
					getVerortungsInformationen().bean2Atl(datum.getItem("VerortungsInformationen"), factory);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// AttributListenDefinition
					getVerwaltungsInformationen().atl2Bean(daten.getItem("VerwaltungsInformationen"), factory);
				// AttributListenDefinition
					getEreignisInformationen().atl2Bean(daten.getItem("EreignisInformationen"), factory);
				// AttributListenDefinition
					getVerortungsInformationen().atl2Bean(daten.getItem("VerortungsInformationen"), factory);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTmcDaten clone() {
		AtlTmcDaten klon = new AtlTmcDaten();
		
						klon._verwaltungsInformationen = getVerwaltungsInformationen().clone();
						klon._ereignisInformationen = getEreignisInformationen().clone();
						klon._verortungsInformationen = getVerortungsInformationen().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
