/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ereignis-Daten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class AtlTmcEreignisDaten implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEreignisCode
			 _ereignisCode
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsVorhersageCode
			 _vorhersageCode
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEmpfehlungsCode
			 _empfehlungsCode
			;
	
		/**
		Ereignis-Code.
		<p>
		&lt;absatz&gt;Codenummer des Ereignisses entsprechend DIN EN ISO 14819-2.&lt;&#47;absatz&gt;
		</p>
		
		@return der Wert von EreignisCode.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEreignisCode
			 getEreignisCode() {
			return _ereignisCode;
		}
	
		/**
		Ereignis-Code.
		<p>
		&lt;absatz&gt;Codenummer des Ereignisses entsprechend DIN EN ISO 14819-2.&lt;&#47;absatz&gt;
		</p>
		
		@param _ereignisCode der neue Wert von EreignisCode.
		*/
		public void setEreignisCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEreignisCode
		 _ereignisCode) {
			this._ereignisCode = _ereignisCode;
		}
	
		/**
		Vorhersage-Code.
		<p>
		&lt;absatz&gt;Codenummer der Vorhersage entsprechend DIN EN ISO 14819-2.&lt;&#47;absatz&gt;
		</p>
		
		@return der Wert von VorhersageCode.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsVorhersageCode
			 getVorhersageCode() {
			return _vorhersageCode;
		}
	
		/**
		Vorhersage-Code.
		<p>
		&lt;absatz&gt;Codenummer der Vorhersage entsprechend DIN EN ISO 14819-2.&lt;&#47;absatz&gt;
		</p>
		
		@param _vorhersageCode der neue Wert von VorhersageCode.
		*/
		public void setVorhersageCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsVorhersageCode
		 _vorhersageCode) {
			this._vorhersageCode = _vorhersageCode;
		}
	
		/**
		Empfehlungs-Code.
		<p>
		&lt;absatz&gt;Codenummer der Empfehlung entsprechend DIN EN ISO 14819-2.&lt;&#47;absatz&gt;
		</p>
		
		@return der Wert von EmpfehlungsCode.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEmpfehlungsCode
			 getEmpfehlungsCode() {
			return _empfehlungsCode;
		}
	
		/**
		Empfehlungs-Code.
		<p>
		&lt;absatz&gt;Codenummer der Empfehlung entsprechend DIN EN ISO 14819-2.&lt;&#47;absatz&gt;
		</p>
		
		@param _empfehlungsCode der neue Wert von EmpfehlungsCode.
		*/
		public void setEmpfehlungsCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEmpfehlungsCode
		 _empfehlungsCode) {
			this._empfehlungsCode = _empfehlungsCode;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getEreignisCode() != null) {
	                if (getEreignisCode().isZustand()) {
	                    datum.getUnscaledValue("EreignisCode").setText(getEreignisCode().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("EreignisCode").set(getEreignisCode().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getVorhersageCode() != null) {
	                if (getVorhersageCode().isZustand()) {
	                    datum.getUnscaledValue("VorhersageCode").setText(getVorhersageCode().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("VorhersageCode").set(getVorhersageCode().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getEmpfehlungsCode() != null) {
	                if (getEmpfehlungsCode().isZustand()) {
	                    datum.getUnscaledValue("EmpfehlungsCode").setText(getEmpfehlungsCode().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("EmpfehlungsCode").set(getEmpfehlungsCode().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("EreignisCode").isState()) {
							setEreignisCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEreignisCode
							.getZustand(daten.getScaledValue("EreignisCode").getText()));
						} else {
						setEreignisCode(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEreignisCode
						(daten.
							getUnscaledValue
						("EreignisCode").
								intValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("VorhersageCode").isState()) {
							setVorhersageCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsVorhersageCode
							.getZustand(daten.getScaledValue("VorhersageCode").getText()));
						} else {
						setVorhersageCode(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsVorhersageCode
						(daten.
							getUnscaledValue
						("VorhersageCode").
								intValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("EmpfehlungsCode").isState()) {
							setEmpfehlungsCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEmpfehlungsCode
							.getZustand(daten.getScaledValue("EmpfehlungsCode").getText()));
						} else {
						setEmpfehlungsCode(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEmpfehlungsCode
						(daten.
							getUnscaledValue
						("EmpfehlungsCode").
								intValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTmcEreignisDaten clone() {
		AtlTmcEreignisDaten klon = new AtlTmcEreignisDaten();
		
						klon.setEreignisCode(getEreignisCode());
						klon.setVorhersageCode(getVorhersageCode());
						klon.setEmpfehlungsCode(getEmpfehlungsCode());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
