/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Lokations-Daten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 3
 */
public class AtlTmcLokationsDaten implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			@Defaultwert(wert = "0")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
			 _primaerLokation
			;
			@Defaultwert(wert = "0")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
			 _sekundaerLokation
			;
			@Defaultwert(wert = "undefiniert")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttLaenge
			 _startOffset
			;
			@Defaultwert(wert = "undefiniert")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttLaenge
			 _endOffset
			;
			@Defaultwert(wert = "ohne Richtung")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcRichtung
			 _tMCRichtung
			;
	
		/**
		Primäre Location.
		<p>
		
		</p>
		
		@return der Wert von PrimaerLokation.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
			 getPrimaerLokation() {
			return _primaerLokation;
		}
	
		/**
		Primäre Location.
		<p>
		
		</p>
		
		@param _primaerLokation der neue Wert von PrimaerLokation.
		*/
		public void setPrimaerLokation(de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
		 _primaerLokation) {
			this._primaerLokation = _primaerLokation;
		}
	
		/**
		Sekundäre Location.
		<p>
		
		</p>
		
		@return der Wert von SekundaerLokation.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
			 getSekundaerLokation() {
			return _sekundaerLokation;
		}
	
		/**
		Sekundäre Location.
		<p>
		
		</p>
		
		@param _sekundaerLokation der neue Wert von SekundaerLokation.
		*/
		public void setSekundaerLokation(de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
		 _sekundaerLokation) {
			this._sekundaerLokation = _sekundaerLokation;
		}
	
		/**
		Abstand zwischen dem Ende des ersten Segmentes und dem Beginn des Ereignisses.
		<p>
		
		</p>
		
		@return der Wert von StartOffset.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttLaenge
			 getStartOffset() {
			return _startOffset;
		}
	
		/**
		Abstand zwischen dem Ende des ersten Segmentes und dem Beginn des Ereignisses.
		<p>
		
		</p>
		
		@param _startOffset der neue Wert von StartOffset.
		*/
		public void setStartOffset(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttLaenge
		 _startOffset) {
			this._startOffset = _startOffset;
		}
	
		/**
		Abstand zwischen dem Ende des Ereignisses und dem Beginn des letzten Segmentes.
		<p>
		
		</p>
		
		@return der Wert von EndOffset.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttLaenge
			 getEndOffset() {
			return _endOffset;
		}
	
		/**
		Abstand zwischen dem Ende des Ereignisses und dem Beginn des letzten Segmentes.
		<p>
		
		</p>
		
		@param _endOffset der neue Wert von EndOffset.
		*/
		public void setEndOffset(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttLaenge
		 _endOffset) {
			this._endOffset = _endOffset;
		}
	
		/**
		TMC-Richtung.
		<p>
		
		</p>
		
		@return der Wert von TMCRichtung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcRichtung
			 getTMCRichtung() {
			return _tMCRichtung;
		}
	
		/**
		TMC-Richtung.
		<p>
		
		</p>
		
		@param _tMCRichtung der neue Wert von TMCRichtung.
		*/
		public void setTMCRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcRichtung
		 _tMCRichtung) {
			this._tMCRichtung = _tMCRichtung;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getPrimaerLokation() != null) {
	                if (getPrimaerLokation().isZustand()) {
	                    datum.getUnscaledValue("PrimaerLokation").setText(getPrimaerLokation().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("PrimaerLokation").set(getPrimaerLokation().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getSekundaerLokation() != null) {
	                if (getSekundaerLokation().isZustand()) {
	                    datum.getUnscaledValue("SekundaerLokation").setText(getSekundaerLokation().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("SekundaerLokation").set(getSekundaerLokation().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getStartOffset() != null) {
	                if (getStartOffset().isZustand()) {
	                    datum.getUnscaledValue("StartOffset").setText(getStartOffset().toString());
	                } else {
						datum.
						getScaledValue
	                	("StartOffset").set(getStartOffset().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getEndOffset() != null) {
	                if (getEndOffset().isZustand()) {
	                    datum.getUnscaledValue("EndOffset").setText(getEndOffset().toString());
	                } else {
						datum.
						getScaledValue
	                	("EndOffset").set(getEndOffset().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getTMCRichtung() != null) {
	                if (getTMCRichtung().isZustand()) {
	                    datum.getUnscaledValue("TMCRichtung").setText(getTMCRichtung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("TMCRichtung").set(getTMCRichtung().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						setPrimaerLokation(new de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
						(daten.
							getUnscaledValue
						("PrimaerLokation").
								intValue
						()));
				// GanzzahlAttributTyp
						setSekundaerLokation(new de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
						(daten.
							getUnscaledValue
						("SekundaerLokation").
								intValue
						()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("StartOffset").isState()) {
							setStartOffset(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttLaenge
							.getZustand(daten.getScaledValue("StartOffset").getText()));
						} else {
						setStartOffset(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttLaenge
						(daten.
							getScaledValue
						("StartOffset").
							doubleValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("EndOffset").isState()) {
							setEndOffset(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttLaenge
							.getZustand(daten.getScaledValue("EndOffset").getText()));
						} else {
						setEndOffset(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttLaenge
						(daten.
							getScaledValue
						("EndOffset").
							doubleValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("TMCRichtung").isState()) {
							setTMCRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcRichtung
							.getZustand(daten.getScaledValue("TMCRichtung").getText()));
						} else {
						setTMCRichtung(new de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcRichtung
						(daten.
							getUnscaledValue
						("TMCRichtung").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTmcLokationsDaten clone() {
		AtlTmcLokationsDaten klon = new AtlTmcLokationsDaten();
		
						klon.setPrimaerLokation(getPrimaerLokation());
						klon.setSekundaerLokation(getSekundaerLokation());
						klon.setStartOffset(getStartOffset());
						klon.setEndOffset(getEndOffset());
						klon.setTMCRichtung(getTMCRichtung());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
