/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Verortungsinformationen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 3
 */
public class AtlTmcVerortung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AtlTmcLokationsDaten
			> _lokationsDaten = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AtlTmcLokationsDaten
			>(0, true);
			private de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AtlTmcKoordinaten
			 _koordinate
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AtlTmcKoordinaten
			()
			;
	
		/**
		Lokations-Daten.
		<p>
		
		</p>
		
		@return der Wert von LokationsDaten.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AtlTmcLokationsDaten
			> getLokationsDaten() {
			return _lokationsDaten;
		}
	
	
		/**
		WGS-Koordinate des Ereignisses.
		<p>
		
		</p>
		
		@return der Wert von Koordinate.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AtlTmcKoordinaten
			 getKoordinate() {
			return _koordinate;
		}
	
		/**
		WGS-Koordinate des Ereignisses.
		<p>
		
		</p>
		
		@param _koordinate der neue Wert von Koordinate.
		*/
		public void setKoordinate(de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AtlTmcKoordinaten
		 _koordinate) {
			this._koordinate = _koordinate;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arrayLokationsDaten = datum.getArray("LokationsDaten");
					arrayLokationsDaten.setLength(getLokationsDaten().size());
					for (int i = 0; i < arrayLokationsDaten.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AtlTmcLokationsDaten
						 atl = getLokationsDaten().get(i);
						atl.bean2Atl(arrayLokationsDaten.getItem(i), factory);
	
					}
				// AttributListenDefinition
					getKoordinate().bean2Atl(datum.getItem("Koordinate"), factory);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arrayLokationsDaten = daten.getArray("LokationsDaten");
					for (int i = 0; i < arrayLokationsDaten.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AtlTmcLokationsDaten
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AtlTmcLokationsDaten
						 ();
						atl.atl2Bean(arrayLokationsDaten.getItem(i), factory);
						getLokationsDaten().add(atl);
					}
				// AttributListenDefinition
					getKoordinate().atl2Bean(daten.getItem("Koordinate"), factory);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTmcVerortung clone() {
		AtlTmcVerortung klon = new AtlTmcVerortung();
		
					klon._lokationsDaten = getLokationsDaten().clone();
						klon._koordinate = getKoordinate().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
