/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Verwaltungsinformationen der Meldung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class AtlTmcVerwaltung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<	Zeitstempel
			> _erzeugungsZeit = new Feld<	Zeitstempel
			>(1, true);
			private Feld<	Zeitstempel
			> _aktualisierungsZeit = new Feld<	Zeitstempel
			>(1, true);
			private Feld<	Zeitstempel
			> _startZeit = new Feld<	Zeitstempel
			>(1, true);
			private Feld<	Zeitstempel
			> _endeZeit = new Feld<	Zeitstempel
			>(1, true);
			@Defaultwert(wert = "Unbekannt")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AttTmcStatus
			 _tmcStatus
			;
			@Defaultwert(wert = "Unbekannt")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AttTmcPrioritaet
			 _tmcPrioritaet
			;
			@Defaultwert(wert = "Nein")
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _ereignisInBeidenRichtungen
			;
			@Defaultwert(wert = "nicht quittiert")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AttTmcBearbeitungsZustand
			 _bearbeitungsZustand
			;
			@Defaultwert(wert = "manuell")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AttTmcErzeugungsart
			 _erzeugungsart
			;
	
		/**
		Zeitpunkt der Erzeugung dieser Daten.
		<p>
		
		</p>
		
		@return der Wert von ErzeugungsZeit.
		*/
			public Feld<	Zeitstempel
			> getErzeugungsZeit() {
			return _erzeugungsZeit;
		}
	
	
		/**
		Zeitpunkt der Aktualisierung dieser Daten.
		<p>
		
		</p>
		
		@return der Wert von AktualisierungsZeit.
		*/
			public Feld<	Zeitstempel
			> getAktualisierungsZeit() {
			return _aktualisierungsZeit;
		}
	
	
		/**
		Zeitpunkt des Beginns des Ereignisses.
		<p>
		
		</p>
		
		@return der Wert von StartZeit.
		*/
			public Feld<	Zeitstempel
			> getStartZeit() {
			return _startZeit;
		}
	
	
		/**
		Zeitpunkt des Endes des Ereignisses (optional).
		<p>
		
		</p>
		
		@return der Wert von EndeZeit.
		*/
			public Feld<	Zeitstempel
			> getEndeZeit() {
			return _endeZeit;
		}
	
	
		/**
		Status.
		<p>
		
		</p>
		
		@return der Wert von TmcStatus.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AttTmcStatus
			 getTmcStatus() {
			return _tmcStatus;
		}
	
		/**
		Status.
		<p>
		
		</p>
		
		@param _tmcStatus der neue Wert von TmcStatus.
		*/
		public void setTmcStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AttTmcStatus
		 _tmcStatus) {
			this._tmcStatus = _tmcStatus;
		}
	
		/**
		Priorität.
		<p>
		Dringlichkeit (Urgency).
		</p>
		
		@return der Wert von TmcPrioritaet.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AttTmcPrioritaet
			 getTmcPrioritaet() {
			return _tmcPrioritaet;
		}
	
		/**
		Priorität.
		<p>
		Dringlichkeit (Urgency).
		</p>
		
		@param _tmcPrioritaet der neue Wert von TmcPrioritaet.
		*/
		public void setTmcPrioritaet(de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AttTmcPrioritaet
		 _tmcPrioritaet) {
			this._tmcPrioritaet = _tmcPrioritaet;
		}
	
		/**
		Das Ereignis ist bi-direktional (ja) oder nicht (nein).
		<p>
		
		</p>
		
		@return der Wert von EreignisInBeidenRichtungen.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getEreignisInBeidenRichtungen() {
			return _ereignisInBeidenRichtungen;
		}
	
		/**
		Das Ereignis ist bi-direktional (ja) oder nicht (nein).
		<p>
		
		</p>
		
		@param _ereignisInBeidenRichtungen der neue Wert von EreignisInBeidenRichtungen.
		*/
		public void setEreignisInBeidenRichtungen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _ereignisInBeidenRichtungen) {
			this._ereignisInBeidenRichtungen = _ereignisInBeidenRichtungen;
		}
	
		/**
		Bearbeitungszustand.
		<p>
		
		</p>
		
		@return der Wert von BearbeitungsZustand.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AttTmcBearbeitungsZustand
			 getBearbeitungsZustand() {
			return _bearbeitungsZustand;
		}
	
		/**
		Bearbeitungszustand.
		<p>
		
		</p>
		
		@param _bearbeitungsZustand der neue Wert von BearbeitungsZustand.
		*/
		public void setBearbeitungsZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AttTmcBearbeitungsZustand
		 _bearbeitungsZustand) {
			this._bearbeitungsZustand = _bearbeitungsZustand;
		}
	
		/**
		Art der Erzeugung dieser Meldung.
		<p>
		
		</p>
		
		@return der Wert von Erzeugungsart.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AttTmcErzeugungsart
			 getErzeugungsart() {
			return _erzeugungsart;
		}
	
		/**
		Art der Erzeugung dieser Meldung.
		<p>
		
		</p>
		
		@param _erzeugungsart der neue Wert von Erzeugungsart.
		*/
		public void setErzeugungsart(de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AttTmcErzeugungsart
		 _erzeugungsart) {
			this._erzeugungsart = _erzeugungsart;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					final Data.TimeArray arrayErzeugungsZeit = datum.getTimeArray("ErzeugungsZeit");
					arrayErzeugungsZeit.setLength(getErzeugungsZeit().size());
					for (int i = 0; i < arrayErzeugungsZeit.getLength(); ++i) {
						arrayErzeugungsZeit.getTimeValue(i).setMillis(getErzeugungsZeit().get(i).getTime());
					}
				// ZeitstempelAttributTyp
					final Data.TimeArray arrayAktualisierungsZeit = datum.getTimeArray("AktualisierungsZeit");
					arrayAktualisierungsZeit.setLength(getAktualisierungsZeit().size());
					for (int i = 0; i < arrayAktualisierungsZeit.getLength(); ++i) {
						arrayAktualisierungsZeit.getTimeValue(i).setMillis(getAktualisierungsZeit().get(i).getTime());
					}
				// ZeitstempelAttributTyp
					final Data.TimeArray arrayStartZeit = datum.getTimeArray("StartZeit");
					arrayStartZeit.setLength(getStartZeit().size());
					for (int i = 0; i < arrayStartZeit.getLength(); ++i) {
						arrayStartZeit.getTimeValue(i).setMillis(getStartZeit().get(i).getTime());
					}
				// ZeitstempelAttributTyp
					final Data.TimeArray arrayEndeZeit = datum.getTimeArray("EndeZeit");
					arrayEndeZeit.setLength(getEndeZeit().size());
					for (int i = 0; i < arrayEndeZeit.getLength(); ++i) {
						arrayEndeZeit.getTimeValue(i).setMillis(getEndeZeit().get(i).getTime());
					}
				// GanzzahlAttributTyp
				if (getTmcStatus() != null) {
	                if (getTmcStatus().isZustand()) {
	                    datum.getUnscaledValue("TmcStatus").setText(getTmcStatus().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("TmcStatus").set(getTmcStatus().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getTmcPrioritaet() != null) {
	                if (getTmcPrioritaet().isZustand()) {
	                    datum.getUnscaledValue("TmcPrioritaet").setText(getTmcPrioritaet().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("TmcPrioritaet").set(getTmcPrioritaet().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getEreignisInBeidenRichtungen() != null) {
	                if (getEreignisInBeidenRichtungen().isZustand()) {
	                    datum.getUnscaledValue("EreignisInBeidenRichtungen").setText(getEreignisInBeidenRichtungen().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("EreignisInBeidenRichtungen").set(getEreignisInBeidenRichtungen().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getBearbeitungsZustand() != null) {
	                if (getBearbeitungsZustand().isZustand()) {
	                    datum.getUnscaledValue("BearbeitungsZustand").setText(getBearbeitungsZustand().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("BearbeitungsZustand").set(getBearbeitungsZustand().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getErzeugungsart() != null) {
	                if (getErzeugungsart().isZustand()) {
	                    datum.getUnscaledValue("Erzeugungsart").setText(getErzeugungsart().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Erzeugungsart").set(getErzeugungsart().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					final Data.Array arrayErzeugungsZeit = daten.getArray("ErzeugungsZeit");
					for (int i = 0; i < arrayErzeugungsZeit.getLength(); ++i) {
							Zeitstempel
						 atl = new 	Zeitstempel
						 (arrayErzeugungsZeit.getItem(i).asTimeValue().getMillis());
						getErzeugungsZeit().add(atl);
					}
				// ZeitstempelAttributTyp
					final Data.Array arrayAktualisierungsZeit = daten.getArray("AktualisierungsZeit");
					for (int i = 0; i < arrayAktualisierungsZeit.getLength(); ++i) {
							Zeitstempel
						 atl = new 	Zeitstempel
						 (arrayAktualisierungsZeit.getItem(i).asTimeValue().getMillis());
						getAktualisierungsZeit().add(atl);
					}
				// ZeitstempelAttributTyp
					final Data.Array arrayStartZeit = daten.getArray("StartZeit");
					for (int i = 0; i < arrayStartZeit.getLength(); ++i) {
							Zeitstempel
						 atl = new 	Zeitstempel
						 (arrayStartZeit.getItem(i).asTimeValue().getMillis());
						getStartZeit().add(atl);
					}
				// ZeitstempelAttributTyp
					final Data.Array arrayEndeZeit = daten.getArray("EndeZeit");
					for (int i = 0; i < arrayEndeZeit.getLength(); ++i) {
							Zeitstempel
						 atl = new 	Zeitstempel
						 (arrayEndeZeit.getItem(i).asTimeValue().getMillis());
						getEndeZeit().add(atl);
					}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("TmcStatus").isState()) {
							setTmcStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AttTmcStatus
							.getZustand(daten.getScaledValue("TmcStatus").getText()));
						} else {
						setTmcStatus(new de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AttTmcStatus
						(daten.
							getUnscaledValue
						("TmcStatus").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("TmcPrioritaet").isState()) {
							setTmcPrioritaet(de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AttTmcPrioritaet
							.getZustand(daten.getScaledValue("TmcPrioritaet").getText()));
						} else {
						setTmcPrioritaet(new de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AttTmcPrioritaet
						(daten.
							getUnscaledValue
						("TmcPrioritaet").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("EreignisInBeidenRichtungen").isState()) {
							setEreignisInBeidenRichtungen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("EreignisInBeidenRichtungen").getText()));
						} else {
						setEreignisInBeidenRichtungen(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("EreignisInBeidenRichtungen").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("BearbeitungsZustand").isState()) {
							setBearbeitungsZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AttTmcBearbeitungsZustand
							.getZustand(daten.getScaledValue("BearbeitungsZustand").getText()));
						} else {
						setBearbeitungsZustand(new de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AttTmcBearbeitungsZustand
						(daten.
							getUnscaledValue
						("BearbeitungsZustand").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Erzeugungsart").isState()) {
							setErzeugungsart(de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AttTmcErzeugungsart
							.getZustand(daten.getScaledValue("Erzeugungsart").getText()));
						} else {
						setErzeugungsart(new de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.attribute.AttTmcErzeugungsart
						(daten.
							getUnscaledValue
						("Erzeugungsart").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTmcVerwaltung clone() {
		AtlTmcVerwaltung klon = new AtlTmcVerwaltung();
		
					klon._erzeugungsZeit = getErzeugungsZeit().clone();
					klon._aktualisierungsZeit = getAktualisierungsZeit().clone();
					klon._startZeit = getStartZeit().clone();
					klon._endeZeit = getEndeZeit().clone();
						klon.setTmcStatus(getTmcStatus());
						klon.setTmcPrioritaet(getTmcPrioritaet());
						klon.setEreignisInBeidenRichtungen(getEreignisInBeidenRichtungen());
						klon.setBearbeitungsZustand(getBearbeitungsZustand());
						klon.setErzeugungsart(getErzeugungsart());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
