/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenerweitert.objekte.impl;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Werte für den Sensor der Taustoffmenge.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class UfdsTaustoffmengeImpl extends AbstractSystemObjekt
	implements de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenerweitert.objekte.UfdsTaustoffmenge { 

	/**
	 * Der Defaultkonstruktor wird für das Erzeugen des Systemobjekts über per
	 * Reflection-API benötigt.
	 */
	public UfdsTaustoffmengeImpl() {
		// tut nix
	}
	
	/**
	 * Initialisierung.
	 * 
	 * @param objekt
	 *            ein beliebiges Systemobjekt.
	 * @param factory
	 *            die Fabrik, die das Systemobjekt angelegt hat.
	 */
	public UfdsTaustoffmengeImpl(final SystemObject objekt, final ObjektFactory factory) {
		super(objekt, factory);
		
		if (!objekt.isOfType(getTyp().getPid())) {
			throw new IllegalArgumentException(
					"Systemobjekt ist kein UfdsTaustoffmenge.");
		}
	}
	
	@Override
	protected String doGetTypPid() {
		return PID;
	}
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenerweitert.onlinedaten.OdUfdsTaustoffmenge getOdUfdsTaustoffmenge() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenerweitert.onlinedaten.OdUfdsTaustoffmenge.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsMessWertErsetzung getPdUfdsMessWertErsetzung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsMessWertErsetzung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenerweitert.parameter.PdUfdsKlassifizierungTaustoffmenge getPdUfdsKlassifizierungTaustoffmenge() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenerweitert.parameter.PdUfdsKlassifizierungTaustoffmenge.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenerweitert.onlinedaten.OdUfdsStufeTaustoffmenge getOdUfdsStufeTaustoffmenge() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenerweitert.onlinedaten.OdUfdsStufeTaustoffmenge.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsAusfallUeberwachung getPdUfdsAusfallUeberwachung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsAusfallUeberwachung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenerweitert.onlinedaten.OdUfdsTaustoffmengeFuzzy getOdUfdsTaustoffmengeFuzzy() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenerweitert.onlinedaten.OdUfdsTaustoffmengeFuzzy.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.konfigurationsdaten.KdUmfeldDatenSensor getKdUmfeldDatenSensor() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.konfigurationsdaten.KdUmfeldDatenSensor.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktLiegtAufLinienObjekt getKdPunktLiegtAufLinienObjekt() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktLiegtAufLinienObjekt.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenerweitert.parameter.PdUfdsDifferenzialKontrolleTaustoffmenge getPdUfdsDifferenzialKontrolleTaustoffmenge() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenerweitert.parameter.PdUfdsDifferenzialKontrolleTaustoffmenge.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenerweitert.parameter.PdUfdsAnstiegAbstiegKontrolleTaustoffmenge getPdUfdsAnstiegAbstiegKontrolleTaustoffmenge() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenerweitert.parameter.PdUfdsAnstiegAbstiegKontrolleTaustoffmenge.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenerweitert.parameter.PdUfdsMeteorologischeKontrolleTaustoffmenge getPdUfdsMeteorologischeKontrolleTaustoffmenge() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenerweitert.parameter.PdUfdsMeteorologischeKontrolleTaustoffmenge.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenerweitert.parameter.PdUfdsAggregationTaustoffmenge getPdUfdsAggregationTaustoffmenge() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenerweitert.parameter.PdUfdsAggregationTaustoffmenge.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenerweitert.parameter.PdUfdsParameterTaustoffmengeFuzzy getPdUfdsParameterTaustoffmengeFuzzy() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenerweitert.parameter.PdUfdsParameterTaustoffmengeFuzzy.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenerweitert.parameter.PdUfdsLangzeitPLPruefungTaustoffmenge getPdUfdsLangzeitPLPruefungTaustoffmenge() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenerweitert.parameter.PdUfdsLangzeitPLPruefungTaustoffmenge.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten getKdPunktKoordinaten() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten.class);
	}
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	
	// Sonderfall Klasse AttributImpl
	 

}
