/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ergebnisse der Ermittlung der Nässestufe.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttNaesseStufe extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Nässestufe konnte nicht ermittelt werden.
	<p>
	
	</p>
	*/
	public static final AttNaesseStufe ZUSTAND_1N_NICHT_ERMITTELBAR = new AttNaesseStufe("nicht ermittelbar", 		Byte
	.valueOf("-1"));

	/**
	Fahrbahn ist trocken.
	<p>
	
	</p>
	*/
	public static final AttNaesseStufe ZUSTAND_0_TROCKEN = new AttNaesseStufe("trocken", 		Byte
	.valueOf("0"));

	/**
	Fahrbahnzustand ist nass1.
	<p>
	
	</p>
	*/
	public static final AttNaesseStufe ZUSTAND_1_NASS1 = new AttNaesseStufe("nass1", 		Byte
	.valueOf("1"));

	/**
	Fahrbahnzustand ist nass2.
	<p>
	
	</p>
	*/
	public static final AttNaesseStufe ZUSTAND_2_NASS2 = new AttNaesseStufe("nass2", 		Byte
	.valueOf("2"));

	/**
	Fahrbahnzustand ist nass3.
	<p>
	
	</p>
	*/
	public static final AttNaesseStufe ZUSTAND_3_NASS3 = new AttNaesseStufe("nass3", 		Byte
	.valueOf("3"));

	/**
	Fahrbahnzustand ist nass4.
	<p>
	
	</p>
	*/
	public static final AttNaesseStufe ZUSTAND_4_NASS4 = new AttNaesseStufe("nass4", 		Byte
	.valueOf("4"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttNaesseStufe getZustand(final 		Byte
	 value) {
		for (AttNaesseStufe e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttNaesseStufe getZustand(final String value) {
		for (AttNaesseStufe e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttNaesseStufe> getZustaende() {
		List<AttNaesseStufe> list = new ArrayList<AttNaesseStufe>();
		list.add(ZUSTAND_1N_NICHT_ERMITTELBAR);
		list.add(ZUSTAND_0_TROCKEN);
		list.add(ZUSTAND_1_NASS1);
		list.add(ZUSTAND_2_NASS2);
		list.add(ZUSTAND_3_NASS3);
		list.add(ZUSTAND_4_NASS4);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut NässeStufe.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttNaesseStufe(final 		Byte
	 value) {
		super(value);
	}
	
	private AttNaesseStufe(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
