/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
EisFilmDicke.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 26
 */
@Wertebereich(
	minimum = 0L,
	maximum = 254L,
	skalierung = 0.01,
	einheit = "mm"
)
public class AttUfdsEisFilmDicke extends Zahl<		Double
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Double
	 MIN_VALUE =
			(		double
			) (		Double
			.valueOf("0") * 		Double
			.valueOf("0.01"));	
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Double
	 MAX_VALUE =
			(		double
			) (		Double
			.valueOf("254") * 		Double
			.valueOf("0.01"));	
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "mm";
	
	/**
	Daten sind nicht ermittelbar (ist KEIN Fehler).
	<p>
	Wird gesetzt, wenn der entsprechende Wert nicht ermittelbar ist und keine Interpolation sinnvoll möglich ist (z.B. ist die Geschwindigkeit nicht ermittelbar, wenn kein Fahrzeug erfasst wurde).
	</p>
	*/
	public static final AttUfdsEisFilmDicke ZUSTAND_1N_NICHT_ERMITTELBAR = new AttUfdsEisFilmDicke("nicht ermittelbar", 		Double
	.valueOf("-1"));

	/**
	Daten sind fehlerhaft.
	<p>
	Wird gesetzt, wenn die Daten als fehlerhaft erkannt wurden.
	</p>
	*/
	public static final AttUfdsEisFilmDicke ZUSTAND_2N_FEHLERHAFT = new AttUfdsEisFilmDicke("fehlerhaft", 		Double
	.valueOf("-2"));

	/**
	Daten nicht ermittelbar, da bereits Basiswerte fehlerhaft.
	<p>
	Wird gesetzt, wenn Daten, die zur Berechnung dieses Werts notwendig sind, bereits als fehlerhaft gekennzeichnet sind, oder wenn die Berechnung aus anderen Gründen (z.B. Nenner = 0 in der Berechnungsformel) nicht möglich war.
	</p>
	*/
	public static final AttUfdsEisFilmDicke ZUSTAND_3N_NICHT_ERMITTELBAR_FEHLERHAFT = new AttUfdsEisFilmDicke("nicht ermittelbar/fehlerhaft", 		Double
	.valueOf("-3"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttUfdsEisFilmDicke getZustand(final 		Double
	 value) {
		for (AttUfdsEisFilmDicke e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttUfdsEisFilmDicke getZustand(final String value) {
		for (AttUfdsEisFilmDicke e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttUfdsEisFilmDicke> getZustaende() {
		List<AttUfdsEisFilmDicke> list = new ArrayList<AttUfdsEisFilmDicke>();
		list.add(ZUSTAND_1N_NICHT_ERMITTELBAR);
		list.add(ZUSTAND_2N_FEHLERHAFT);
		list.add(ZUSTAND_3N_NICHT_ERMITTELBAR_FEHLERHAFT);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut UfdsEisFilmDicke.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttUfdsEisFilmDicke(final 		Double
	 value) {
		super(value);
	}
	
	private AttUfdsEisFilmDicke(final String zustand, final 		Double
	 value) {
		super(zustand, value);
	}
	
}
