/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ergebnisse der Glättewarnung und Prognose.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttUfdsFahrBahnGlaette extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Glättezustand konnte nicht ermittelt werden.
	<p>
	
	</p>
	*/
	public static final AttUfdsFahrBahnGlaette ZUSTAND_1N_NICHT_ERMITTELBAR = new AttUfdsFahrBahnGlaette("nicht ermittelbar", 		Byte
	.valueOf("-1"));

	/**
	Daten sind fehlerhaft.
	<p>
	Wird gesetzt, wenn die Daten als fehlerhaft erkannt wurden.
	</p>
	*/
	public static final AttUfdsFahrBahnGlaette ZUSTAND_2N_FEHLERHAFT = new AttUfdsFahrBahnGlaette("fehlerhaft", 		Byte
	.valueOf("-2"));

	/**
	Daten nicht ermittelbar, da bereits Basiswerte fehlerhaft.
	<p>
	Wird gesetzt, wenn Daten, die zur Berechnung dieses Werts notwendig sind, bereits als fehlerhaft gekennzeichnet sind, oder wenn die Berechnung aus anderen Gründen (z.B. Nenner = 0 in der Berechnungsformel) nicht möglich war.
	</p>
	*/
	public static final AttUfdsFahrBahnGlaette ZUSTAND_3N_NICHT_ERMITTELBAR_FEHLERHAFT = new AttUfdsFahrBahnGlaette("nicht ermittelbar/fehlerhaft", 		Byte
	.valueOf("-3"));

	/**
	Es besteht keine Glättegefahr gleich welcher Art im Prognosehorizont, weil die Fahrbahnoberflächentemperatur über 5°C liegt. Eine Abkühlung im Prognosehorizont bis nahe 0°C stellt bei einer Lufttemperatur über 2°C in den Wintermonaten eine Situation dar, die nur extrem selten auftritt. Hinweis für Schaltungen VBA: Eine evtl. anstehende Glätteanzeige kann zurückgenommen werden. Hinweis für den Winterdienstverantwortlichen: Für den Extremfall eines seltenen aber sehr schnellen Temperaturabfalls mit Gefahr einer Glättebildung sind die Angaben des SWISWetterberichtes und&#47;oder der Verläufe von Messdaten benachbarter GMAMessstellen zu beachten.Glättegefahr bei Wetteränderung möglich Die Fahrbahnoberflächentemperatur liegt gegenwärtig zwischen +2°C und +5°C. Die lineare Trendextrapolation ergibt, dass die Fahrbahnoberflächentemperatur bei der gegenwärtigen Wettersituation im Prognosehorizont nicht unter +2°C sinkt. Eine Wetteränderung kann zu einer kurzfristigen Glättebildung führen. Hinweis für Schaltungen VBA: Das Wettergeschehen ist anhand von Wetterberichten und der Werte benachbarter Messstellen zu beobachten. Eine Schaltung kann nicht empfohlen werden. Eine evtl. vorhandene Schaltung kann zurückgenommen werden. Hinweis für den Winterdienstverantwortlichen: Der SWISWetterbericht oder benachbarte GMAMessstellen sind durchzusehen, ob mit größeren Wetteränderungen gerechnet werden muss.
	<p>
	
	</p>
	*/
	public static final AttUfdsFahrBahnGlaette ZUSTAND_1_KEINE_GLAETTEGEFAHR = new AttUfdsFahrBahnGlaette("Keine Glättegefahr", 		Byte
	.valueOf("1"));

	/**
	Die Fahrbahnoberflächentemperatur liegt zwischen +2 und +5°C und die Fahrbahnoberfläche ist feucht bis nass. Nach der linearen Trendextrapolation ist im Prognosehorizont bei der gegenwärtigen Wettersituation mit einer Fahrbahnoberflächentemperatur unter +2°C zu rechnen. Es besteht die Gefahr eines Überfrierens der Feuchte bzw. Nässe. Hinweis für Schaltungen VBA: Das Wettergeschehen ist anhand von Wetterberichten und der Werte benachbarter Messstellen zu beobachten. Eine Schaltung sollte nur nach Überprüfung der Situation vor Ort durchgeführt werden. Eine evtl. vorhandene Schaltung kann bestehen bleiben. Hinweis für den Winterdienstverantwortlichen: Ein vorbeugender Streueinsatz ist unverzüglich durchzuführen, wenn folgende Aussagen zutreffen: 1. Ein Streueinsatz ist bisher nicht erfolgt. Mit neuem Niederschlag als Regen oder Schnee und einen damit verbundenen Anstieg der Gefriertemperatur ist zu rechnen. 2. Es ist nicht mit einem Abtrocknen der vorhandenen Feuchte oder Nässe vor dem Erreichen der Gefriertemperatur zu rechnen. 3. Es ist nicht mit einem langsameren Absinken oder Ansteigen der Fahrbahnoberflächentemperatur zu rechnen. Die weitere Wetter- und Fahrbahnzustandsentwicklung ist anhand des SWIS-Wetterberichtes und&#47;oder der Verläufe von Messdaten benachbarter GMA-Messstellen einzuschätzen.
	<p>
	
	</p>
	*/
	public static final AttUfdsFahrBahnGlaette ZUSTAND_2_EISGLAETTE_MOEGLICH = new AttUfdsFahrBahnGlaette("Eisglätte möglich", 		Byte
	.valueOf("2"));

	/**
	Die Fahrbahnoberflächentemperatur beträgt zwischen +2°C und +5°C. Eine Trendrechnung kann nicht erfolgen, da die vorhergehenden Daten nicht vorliegen. Es kann die Gefahr bestehen, dass Glätte in irgendeiner Form im Prognosehorizont auftritt. Hinweis für Schaltungen VBA: Das Wettergeschehen ist anhand von Wetterberichten und der Werte benachbarter Messstellen zu beobachten. Eine Schaltung sollte nur nach Überprüfung der Situation vor Ort durchgeführt werden. Eine evtl. vorhandene Schaltung sollte nur dann weiter bestehen bleiben, wenn eine Überprüfung der Situation vor Ort eine Glättesituation bestätigt. Hinweis für den Winterdienstverantwortlichen: Anhand des SWIS-Wetterberichtes und&#47;oder der Verläufe von Messdaten benachbarter GMA-Messstellen ist die weitere Wetter- und Fahrbahnzustandsentwicklung einzuschätzen.
	<p>
	
	</p>
	*/
	public static final AttUfdsFahrBahnGlaette ZUSTAND_3_TENDENZBERECHNUNG_NICHT_MOEGLICH = new AttUfdsFahrBahnGlaette("Tendenzberechnung nicht möglich", 		Byte
	.valueOf("3"));

	/**
	Die Fahrbahnoberflächentemperatur liegt zwischen +2°C und +5°C und die Fahrbahnoberfläche ist trocken. Nach der Trendrechnung kann die Fahrbahnoberflächentemperatur im Prognosehorizont unter +2°C fallen. Bei einsetzendem Niederschlag kann dann Schneeglätte oder Glatteis entstehen. Hinweis für Schaltungen VBA: Das Wettergeschehen ist anhand von Wetterberichten und der Werte benachbarter Messstellen zu beobachten. Eine Schaltung sollte sofort bei Niederschlag (NI&gt;0) bzw. nur nach Überprüfung der Situation vor Ort durchgeführt werden. Eine evtl. vorhandene Schaltung kann bestehen bleiben. Hinweis für den Winterdienstverantwortlichen: Anhand des SWIS-Wetterberichtes und&#47;oder der Messdaten benachbarter GMA-Messstellen ist die Möglichkeit eines Niederschlages und die weitere Entwicklung der Fahrbahnoberflächentemperatur einzuschätzen. Wenn Niederschlag und ein weiterer Abfall der Fahrbahnoberflächentemperatur zu erwarten sind, sind vorbeugende Streueinsätze durchzuführen, sofern nicht bereits erfolgt. Schneeglätte oder Glatteis bei Niederschlag sowie Reifglätte möglich Die Fahrbahnoberflächentemperatur liegt zwischen +2°C und +5°C, und die Fahrbahnoberfläche ist trocken. Nach der Trendrechnung kann die Fahrbahnoberflächentemperatur im Prognosehorizont unter +2°C fallen. Bei einsetzendem Niederschlag kann dann Schneeglätte oder Glatteis entstehen. Die Taupunkttemperatur übersteigt die Fahrbahnoberflächentemperatur. Dadurch besteht gleichzeitig die Gefahr einer vorhandenen oder sich bildenden Reifglätte. Hinweis für Schaltungen VBA: Das Wettergeschehen ist anhand von Wetterberichten und der Werte benachbarter Messstellen zu beobachten. Eine Schaltung sollte sofort bei Niederschlag (NI&gt;0) bzw. nur nach Überprüfung der Situation vor Ort durchgeführt werden. Eine evtl. vorhandene Schaltung kann bestehen bleiben. Hinweis für den Winterdienstverantwortlichen: Anhand des SWIS-Wetterberichtes und&#47;oder der Messdaten benachbarter GMA-Messstellen ist die Möglichkeit eines Niederschlages und die weitere Entwicklung der Fahrbahnoberflächen- und Taupunkttemperatur einzuschätzen. Wenn Niederschlag, ein weiterer Abfall der Fahrbahnoberflächentemperatur und ein weiterer Anstieg der Taupunkttemperatur zu erwarten sind, sind vorbeugende Streueinsätze durchzuführen, sofern nicht bereits erfolgt.
	<p>
	
	</p>
	*/
	public static final AttUfdsFahrBahnGlaette ZUSTAND_4_SCHNEEGLAETTE_ODER_GLATTEIS_BEI_NIEDERSCHLAG_MOEGLICH = new AttUfdsFahrBahnGlaette("Schneeglätte oder Glatteis bei Niederschlag möglich", 		Byte
	.valueOf("4"));

	/**
	Die Fahrbahnoberflächentemperatur liegt unter +2°C und die Fahrbahnoberfläche ist trocken. Bei einsetzendem Niederschlag kann sofort Schneeglätte oder Glatteis entstehen. Hinweis für Schaltungen VBA:Das Wettergeschehen ist anhand von Wetterberichten und der Werte benachbarter Messstellen zu beobachten. Eine Schaltung sollte sofort bei Niederschlag (NI&gt;0 odr WFD&gt;0) bzw. nur nach Überprüfung der Situation vor Ort durchgeführt werden. Eine evtl. vorhandene Schaltung kann bestehen bleiben. Hinweis für den Winterdienstverantwortlichen: Anhand des SWIS-Wetterberichtes und&#47;oder der Messdaten benachbarter GMA-Messstellen ist die Möglichkeit eines Niederschlages und die weitere Entwicklung der Fahrbahnoberflächentemperatur einzuschätzen. Wenn Niederschlag in den nächsten 90 min zu erwarten ist, sind vorbeugende Streueinsätze unverzüglich durchzuführen, sofern nicht bereits erfolgt. Schneeglätte oder Glatteis bei Niederschlag sowie Reifglätte sofort möglich Die Fahrbahnoberflächentemperatur liegt unter +2°C und die Fahrbahnoberfläche ist trocken. Bei einsetzendem Niederschlag kann sofort Schneeglätte oder Glatteis entstehen. Die Taupunkttemperatur übersteigt die Fahrbahnoberflächentemperatur. Dadurch besteht gleichzeitig die Gefahr einer vorhandenen oder sich bildenden Reifglätte. Hinweis für Schaltungen VBA: Das Wettergeschehen ist anhand von Wetterberichten und der Werte benachbarter Messstellen zu beobachten. Eine Schaltung sollte sofort bei Niederschlag (NI&gt;0 odr WFD&gt;0) bzw. nur nach Überprüfung der Situation vor Ort durchgeführt werden. Eine evtl. vorhandene Schaltung kann bestehen bleiben. Hinweis für den Winterdienstverantwortlichen: Sofern nicht bereits Streueinsätze erfolgt sind, sind diese wegen der akuten Reifglättegefahr unverzüglich durchzuführen. Anhand des SWIS-Wetterberichtes und&#47;oder der Messdaten benachbarter GMA-Messstellen ist die Möglichkeit eines Niederschlages und die weitere Entwicklung der Fahrbahnoberflächentemperatur einzuschätzen. Wenn Niederschlag zu erwarten ist, sind gegebenenfalls weitere vorbeugende Streueinsätze unverzüglich durchzuführen, sofern nicht bereits erfolgt.
	<p>
	
	</p>
	*/
	public static final AttUfdsFahrBahnGlaette ZUSTAND_5_SCHNEEGLAETTE_ODER_GLATTEIS_BEI_NIEDERSCHLAG_SOFORT_MOEGLICH = new AttUfdsFahrBahnGlaette("Schneeglätte oder Glatteis bei Niederschlag sofort möglich", 		Byte
	.valueOf("5"));

	/**
	Die Fahrbahnoberflächentemperatur liegt unter +2°C und die Fahrbahnoberfläche ist feucht bzw. nass. Es besteht die unmittelbare Gefahr des Überfrierens dieser Feuchte oder Nässe. Die Gefahr ist besonders groß, wenn weiterer Niederschlag fällt. Das mögliche Vorhandensein von Tausalz auf der Fahrbahnoberfläche wird nicht berücksichtigt. Hinweis für Schaltungen VBA: Das Wettergeschehen ist anhand von Wetterberichten und der Werte benachbarter Messstellen zu beobachten. Eine Schaltung sollte sofort durchgeführt werden. Eine evtl. vorhandene Schaltung kann bestehen bleiben. Hinweis für den Winterdienstverantwortlichen: Wenn nicht bereits ausreichend Tausalz aufgetragen wurde, sind Streueinsätze unverzüglich durchzuführen. Ist anhand des SWIS-Wetterberichtes und&#47;oder der Messdaten benachbarter GMA-Messstellen mit weiterem Niederschlag zu rechnen, sind weitere Streueinsätze durchzuführen.
	<p>
	
	</p>
	*/
	public static final AttUfdsFahrBahnGlaette ZUSTAND_6_EISGLAETTE_SOFORT_MOEGLICH = new AttUfdsFahrBahnGlaette("Eisglätte sofort möglich", 		Byte
	.valueOf("6"));

	/**
	Die Fahrbahnoberflächentemperatur liegt unter +2°C und der Fahrbahnzustandssensor meldet Glätte. Es besteht eine unmittelbare Glättegefahr. Hinweis für Schaltungen VBA: Eine Glätte-Schaltung sollte sofort durchgeführt werden. Eine evtl. vorhandene Schaltung muss bestehen bleiben.
	<p>
	
	</p>
	*/
	public static final AttUfdsFahrBahnGlaette ZUSTAND_7_GLAETTE_VORHANDEN = new AttUfdsFahrBahnGlaette("Glätte vorhanden", 		Byte
	.valueOf("7"));

	/**
	Die Fahrbahnoberflächentemperatur liegt unter +2°C und der Fahrbahnzustandssensor meldet 'Fahrbahn ist bedeckt mit Eis oder Schnee' gemessen. Es besteht eine unmittelbare Glättegefahr. Wenn mindestens 10 min lang keine neuen Daten gemeldet wurden, soll die Meldung 'keine Daten vorhanden' ausgegeben werden. Hinweis für Schaltungen VBA: Eine Glätte-Schaltung sollte sofort durchgeführt werden. Eine evtl. vorhandene Schaltung muss bestehen bleiben. Anmerkung 1: Vorhandenes Tausalz auf der Straße, das zu einer Erniedrigung der Gefriertemperatur führt, berücksichtigt das Modell z.Z. nicht. Anmerkung 2: Das Modell zeigt schon ab einer Fahrbahnoberflächentemperatur von unter +2°C eine Glättewarnung mit akuter Glättegefahr (Glätte sofort möglich) an. Damit sollen einerseits mögliche Messfehler als Fehleinschätzung ausgeschlossen werden. Andererseits darf der angezeigte Messwert nur für einen Punkt im Fahrbahnnetz angesehen werden, in dessen näheren Umgebung eine andere Temperatur auftreten kann. Das Modell kann Situationen an anderen Punkten des Straßennetzes nicht einschätzen. Hier ist die Kenntnis des Verhaltens der umliegenden Streckenabschnitte bei den verschiedenen Wettersituationen von großer Bedeutung. Deutliche Differenzen bei der Fahrbahnoberflächentemperatur werden bei unterschiedlicher Bewölkung oder Beschattung schon zwischen wenig entfernt liegenden Streckenabschnitten auftreten. Anmerkung 3: Die Auswirkungen von unterschiedlichen Fahrbahnbeläge auf eine mögliche Glättebildung muss noch untersucht werden.
	<p>
	
	</p>
	*/
	public static final AttUfdsFahrBahnGlaette ZUSTAND_8_EIS_ODER_SCHNEE_AUF_DER_FAHRBAHN = new AttUfdsFahrBahnGlaette("Eis oder Schnee auf der Fahrbahn", 		Byte
	.valueOf("8"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttUfdsFahrBahnGlaette getZustand(final 		Byte
	 value) {
		for (AttUfdsFahrBahnGlaette e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttUfdsFahrBahnGlaette getZustand(final String value) {
		for (AttUfdsFahrBahnGlaette e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttUfdsFahrBahnGlaette> getZustaende() {
		List<AttUfdsFahrBahnGlaette> list = new ArrayList<AttUfdsFahrBahnGlaette>();
		list.add(ZUSTAND_1N_NICHT_ERMITTELBAR);
		list.add(ZUSTAND_2N_FEHLERHAFT);
		list.add(ZUSTAND_3N_NICHT_ERMITTELBAR_FEHLERHAFT);
		list.add(ZUSTAND_1_KEINE_GLAETTEGEFAHR);
		list.add(ZUSTAND_2_EISGLAETTE_MOEGLICH);
		list.add(ZUSTAND_3_TENDENZBERECHNUNG_NICHT_MOEGLICH);
		list.add(ZUSTAND_4_SCHNEEGLAETTE_ODER_GLATTEIS_BEI_NIEDERSCHLAG_MOEGLICH);
		list.add(ZUSTAND_5_SCHNEEGLAETTE_ODER_GLATTEIS_BEI_NIEDERSCHLAG_SOFORT_MOEGLICH);
		list.add(ZUSTAND_6_EISGLAETTE_SOFORT_MOEGLICH);
		list.add(ZUSTAND_7_GLAETTE_VORHANDEN);
		list.add(ZUSTAND_8_EIS_ODER_SCHNEE_AUF_DER_FAHRBAHN);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut UfdsFahrBahnGlätte.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttUfdsFahrBahnGlaette(final 		Byte
	 value) {
		super(value);
	}
	
	private AttUfdsFahrBahnGlaette(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
