/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zustand der Fahrbahnoberfläche.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttUfdsFahrBahnOberFlaechenZustand extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Daten sind nicht ermittelbar (ist KEIN Fehler).
	<p>
	Wird gesetzt, wenn der entsprechende Wert nicht ermittelbar ist und kein Interpolation sinnvoll möglich ist (z.B. ist die Geschwindigkeit nicht ermittelbar, wenn kein Fahrzeug erfasst wurde).
	</p>
	*/
	public static final AttUfdsFahrBahnOberFlaechenZustand ZUSTAND_1N_NICHT_ERMITTELBAR = new AttUfdsFahrBahnOberFlaechenZustand("nicht ermittelbar", 		Byte
	.valueOf("-1"));

	/**
	Daten sind fehlerhaft.
	<p>
	Wird gesetzt, wenn die Daten als fehlerhaft erkannt wurden.
	</p>
	*/
	public static final AttUfdsFahrBahnOberFlaechenZustand ZUSTAND_2N_FEHLERHAFT = new AttUfdsFahrBahnOberFlaechenZustand("fehlerhaft", 		Byte
	.valueOf("-2"));

	/**
	Daten nicht ermittelbar, da bereits Basiswerte fehlerhaft.
	<p>
	Wird gesetzt, wenn Daten, die zur Berechnung dieses Werts notwendig sind, bereits als fehlerhaft gekennzeichnet sind, oder wenn die Berechnung aus anderen Gründen (z.B. Nenner = 0 in der Berechnungsformel) nicht möglich war.
	</p>
	*/
	public static final AttUfdsFahrBahnOberFlaechenZustand ZUSTAND_3N_NICHT_ERMITTELBAR_FEHLERHAFT = new AttUfdsFahrBahnOberFlaechenZustand("nicht ermittelbar/fehlerhaft", 		Byte
	.valueOf("-3"));

	/**
	Fahrbahn ist vollkommen Trocken (kleiner ca. 30 ml&#47;m2 = 0,03 mm), schnee- und eisfrei.
	<p>
	
	</p>
	*/
	public static final AttUfdsFahrBahnOberFlaechenZustand ZUSTAND_0_TROCKEN = new AttUfdsFahrBahnOberFlaechenZustand("trocken", 		Byte
	.valueOf("0"));

	/**
	Fahrbahn ist feucht bzw. nass, oder schnee- oder eisbedeckt.
	<p>
	Fahrbahn ist feucht bzw. nass, oder schnee- oder eisbedeckt. Die Benetzung bzw. Bedeckung übersteigt ca. 30 ml&#47;m2 = 0,03 mm. Nähere Differenzierung der Bedeckungsart nicht möglich.
	</p>
	*/
	public static final AttUfdsFahrBahnOberFlaechenZustand ZUSTAND_1_FEUCHT = new AttUfdsFahrBahnOberFlaechenZustand("feucht", 		Byte
	.valueOf("1"));

	/**
	Fahrbahn ist benetzt mit flüssigem Wasser bzw. wässriger Lösung.
	<p>
	Die Menge übersteigt ca. 30 ml&#47;m2 = 0,03 mm. Nähere Differenzierung nicht möglich.
	</p>
	*/
	public static final AttUfdsFahrBahnOberFlaechenZustand ZUSTAND_32_NASS = new AttUfdsFahrBahnOberFlaechenZustand("nass", 		Byte
	.valueOf("32"));

	/**
	Fahrbahn ist bedeckt mit gefrorenem Wasser bzw. wässriger Lösung in festem Zustand. Weitere Differenzierung nicht möglich.
	<p>
	
	</p>
	*/
	public static final AttUfdsFahrBahnOberFlaechenZustand ZUSTAND_64_GEFRORENES_WASSER = new AttUfdsFahrBahnOberFlaechenZustand("gefrorenes Wasser", 		Byte
	.valueOf("64"));

	/**
	Fahrbahn ist bedeckt mit Schnee oder Schneematsch. Gemisch von flüssigem und gefrorenem Wasser bzw. wässriger Lösung.
	<p>
	
	</p>
	*/
	public static final AttUfdsFahrBahnOberFlaechenZustand ZUSTAND_65_SCHNEE_SCHNEEMATSCH = new AttUfdsFahrBahnOberFlaechenZustand("Schnee/Schneematsch", 		Byte
	.valueOf("65"));

	/**
	Fahrbahn ist bedeckt mit Eis (festes, gefrorenes Wasser bzw. gefrorene wässrige Lösung).
	<p>
	
	</p>
	*/
	public static final AttUfdsFahrBahnOberFlaechenZustand ZUSTAND_66_EIS = new AttUfdsFahrBahnOberFlaechenZustand("Eis", 		Byte
	.valueOf("66"));

	/**
	Fahrbahn ist bedeckt mit Rauhreif.
	<p>
	Fahrbahn ist bedeckt mit Rauhreif. Aus der Luft sublimierte Eiskristalle ohne deckende Eisfläche. Die Taupunkttemperatur liegt nahe der Fahrbahnoberflächen- Temperatur und liegt unter der Gefriertemperatur.
	</p>
	*/
	public static final AttUfdsFahrBahnOberFlaechenZustand ZUSTAND_67_RAUREIF = new AttUfdsFahrBahnOberFlaechenZustand("Raureif", 		Byte
	.valueOf("67"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttUfdsFahrBahnOberFlaechenZustand getZustand(final 		Byte
	 value) {
		for (AttUfdsFahrBahnOberFlaechenZustand e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttUfdsFahrBahnOberFlaechenZustand getZustand(final String value) {
		for (AttUfdsFahrBahnOberFlaechenZustand e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttUfdsFahrBahnOberFlaechenZustand> getZustaende() {
		List<AttUfdsFahrBahnOberFlaechenZustand> list = new ArrayList<AttUfdsFahrBahnOberFlaechenZustand>();
		list.add(ZUSTAND_1N_NICHT_ERMITTELBAR);
		list.add(ZUSTAND_2N_FEHLERHAFT);
		list.add(ZUSTAND_3N_NICHT_ERMITTELBAR_FEHLERHAFT);
		list.add(ZUSTAND_0_TROCKEN);
		list.add(ZUSTAND_1_FEUCHT);
		list.add(ZUSTAND_32_NASS);
		list.add(ZUSTAND_64_GEFRORENES_WASSER);
		list.add(ZUSTAND_65_SCHNEE_SCHNEEMATSCH);
		list.add(ZUSTAND_66_EIS);
		list.add(ZUSTAND_67_RAUREIF);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut UfdsFahrBahnOberFlächenZustand.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttUfdsFahrBahnOberFlaechenZustand(final 		Byte
	 value) {
		super(value);
	}
	
	private AttUfdsFahrBahnOberFlaechenZustand(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
