/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zu verwendender Operator zum Vergleich des Messwerts mit einem Grenzwert.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 5
 */
public class AttUfdsVergleichsOperator extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Die Bedinung ist nicht zu prüfen und immer als nicht erfüllt zu betrachten. Die davon abhängingen weiteren Schritte sind also nicht durchzuführen.
	<p>
	
	</p>
	*/
	public static final AttUfdsVergleichsOperator ZUSTAND_0_BEDINGUNGIMMERFALSCH = new AttUfdsVergleichsOperator("BedingungImmerFalsch", 		Byte
	.valueOf("0"));

	/**
	Die Bedinung ist nicht zu prüfen und immer als erfüllt zu betrachten. Die davon abhängingen weiteren Schritte sind also immer durchzuführen.
	<p>
	
	</p>
	*/
	public static final AttUfdsVergleichsOperator ZUSTAND_1_BEDINGUNGIMMERWAHR = new AttUfdsVergleichsOperator("BedingungImmerWahr", 		Byte
	.valueOf("1"));

	/**
	Operator zur Prüfung der Bedingung ist '&lt;'.
	<p>
	
	</p>
	*/
	public static final AttUfdsVergleichsOperator ZUSTAND_2_KLEINER = new AttUfdsVergleichsOperator("kleiner", 		Byte
	.valueOf("2"));

	/**
	Operator zur Prüfung der Bedingung ist '&lt;='.
	<p>
	
	</p>
	*/
	public static final AttUfdsVergleichsOperator ZUSTAND_3_KLEINERGLEICH = new AttUfdsVergleichsOperator("kleinerGleich", 		Byte
	.valueOf("3"));

	/**
	Operator zur Prüfung der Bedingung ist '='.
	<p>
	
	</p>
	*/
	public static final AttUfdsVergleichsOperator ZUSTAND_4_GLEICH = new AttUfdsVergleichsOperator("gleich", 		Byte
	.valueOf("4"));

	/**
	Operator zur Prüfung der Bedingung ist '&gt;='.
	<p>
	
	</p>
	*/
	public static final AttUfdsVergleichsOperator ZUSTAND_5_GROESSERGLEICH = new AttUfdsVergleichsOperator("größerGleich", 		Byte
	.valueOf("5"));

	/**
	Operator zur Prüfung der Bedingung ist '&gt;'.
	<p>
	
	</p>
	*/
	public static final AttUfdsVergleichsOperator ZUSTAND_6_GROESSER = new AttUfdsVergleichsOperator("größer", 		Byte
	.valueOf("6"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttUfdsVergleichsOperator getZustand(final 		Byte
	 value) {
		for (AttUfdsVergleichsOperator e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttUfdsVergleichsOperator getZustand(final String value) {
		for (AttUfdsVergleichsOperator e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttUfdsVergleichsOperator> getZustaende() {
		List<AttUfdsVergleichsOperator> list = new ArrayList<AttUfdsVergleichsOperator>();
		list.add(ZUSTAND_0_BEDINGUNGIMMERFALSCH);
		list.add(ZUSTAND_1_BEDINGUNGIMMERWAHR);
		list.add(ZUSTAND_2_KLEINER);
		list.add(ZUSTAND_3_KLEINERGLEICH);
		list.add(ZUSTAND_4_GLEICH);
		list.add(ZUSTAND_5_GROESSERGLEICH);
		list.add(ZUSTAND_6_GROESSER);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut Operator.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttUfdsVergleichsOperator(final 		Byte
	 value) {
		super(value);
	}
	
	private AttUfdsVergleichsOperator(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
