/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Werte für den Sensor der NiederschlagsIntensität.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface UfdsNiederschlagsIntensitaet extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.ufdsNiederschlagsIntensität"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Parameter zur Messwertersetzung.
	<p>
	
	</p>
	@return der Datensatz UfdsMessWertErsetzung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsMessWertErsetzung getPdUfdsMessWertErsetzung();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Aus dem Sensorwert über die exponentielle Glättung und die Klassifizierung mit Hysterese ermittelte Stufe (Abbildung eines kontinuierlichen Sensorwertes auf eine diskrete Stufe).
	<p>
	
	</p>
	@return der Datensatz UfdsStufeNiederschlagsIntensitaet.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsStufeNiederschlagsIntensitaet getOdUfdsStufeNiederschlagsIntensitaet();
	
	/**
	Parameter für die Anstieg-Abstieg-Kontrolle (Prüfung, ob die Änderungsgeschwindigkeit zweier aufeinander folgender Sensorwerte unterhalb einer parametrierbaren Grenze liegt).
	<p>
	
	</p>
	@return der Datensatz UfdsAnstiegAbstiegKontrolleNiederschlagsIntensitaet.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsAnstiegAbstiegKontrolleNiederschlagsIntensitaet getPdUfdsAnstiegAbstiegKontrolleNiederschlagsIntensitaet();
	
	/**
	Parameter zur Messwertersetzung.
	<p>
	
	</p>
	@return der Datensatz UfdsAusfallUeberwachung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsAusfallUeberwachung getPdUfdsAusfallUeberwachung();
	
	/**
	Niederschlagsintensität als lingustische Variable.
	<p>
	
	</p>
	@return der Datensatz UfdsNiederschlagsIntensitaetFuzzy.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsNiederschlagsIntensitaetFuzzy getOdUfdsNiederschlagsIntensitaetFuzzy();
	
	/**
	Parameter für die Langzeit-PL-Prüfung des Sensorwertes. Neben der Prüfung für das eingestellte Vergleichsintervall wird zusätzlich auch die PL-Prüfung jeweils für den Tag durchgeführt. Die zusätzlichen Parameter gelten somit sowohl für das Tagesintervall als auch für das Vergleichsintervall.
	<p>
	
	</p>
	@return der Datensatz UfdsLangzeitPLPruefungNiederschlagsIntensitaet.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsLangzeitPLPruefungNiederschlagsIntensitaet getPdUfdsLangzeitPLPruefungNiederschlagsIntensitaet();
	
	/**
	Fuzzy-Set (Parameter) für Niederschlagsintensität.
	<p>
	
	</p>
	@return der Datensatz UfdsParameterNiederschlagsIntensitaetFuzzy.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsParameterNiederschlagsIntensitaetFuzzy getPdUfdsParameterNiederschlagsIntensitaetFuzzy();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz UmfeldDatenSensor.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.konfigurationsdaten.KdUmfeldDatenSensor getKdUmfeldDatenSensor();
	
	/**
	Parameter mit den Hysteresschwellwerten zur Abbildung des Sensorwertes auf eine Stufe.
	<p>
	
	</p>
	@return der Datensatz UfdsKlassifizierungNiederschlagsIntensitaet.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsKlassifizierungNiederschlagsIntensitaet getPdUfdsKlassifizierungNiederschlagsIntensitaet();
	
	/**
	Referenz auf ein Linienobjekt mit Offsetangabe vom Begin der Linie. Darüber läßt sich dessen Koordinate ermitteln. Liegen mehrer Objekte auf einem Linienobjekt, läßt sich über die Offsets die Topologie ermitteln.
	<p>
	
	</p>
	@return der Datensatz PunktLiegtAufLinienObjekt.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktLiegtAufLinienObjekt getKdPunktLiegtAufLinienObjekt();
	
	/**
	Parameter für die Grenzwertprüfung der Niederschlagsintensität.
	<p>
	
	</p>
	@return der Datensatz UfdsGrenzwerteNiederschlagsIntensitaet.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsGrenzwerteNiederschlagsIntensitaet getPdUfdsGrenzwerteNiederschlagsIntensitaet();
	
	/**
	Parameter für die meteorologische Kontrolle des Sensorwertes (Prüfung, ob Sensorwert sinnvolle Ergebnisse im Vergleich mit meteorologisch vergleichbaren Sensoren liefert).
	<p>
	
	</p>
	@return der Datensatz UfdsMeteorologischeKontrolleNiederschlagsIntensitaet.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsMeteorologischeKontrolleNiederschlagsIntensitaet getPdUfdsMeteorologischeKontrolleNiederschlagsIntensitaet();
	
	/**
	Parameter für die Differentialkontrolle (Prüfung. ob Sensorwert innerhalb eines parametrierbaren Zeitbereichs Schwankungen aufweist, ansonsten ist Sensorwert inplausibel).
	<p>
	
	</p>
	@return der Datensatz UfdsDifferenzialKontrolleNiederschlagsIntensitaet.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsDifferenzialKontrolleNiederschlagsIntensitaet getPdUfdsDifferenzialKontrolleNiederschlagsIntensitaet();
	
	/**
	Parameter zur exponentiellen Glättung mit wanderndem Abweichungswinkel für den Sensorwert. Geglätteter Wert wird zur Bildung der Sensorwert-Stufe verwendet.
	<p>
	
	</p>
	@return der Datensatz UfdsAggregationNiederschlagsIntensitaet.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsAggregationNiederschlagsIntensitaet getPdUfdsAggregationNiederschlagsIntensitaet();
	
	/**
	Sensorwert.
	<p>
	
	</p>
	@return der Datensatz UfdsNiederschlagsIntensitaet.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsNiederschlagsIntensitaet getOdUfdsNiederschlagsIntensitaet();
	
	/**
	Koordinaten eines Punktes in Grad entsprechend WGS84.
	<p>
	
	</p>
	@return der Datensatz PunktKoordinaten.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten getKdPunktKoordinaten();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
