/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter mit den Hysteresschwellwerten zur Abbildung des Sensorwertes auf eine Stufe.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 25
 */
public class PdUfdsKlassifizierungWasserFilmDicke extends AbstractParameterDatensatz<PdUfdsKlassifizierungWasserFilmDicke.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungWasserFilmDicke
				> _klassifizierungWasserFilmDicke = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungWasserFilmDicke
				>(0, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungWasserFilmDicke
				> _klassifizierungWasserFilmDickeRegen = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungWasserFilmDicke
				>(0, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungWasserFilmDicke
				> _klassifizierungWasserFilmDickeSchnee = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungWasserFilmDicke
				>(0, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungWasserFilmDicke
				> _klassifizierungWasserFilmDickePlatzregen = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungWasserFilmDicke
				>(0, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungWasserFilmDicke
				> _klassifizierungWasserFilmDickeGlaette = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungWasserFilmDicke
				>(0, true);
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Parametersatz zur Festlegung der Hysteresegrenzwerte für die Klassifizierung von Sensorwerten mittels Hysterese. (Default-Werte unabhängig von der NI-FBZ-Klasse).
			<p>
			
			</p>
			
			@return der Wert von KlassifizierungWasserFilmDicke.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungWasserFilmDicke
				> getKlassifizierungWasserFilmDicke() {
				return _klassifizierungWasserFilmDicke;
			}
		
		
			/**
			Parametersatz zur Festlegung der Hysteresegrenzwerte für die Klassifizierung von Sensorwerten mittels Hysterese bei NI-FBZ-Klasse Regen. Falls leer werden die Default-Werte benutzt.
			<p>
			
			</p>
			
			@return der Wert von KlassifizierungWasserFilmDickeRegen.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungWasserFilmDicke
				> getKlassifizierungWasserFilmDickeRegen() {
				return _klassifizierungWasserFilmDickeRegen;
			}
		
		
			/**
			Parametersatz zur Festlegung der Hysteresegrenzwerte für die Klassifizierung von Sensorwerten mittels Hysterese bei NI-FBZ-Klasse Schnee. Falls leer werden die Default-Werte benutzt.
			<p>
			
			</p>
			
			@return der Wert von KlassifizierungWasserFilmDickeSchnee.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungWasserFilmDicke
				> getKlassifizierungWasserFilmDickeSchnee() {
				return _klassifizierungWasserFilmDickeSchnee;
			}
		
		
			/**
			Parametersatz zur Festlegung der Hysteresegrenzwerte für die Klassifizierung von Sensorwerten mittels Hysterese bei NI-FBZ-Klasse Platzregen. Falls leer werden die Default-Werte benutzt.
			<p>
			
			</p>
			
			@return der Wert von KlassifizierungWasserFilmDickePlatzregen.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungWasserFilmDicke
				> getKlassifizierungWasserFilmDickePlatzregen() {
				return _klassifizierungWasserFilmDickePlatzregen;
			}
		
		
			/**
			Parametersatz zur Festlegung der Hysteresegrenzwerte für die Klassifizierung von Sensorwerten mittels Hystereseb ei NI-FBZ-Klasse Glätte. Falls leer werden die Default-Werte benutzt.
			<p>
			
			</p>
			
			@return der Wert von KlassifizierungWasserFilmDickeGlaette.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungWasserFilmDicke
				> getKlassifizierungWasserFilmDickeGlaette() {
				return _klassifizierungWasserFilmDickeGlaette;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// AttributListenDefinition
						final Data.Array arrayKlassifizierungWasserFilmDicke = datum.getArray("KlassifizierungWasserFilmDicke");
						arrayKlassifizierungWasserFilmDicke.setLength(getKlassifizierungWasserFilmDicke().size());
						for (int i = 0; i < arrayKlassifizierungWasserFilmDicke.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungWasserFilmDicke
							 atl = getKlassifizierungWasserFilmDicke().get(i);
							atl.bean2Atl(arrayKlassifizierungWasserFilmDicke.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayKlassifizierungWasserFilmDickeRegen = datum.getArray("KlassifizierungWasserFilmDickeRegen");
						arrayKlassifizierungWasserFilmDickeRegen.setLength(getKlassifizierungWasserFilmDickeRegen().size());
						for (int i = 0; i < arrayKlassifizierungWasserFilmDickeRegen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungWasserFilmDicke
							 atl = getKlassifizierungWasserFilmDickeRegen().get(i);
							atl.bean2Atl(arrayKlassifizierungWasserFilmDickeRegen.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayKlassifizierungWasserFilmDickeSchnee = datum.getArray("KlassifizierungWasserFilmDickeSchnee");
						arrayKlassifizierungWasserFilmDickeSchnee.setLength(getKlassifizierungWasserFilmDickeSchnee().size());
						for (int i = 0; i < arrayKlassifizierungWasserFilmDickeSchnee.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungWasserFilmDicke
							 atl = getKlassifizierungWasserFilmDickeSchnee().get(i);
							atl.bean2Atl(arrayKlassifizierungWasserFilmDickeSchnee.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayKlassifizierungWasserFilmDickePlatzregen = datum.getArray("KlassifizierungWasserFilmDickePlatzregen");
						arrayKlassifizierungWasserFilmDickePlatzregen.setLength(getKlassifizierungWasserFilmDickePlatzregen().size());
						for (int i = 0; i < arrayKlassifizierungWasserFilmDickePlatzregen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungWasserFilmDicke
							 atl = getKlassifizierungWasserFilmDickePlatzregen().get(i);
							atl.bean2Atl(arrayKlassifizierungWasserFilmDickePlatzregen.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayKlassifizierungWasserFilmDickeGlaette = datum.getArray("KlassifizierungWasserFilmDickeGlätte");
						arrayKlassifizierungWasserFilmDickeGlaette.setLength(getKlassifizierungWasserFilmDickeGlaette().size());
						for (int i = 0; i < arrayKlassifizierungWasserFilmDickeGlaette.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungWasserFilmDicke
							 atl = getKlassifizierungWasserFilmDickeGlaette().get(i);
							atl.bean2Atl(arrayKlassifizierungWasserFilmDickeGlaette.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// AttributListenDefinition
						final Data.Array arrayKlassifizierungWasserFilmDicke = daten.getArray("KlassifizierungWasserFilmDicke");
						for (int i = 0; i < arrayKlassifizierungWasserFilmDicke.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungWasserFilmDicke
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungWasserFilmDicke
							 ();
							atl.atl2Bean(arrayKlassifizierungWasserFilmDicke.getItem(i), factory);
							getKlassifizierungWasserFilmDicke().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayKlassifizierungWasserFilmDickeRegen = daten.getArray("KlassifizierungWasserFilmDickeRegen");
						for (int i = 0; i < arrayKlassifizierungWasserFilmDickeRegen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungWasserFilmDicke
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungWasserFilmDicke
							 ();
							atl.atl2Bean(arrayKlassifizierungWasserFilmDickeRegen.getItem(i), factory);
							getKlassifizierungWasserFilmDickeRegen().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayKlassifizierungWasserFilmDickeSchnee = daten.getArray("KlassifizierungWasserFilmDickeSchnee");
						for (int i = 0; i < arrayKlassifizierungWasserFilmDickeSchnee.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungWasserFilmDicke
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungWasserFilmDicke
							 ();
							atl.atl2Bean(arrayKlassifizierungWasserFilmDickeSchnee.getItem(i), factory);
							getKlassifizierungWasserFilmDickeSchnee().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayKlassifizierungWasserFilmDickePlatzregen = daten.getArray("KlassifizierungWasserFilmDickePlatzregen");
						for (int i = 0; i < arrayKlassifizierungWasserFilmDickePlatzregen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungWasserFilmDicke
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungWasserFilmDicke
							 ();
							atl.atl2Bean(arrayKlassifizierungWasserFilmDickePlatzregen.getItem(i), factory);
							getKlassifizierungWasserFilmDickePlatzregen().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayKlassifizierungWasserFilmDickeGlaette = daten.getArray("KlassifizierungWasserFilmDickeGlätte");
						for (int i = 0; i < arrayKlassifizierungWasserFilmDickeGlaette.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungWasserFilmDicke
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsKlassifizierungWasserFilmDicke
							 ();
							atl.atl2Bean(arrayKlassifizierungWasserFilmDickeGlaette.getItem(i), factory);
							getKlassifizierungWasserFilmDickeGlaette().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
						klon._klassifizierungWasserFilmDicke = getKlassifizierungWasserFilmDicke().clone();
						klon._klassifizierungWasserFilmDickeRegen = getKlassifizierungWasserFilmDickeRegen().clone();
						klon._klassifizierungWasserFilmDickeSchnee = getKlassifizierungWasserFilmDickeSchnee().clone();
						klon._klassifizierungWasserFilmDickePlatzregen = getKlassifizierungWasserFilmDickePlatzregen().clone();
						klon._klassifizierungWasserFilmDickeGlaette = getKlassifizierungWasserFilmDickeGlaette().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.ufdsKlassifizierungWasserFilmDicke";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdUfdsKlassifizierungWasserFilmDicke(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
