/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter für die meteorologische Kontrolle des Sensorwertes (Prüfung, ob Sensorwert sinnvolle Ergebnisse im Vergleich mit meteorologisch vergleichbaren Sensoren liefert).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 25
 */
public class PdUfdsMeteorologischeKontrolleNiederschlagsArt extends AbstractParameterDatensatz<PdUfdsMeteorologischeKontrolleNiederschlagsArt.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsLuftTemperatur
				 _nSGrenzLT
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRelativeLuftFeuchte
				 _nSGrenzTrockenRLF
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsIntensitaet
				 _nSminNI
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRelativeLuftFeuchte
				 _nSGrenzRLF
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Wenn NS = 'Regen' und LT &lt; NSGrenzLT, dann NS implausibel.
			<p>
			
			</p>
			
			@return der Wert von NSGrenzLT.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsLuftTemperatur
				 getNSGrenzLT() {
				return _nSGrenzLT;
			}
		
			/**
			Wenn NS = 'Regen' und LT &lt; NSGrenzLT, dann NS implausibel.
			<p>
			
			</p>
			
			@param _nSGrenzLT der neue Wert von NSGrenzLT.
			*/
			public void setNSGrenzLT(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsLuftTemperatur
			 _nSGrenzLT) {
				this._nSGrenzLT = _nSGrenzLT;
			}
		
			/**
			Wenn NS = 'Niederschlag' und NI = 0 mm&#47;h und RLF &lt; NSGrenzTrockenRLF, dann NS implausibel.
			<p>
			
			</p>
			
			@return der Wert von NSGrenzTrockenRLF.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRelativeLuftFeuchte
				 getNSGrenzTrockenRLF() {
				return _nSGrenzTrockenRLF;
			}
		
			/**
			Wenn NS = 'Niederschlag' und NI = 0 mm&#47;h und RLF &lt; NSGrenzTrockenRLF, dann NS implausibel.
			<p>
			
			</p>
			
			@param _nSGrenzTrockenRLF der neue Wert von NSGrenzTrockenRLF.
			*/
			public void setNSGrenzTrockenRLF(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRelativeLuftFeuchte
			 _nSGrenzTrockenRLF) {
				this._nSGrenzTrockenRLF = _nSGrenzTrockenRLF;
			}
		
			/**
			Wenn NS='kein Niederschlag' und NI &gt;NSminNI und RLF&gt;NSGrenzNassRLF, dann NS implausibel.
			<p>
			
			</p>
			
			@return der Wert von NSminNI.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsIntensitaet
				 getNSminNI() {
				return _nSminNI;
			}
		
			/**
			Wenn NS='kein Niederschlag' und NI &gt;NSminNI und RLF&gt;NSGrenzNassRLF, dann NS implausibel.
			<p>
			
			</p>
			
			@param _nSminNI der neue Wert von NSminNI.
			*/
			public void setNSminNI(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsIntensitaet
			 _nSminNI) {
				this._nSminNI = _nSminNI;
			}
		
			/**
			Wenn NS = 'kein Niederschlag' und NI &gt; NSminNI und RLF &gt; NSGrenzNassRLF, dann NS implausibel.
			<p>
			
			</p>
			
			@return der Wert von NSGrenzRLF.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRelativeLuftFeuchte
				 getNSGrenzRLF() {
				return _nSGrenzRLF;
			}
		
			/**
			Wenn NS = 'kein Niederschlag' und NI &gt; NSminNI und RLF &gt; NSGrenzNassRLF, dann NS implausibel.
			<p>
			
			</p>
			
			@param _nSGrenzRLF der neue Wert von NSGrenzRLF.
			*/
			public void setNSGrenzRLF(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRelativeLuftFeuchte
			 _nSGrenzRLF) {
				this._nSGrenzRLF = _nSGrenzRLF;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getNSGrenzLT() != null) {
		                if (getNSGrenzLT().isZustand()) {
		                    datum.getUnscaledValue("NSGrenzLT").setText(getNSGrenzLT().toString());
		                } else {
							datum.
							getScaledValue
		                	("NSGrenzLT").set(getNSGrenzLT().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getNSGrenzTrockenRLF() != null) {
		                if (getNSGrenzTrockenRLF().isZustand()) {
		                    datum.getUnscaledValue("NSGrenzTrockenRLF").setText(getNSGrenzTrockenRLF().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("NSGrenzTrockenRLF").set(getNSGrenzTrockenRLF().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getNSminNI() != null) {
		                if (getNSminNI().isZustand()) {
		                    datum.getUnscaledValue("NSminNI").setText(getNSminNI().toString());
		                } else {
							datum.
							getScaledValue
		                	("NSminNI").set(getNSminNI().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getNSGrenzRLF() != null) {
		                if (getNSGrenzRLF().isZustand()) {
		                    datum.getUnscaledValue("NSGrenzRLF").setText(getNSGrenzRLF().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("NSGrenzRLF").set(getNSGrenzRLF().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("NSGrenzLT").isState()) {
								setNSGrenzLT(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsLuftTemperatur
								.getZustand(daten.getScaledValue("NSGrenzLT").getText()));
							} else {
							setNSGrenzLT(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsLuftTemperatur
							(daten.
								getScaledValue
							("NSGrenzLT").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("NSGrenzTrockenRLF").isState()) {
								setNSGrenzTrockenRLF(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRelativeLuftFeuchte
								.getZustand(daten.getScaledValue("NSGrenzTrockenRLF").getText()));
							} else {
							setNSGrenzTrockenRLF(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRelativeLuftFeuchte
							(daten.
								getUnscaledValue
							("NSGrenzTrockenRLF").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("NSminNI").isState()) {
								setNSminNI(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsIntensitaet
								.getZustand(daten.getScaledValue("NSminNI").getText()));
							} else {
							setNSminNI(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsNiederschlagsIntensitaet
							(daten.
								getScaledValue
							("NSminNI").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("NSGrenzRLF").isState()) {
								setNSGrenzRLF(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRelativeLuftFeuchte
								.getZustand(daten.getScaledValue("NSGrenzRLF").getText()));
							} else {
							setNSGrenzRLF(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsRelativeLuftFeuchte
							(daten.
								getUnscaledValue
							("NSGrenzRLF").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setNSGrenzLT(getNSGrenzLT());
							klon.setNSGrenzTrockenRLF(getNSGrenzTrockenRLF());
							klon.setNSminNI(getNSminNI());
							klon.setNSGrenzRLF(getNSGrenzRLF());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.ufdsMeteorologischeKontrolleNiederschlagsArt";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdUfdsMeteorologischeKontrolleNiederschlagsArt(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
