/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenhersteller.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attribut fasst GlätteMeldungen verschiedener Hersteller zusammen.
<p>
&lt;absatz&gt;Die einem Status intern zugeordnete Nummer, wurde durch folgende 4-Byte-Kodierung bestimmt:&lt;&#47;absatz&gt;
          &lt;absatz&gt;1. Byte: Herstellercode (att.tlsHersteller: 17=MicKS, 21=Boschung, 44=Vaisala)&lt;&#47;absatz&gt;
          &lt;absatz&gt;2. zweites Byte: DE-Typ&lt;&#47;absatz&gt;
          &lt;absatz&gt;3.u.4. Byte: herstellerspezifischer Zustand&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttUfdsGlaettewarnungHersteller extends Zahl<		Long
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Glättewarnung des Herstellers konnte nicht ermittelt werden.
	<p>
	
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_1N_NICHT_ERMITTELBAR = new AttUfdsGlaettewarnungHersteller("nicht ermittelbar", 		Long
	.valueOf("-1"));

	/**
	Daten sind fehlerhaft.
	<p>
	Wird gesetzt, wenn die Daten als fehlerhaft erkannt wurden.
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_2N_FEHLERHAFT = new AttUfdsGlaettewarnungHersteller("fehlerhaft", 		Long
	.valueOf("-2"));

	/**
	Daten nicht ermittelbar, da bereits Basiswerte fehlerhaft.
	<p>
	Wird gesetzt, wenn Daten, die zur Berechnung dieses Werts notwendig sind, bereits als
	              fehlerhaft gekennzeichnet sind, oder wenn  die Berechnung aus anderen Gründen (z.B.
	              Nenner = 0 in der Berechnungsformel) nicht möglich war.
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_3N_NICHT_ERMITTELBAR_FEHLERHAFT = new AttUfdsGlaettewarnungHersteller("nicht ermittelbar/fehlerhaft", 		Long
	.valueOf("-3"));

	/**
	MicKS(129): Initialisierung nach Power On.
	<p>
	
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_293666816_MICKS_129_INITIALISIERUNG_NACH_POWER_ON = new AttUfdsGlaettewarnungHersteller("MicKS(129): Initialisierung nach Power On", 		Long
	.valueOf("293666816"));

	/**
	MicKS(129): Sonde defekt.
	<p>
	
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_293666818_MICKS_129_SONDE_DEFEKT = new AttUfdsGlaettewarnungHersteller("MicKS(129): Sonde defekt", 		Long
	.valueOf("293666818"));

	/**
	MicKS(129): Trocken.
	<p>
	
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_293666819_MICKS_129_TROCKEN = new AttUfdsGlaettewarnungHersteller("MicKS(129): Trocken", 		Long
	.valueOf("293666819"));

	/**
	MicKS(129): Feucht&#47;Nass.
	<p>
	
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_293666820_MICKS_129_FEUCHT_NASS = new AttUfdsGlaettewarnungHersteller("MicKS(129): Feucht/Nass", 		Long
	.valueOf("293666820"));

	/**
	MicKS(129): Glätte-Alarm.
	<p>
	
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_293666821_MICKS_129_GLAETTE_ALARM = new AttUfdsGlaettewarnungHersteller("MicKS(129): Glätte-Alarm", 		Long
	.valueOf("293666821"));

	/**
	MicKS(129): Fahrbahnzustand kritisch.
	<p>
	
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_293666822_MICKS_129_FAHRBAHNZUSTAND_KRITISCH = new AttUfdsGlaettewarnungHersteller("MicKS(129): Fahrbahnzustand kritisch", 		Long
	.valueOf("293666822"));

	/**
	MicKS(129): Salz zieht Feuchte.
	<p>
	
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_293666824_MICKS_129_SALZ_ZIEHT_FEUCHTE = new AttUfdsGlaettewarnungHersteller("MicKS(129): Salz zieht Feuchte", 		Long
	.valueOf("293666824"));

	/**
	MicKS(129): Tau.
	<p>
	
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_293666825_MICKS_129_TAU = new AttUfdsGlaettewarnungHersteller("MicKS(129): Tau", 		Long
	.valueOf("293666825"));

	/**
	MicKS(129): Frost.
	<p>
	
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_293666826_MICKS_129_FROST = new AttUfdsGlaettewarnungHersteller("MicKS(129): Frost", 		Long
	.valueOf("293666826"));

	/**
	MicKS(129): Tau und Salz.
	<p>
	
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_293666827_MICKS_129_TAU_UND_SALZ = new AttUfdsGlaettewarnungHersteller("MicKS(129): Tau und Salz", 		Long
	.valueOf("293666827"));

	/**
	MicKS(129): Reifglätte.
	<p>
	
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_293666828_MICKS_129_REIFGLAETTE = new AttUfdsGlaettewarnungHersteller("MicKS(129): Reifglätte", 		Long
	.valueOf("293666828"));

	/**
	MicKS(129): Leicht Feucht &#47; Abtrocknend.
	<p>
	
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_293666829_MICKS_129_LEICHT_FEUCHT_ABTROCKNEND = new AttUfdsGlaettewarnungHersteller("MicKS(129): Leicht Feucht / Abtrocknend", 		Long
	.valueOf("293666829"));

	/**
	MicKS(132): Keine Glättegefahr erkennbar (FB trocken).
	<p>
	Fahrbahn ist entweder Trocken (kleiner ca. 30 ml&#47;qm = 0,03 mm), schneeund eisfrei oder nur sehr gering feucht und&#47;oder die Temperaturen sind
	              über der Gefriertemperatur
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_293863424_MICKS_132_KEINE_GLAETTEGEFAHR_ERKENNBAR_FB_TROCKEN_ = new AttUfdsGlaettewarnungHersteller("MicKS(132): Keine Glättegefahr erkennbar (FB trocken)", 		Long
	.valueOf("293863424"));

	/**
	MicKS(132): Keine Glättegefahr erkennbar (FB feucht).
	<p>
	Fahrbahn ist feucht (größer ca. 30 ml&#47;qm = 0,03 mm und kleiner gleich ca 200ml&#47;qm = 0,2mm), 
	              schnee- und eisfrei und die Temperaturen sind über der Gefriertemperatur.
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_293863425_MICKS_132_KEINE_GLAETTEGEFAHR_ERKENNBAR_FB_FEUCHT_ = new AttUfdsGlaettewarnungHersteller("MicKS(132): Keine Glättegefahr erkennbar (FB feucht)", 		Long
	.valueOf("293863425"));

	/**
	MicKS(132): Glättegefahr durch Nässe.
	<p>
	Fahrbahn ist naß. Die Benetzung bzw. Bedeckung übersteigt ca. 200 ml&#47;qm = 0,2 mm.
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_293863427_MICKS_132_GLAETTEGEFAHR_DURCH_NAESSE = new AttUfdsGlaettewarnungHersteller("MicKS(132): Glättegefahr durch Nässe", 		Long
	.valueOf("293863427"));

	/**
	MicKS(132): Schneematschgefahr&#47; Schneeglättegefahr.
	<p>
	Schneematschgefahr&#47; Schneeglättegefahr
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_293863489_MICKS_132_SCHNEEMATSCHGEFAHR_SCHNEEGLAETTEGEFAHR = new AttUfdsGlaettewarnungHersteller("MicKS(132): Schneematschgefahr/ Schneeglättegefahr", 		Long
	.valueOf("293863489"));

	/**
	MicKS(132): Eisglätte- oder Glatteis-Gefahr.
	<p>
	Eisglätte- oder Glatteis-Gefahr
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_293863490_MICKS_132_EISGLAETTE_ODER_GLATTEIS_GEFAHR = new AttUfdsGlaettewarnungHersteller("MicKS(132): Eisglätte- oder Glatteis-Gefahr", 		Long
	.valueOf("293863490"));

	/**
	MicKS(132): Reifglättegefahr.
	<p>
	Gefahr der Bildung von Glätte durch Rauhreif. Die Taupunkttemperatur liegt nahe der Fahrbahnoberflächentemperatur 
	              und liegt unter der Gefriertemperatur.
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_293863491_MICKS_132_REIFGLAETTEGEFAHR = new AttUfdsGlaettewarnungHersteller("MicKS(132): Reifglättegefahr", 		Long
	.valueOf("293863491"));

	/**
	MicKS(132): Mögliche Glättegefahr durch unterkühlte Fahrbahn.
	<p>
	Gefahr der Bildung von Glätte durch Eis bei einsetzendem Niederschlag. Die Fahrbahn ist trocken oder leicht 
	              feucht (kleiner 0,18mm), jedoch liegt die Belagstemperatur unter der zuletzt ermittelten und zu erwartenden Gefriertemperatur.
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_293863492_MICKS_132_MOEGLICHE_GLAETTEGEFAHR_DURCH_UNTERKUEHLTE_FAHRBAHN = new AttUfdsGlaettewarnungHersteller("MicKS(132): Mögliche Glättegefahr durch unterkühlte Fahrbahn", 		Long
	.valueOf("293863492"));

	/**
	MicKS(132): Zustand und Gefahr nicht bestimmbar.
	<p>
	Sensorik kann auf Grund der herrschenden Bedingungen Zustand und Gefahr nicht bestimmen.
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_293863679_MICKS_132_ZUSTAND_UND_GEFAHR_NICHT_BESTIMMBAR = new AttUfdsGlaettewarnungHersteller("MicKS(132): Zustand und Gefahr nicht bestimmbar", 		Long
	.valueOf("293863679"));

	/**
	Boschung(254): kein Alarm.
	<p>
	Boschung - Typ 254 - Alarme
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_368967680_BOSCHUNG_254_KEIN_ALARM = new AttUfdsGlaettewarnungHersteller("Boschung(254): kein Alarm", 		Long
	.valueOf("368967680"));

	/**
	Boschung(254): A1(BOSO).
	<p>
	Herstellerdefinierte Meldung, Firma Boschung:
	              A1 = Alarm 1: Fahrbahnzustand ist feucht und Bodentemperatur oder Lufttemperatur sind kleiner als 0 Cº,
	              A2 = Alarm 2: Glättegefahr bei Absinken der Belagstemperatur oder Annäherung des Gefrierpunktes an die Bodentemperatur um 2 grd.
	              A3 = Alarm 3: Glätte durch Bodensensorik festgestellt
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_368967681_BOSCHUNG_254_A1_BOSO_ = new AttUfdsGlaettewarnungHersteller("Boschung(254): A1(BOSO)", 		Long
	.valueOf("368967681"));

	/**
	Boschung(254): A2(BOSO).
	<p>
	Herstellerdefinierte Meldung, Firma Boschung:
	              A1 = Alarm 1: Fahrbahnzustand ist feucht und Bodentemperatur oder Lufttemperatur sind kleiner als 0 Cº,
	              A2 = Alarm 2: Glättegefahr bei Absinken der Belagstemperatur oder Annäherung des Gefrierpunktes an die Bodentemperatur um 2 grd.
	              A3 = Alarm 3: Glätte durch Bodensensorik festgestellt
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_368967682_BOSCHUNG_254_A2_BOSO_ = new AttUfdsGlaettewarnungHersteller("Boschung(254): A2(BOSO)", 		Long
	.valueOf("368967682"));

	/**
	Boschung(254): A1+A2(BOSO).
	<p>
	Herstellerdefinierte Meldung, Firma Boschung:
	              A1 = Alarm 1: Fahrbahnzustand ist feucht und Bodentemperatur oder Lufttemperatur sind kleiner als 0 Cº,
	              A2 = Alarm 2: Glättegefahr bei Absinken der Belagstemperatur oder Annäherung des Gefrierpunktes an die Bodentemperatur um 2 grd.
	              A3 = Alarm 3: Glätte durch Bodensensorik festgestellt
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_368967683_BOSCHUNG_254_A1_A2_BOSO_ = new AttUfdsGlaettewarnungHersteller("Boschung(254): A1+A2(BOSO)", 		Long
	.valueOf("368967683"));

	/**
	Boschung(254): A3(BOSO).
	<p>
	Herstellerdefinierte Meldung, Firma Boschung:
	              A1 = Alarm 1: Fahrbahnzustand ist feucht und Bodentemperatur oder Lufttemperatur sind kleiner als 0 Cº,
	              A2 = Alarm 2: Glättegefahr bei Absinken der Belagstemperatur oder Annäherung des Gefrierpunktes an die Bodentemperatur um 2 grd.
	              A3 = Alarm 3: Glätte durch Bodensensorik festgestellt
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_368967684_BOSCHUNG_254_A3_BOSO_ = new AttUfdsGlaettewarnungHersteller("Boschung(254): A3(BOSO)", 		Long
	.valueOf("368967684"));

	/**
	Boschung(254): A1+A3(BOSO).
	<p>
	Herstellerdefinierte Meldung, Firma Boschung:
	              A1 = Alarm 1: Fahrbahnzustand ist feucht und Bodentemperatur oder Lufttemperatur sind kleiner als 0 Cº,
	              A2 = Alarm 2: Glättegefahr bei Absinken der Belagstemperatur oder Annäherung des Gefrierpunktes an die Bodentemperatur um 2 grd.
	              A3 = Alarm 3: Glätte durch Bodensensorik festgestellt
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_368967685_BOSCHUNG_254_A1_A3_BOSO_ = new AttUfdsGlaettewarnungHersteller("Boschung(254): A1+A3(BOSO)", 		Long
	.valueOf("368967685"));

	/**
	Boschung(254): A2+A3(BOSO).
	<p>
	Herstellerdefinierte Meldung, Firma Boschung:
	              A1 = Alarm 1: Fahrbahnzustand ist feucht und Bodentemperatur oder Lufttemperatur sind kleiner als 0 Cº,
	              A2 = Alarm 2: Glättegefahr bei Absinken der Belagstemperatur oder Annäherung des Gefrierpunktes an die Bodentemperatur um 2 grd.
	              A3 = Alarm 3: Glätte durch Bodensensorik festgestellt
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_368967686_BOSCHUNG_254_A2_A3_BOSO_ = new AttUfdsGlaettewarnungHersteller("Boschung(254): A2+A3(BOSO)", 		Long
	.valueOf("368967686"));

	/**
	Boschung(254): A1+A2+A3(BOSO).
	<p>
	Herstellerdefinierte Meldung, Firma Boschung:
	              A1 = Alarm 1: Fahrbahnzustand ist feucht und Bodentemperatur oder Lufttemperatur sind kleiner als 0 Cº,
	              A2 = Alarm 2: Glättegefahr bei Absinken der Belagstemperatur oder Annäherung des Gefrierpunktes an die Bodentemperatur um 2 grd.
	              A3 = Alarm 3: Glätte durch Bodensensorik festgestellt
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_368967687_BOSCHUNG_254_A1_A2_A3_BOSO_ = new AttUfdsGlaettewarnungHersteller("Boschung(254): A1+A2+A3(BOSO)", 		Long
	.valueOf("368967687"));

	/**
	Boschung(254): A2(GT-Sonde).
	<p>
	Herstellerdefinierte Meldung, Firma Boschung:
	              A1 = Alarm 1: Fahrbahnzustand ist feucht und Bodentemperatur oder Lufttemperatur sind kleiner als 0 Cº,
	              A2 = Alarm 2: Glättegefahr bei Absinken der Belagstemperatur oder Annäherung des Gefrierpunktes an die Bodentemperatur um 2 grd.
	              A3 = Alarm 3: Glätte durch Bodensensorik festgestellt
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_368967688_BOSCHUNG_254_A2_GT_SONDE_ = new AttUfdsGlaettewarnungHersteller("Boschung(254): A2(GT-Sonde)", 		Long
	.valueOf("368967688"));

	/**
	Boschung(254): A1(BOSO), A2(GT-Sonde).
	<p>
	Herstellerdefinierte Meldung, Firma Boschung:
	            A1 = Alarm 1: Fahrbahnzustand ist feucht und Bodentemperatur oder Lufttemperatur sind kleiner als 0 Cº,
	            A2 = Alarm 2: Glättegefahr bei Absinken der Belagstemperatur oder Annäherung des Gefrierpunktes an die Bodentemperatur um 2 grd.
	            A3 = Alarm 3: Glätte durch Bodensensorik festgestellt
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_368967689_BOSCHUNG_254_A1_BOSO_A2_GT_SONDE_ = new AttUfdsGlaettewarnungHersteller("Boschung(254): A1(BOSO), A2(GT-Sonde)", 		Long
	.valueOf("368967689"));

	/**
	Boschung(254): A2(BOSO), A2(GT-Sonde).
	<p>
	Herstellerdefinierte Meldung, Firma Boschung:
	            A1 = Alarm 1: Fahrbahnzustand ist feucht und Bodentemperatur oder Lufttemperatur sind kleiner als 0 Cº,
	            A2 = Alarm 2: Glättegefahr bei Absinken der Belagstemperatur oder Annäherung des Gefrierpunktes an die Bodentemperatur um 2 grd.
	            A3 = Alarm 3: Glätte durch Bodensensorik festgestellt
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_368967690_BOSCHUNG_254_A2_BOSO_A2_GT_SONDE_ = new AttUfdsGlaettewarnungHersteller("Boschung(254): A2(BOSO), A2(GT-Sonde)", 		Long
	.valueOf("368967690"));

	/**
	Boschung(254): A1+A2(BOSO), A2(GT-Sonde).
	<p>
	Herstellerdefinierte Meldung, Firma Boschung:
	            A1 = Alarm 1: Fahrbahnzustand ist feucht und Bodentemperatur oder Lufttemperatur sind kleiner als 0 Cº,
	            A2 = Alarm 2: Glättegefahr bei Absinken der Belagstemperatur oder Annäherung des Gefrierpunktes an die Bodentemperatur um 2 grd.
	            A3 = Alarm 3: Glätte durch Bodensensorik festgestellt
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_368967691_BOSCHUNG_254_A1_A2_BOSO_A2_GT_SONDE_ = new AttUfdsGlaettewarnungHersteller("Boschung(254): A1+A2(BOSO), A2(GT-Sonde)", 		Long
	.valueOf("368967691"));

	/**
	Boschung(254): A3(BOSO), A2(GT-Sonde).
	<p>
	Herstellerdefinierte Meldung, Firma Boschung:
	            A1 = Alarm 1: Fahrbahnzustand ist feucht und Bodentemperatur oder Lufttemperatur sind kleiner als 0 Cº,
	            A2 = Alarm 2: Glättegefahr bei Absinken der Belagstemperatur oder Annäherung des Gefrierpunktes an die Bodentemperatur um 2 grd.
	            A3 = Alarm 3: Glätte durch Bodensensorik festgestellt
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_368967692_BOSCHUNG_254_A3_BOSO_A2_GT_SONDE_ = new AttUfdsGlaettewarnungHersteller("Boschung(254): A3(BOSO), A2(GT-Sonde)", 		Long
	.valueOf("368967692"));

	/**
	Boschung(254): A1+A3(BOSO), A2(GT-Sonde).
	<p>
	Herstellerdefinierte Meldung, Firma Boschung:
	            A1 = Alarm 1: Fahrbahnzustand ist feucht und Bodentemperatur oder Lufttemperatur sind kleiner als 0 Cº,
	            A2 = Alarm 2: Glättegefahr bei Absinken der Belagstemperatur oder Annäherung des Gefrierpunktes an die Bodentemperatur um 2 grd.
	            A3 = Alarm 3: Glätte durch Bodensensorik festgestellt
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_368967693_BOSCHUNG_254_A1_A3_BOSO_A2_GT_SONDE_ = new AttUfdsGlaettewarnungHersteller("Boschung(254): A1+A3(BOSO), A2(GT-Sonde)", 		Long
	.valueOf("368967693"));

	/**
	Boschung(254): A2+A3(BOSO), A2(GT-Sonde).
	<p>
	Herstellerdefinierte Meldung, Firma Boschung:
	            A1 = Alarm 1: Fahrbahnzustand ist feucht und Bodentemperatur oder Lufttemperatur sind kleiner als 0 Cº,
	            A2 = Alarm 2: Glättegefahr bei Absinken der Belagstemperatur oder Annäherung des Gefrierpunktes an die Bodentemperatur um 2 grd.
	            A3 = Alarm 3: Glätte durch Bodensensorik festgestellt
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_368967694_BOSCHUNG_254_A2_A3_BOSO_A2_GT_SONDE_ = new AttUfdsGlaettewarnungHersteller("Boschung(254): A2+A3(BOSO), A2(GT-Sonde)", 		Long
	.valueOf("368967694"));

	/**
	Boschung(254): A1+A2+A3(BOSO), A2(GT-Sonde).
	<p>
	Herstellerdefinierte Meldung, Firma Boschung:
	            A1 = Alarm 1: Fahrbahnzustand ist feucht und Bodentemperatur oder Lufttemperatur sind kleiner als 0 Cº,
	            A2 = Alarm 2: Glättegefahr bei Absinken der Belagstemperatur oder Annäherung des Gefrierpunktes an die Bodentemperatur um 2 grd.
	            A3 = Alarm 3: Glätte durch Bodensensorik festgestellt
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_368967695_BOSCHUNG_254_A1_A2_A3_BOSO_A2_GT_SONDE_ = new AttUfdsGlaettewarnungHersteller("Boschung(254): A1+A2+A3(BOSO), A2(GT-Sonde)", 		Long
	.valueOf("368967695"));

	/**
	Boschung(254): A3(GT-Sonde).
	<p>
	Herstellerdefinierte Meldung, Firma Boschung:
	            A1 = Alarm 1: Fahrbahnzustand ist feucht und Bodentemperatur oder Lufttemperatur sind kleiner als 0 Cº,
	            A2 = Alarm 2: Glättegefahr bei Absinken der Belagstemperatur oder Annäherung des Gefrierpunktes an die Bodentemperatur um 2 grd.
	            A3 = Alarm 3: Glätte durch Bodensensorik festgestellt
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_368967696_BOSCHUNG_254_A3_GT_SONDE_ = new AttUfdsGlaettewarnungHersteller("Boschung(254): A3(GT-Sonde)", 		Long
	.valueOf("368967696"));

	/**
	Boschung(254): A1(BOSO), A3(GT-Sonde).
	<p>
	Herstellerdefinierte Meldung, Firma Boschung:
	            A1 = Alarm 1: Fahrbahnzustand ist feucht und Bodentemperatur oder Lufttemperatur sind kleiner als 0 Cº,
	            A2 = Alarm 2: Glättegefahr bei Absinken der Belagstemperatur oder Annäherung des Gefrierpunktes an die Bodentemperatur um 2 grd.
	            A3 = Alarm 3: Glätte durch Bodensensorik festgestellt
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_368967697_BOSCHUNG_254_A1_BOSO_A3_GT_SONDE_ = new AttUfdsGlaettewarnungHersteller("Boschung(254): A1(BOSO), A3(GT-Sonde)", 		Long
	.valueOf("368967697"));

	/**
	Boschung(254): A2(BOSO), A3(GT-Sonde).
	<p>
	Herstellerdefinierte Meldung, Firma Boschung:
	            A1 = Alarm 1: Fahrbahnzustand ist feucht und Bodentemperatur oder Lufttemperatur sind kleiner als 0 Cº,
	            A2 = Alarm 2: Glättegefahr bei Absinken der Belagstemperatur oder Annäherung des Gefrierpunktes an die Bodentemperatur um 2 grd.
	            A3 = Alarm 3: Glätte durch Bodensensorik festgestellt
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_368967698_BOSCHUNG_254_A2_BOSO_A3_GT_SONDE_ = new AttUfdsGlaettewarnungHersteller("Boschung(254): A2(BOSO), A3(GT-Sonde)", 		Long
	.valueOf("368967698"));

	/**
	Boschung(254): A1+A2(BOSO), A3(GT-Sonde).
	<p>
	Herstellerdefinierte Meldung, Firma Boschung:
	            A1 = Alarm 1: Fahrbahnzustand ist feucht und Bodentemperatur oder Lufttemperatur sind kleiner als 0 Cº,
	            A2 = Alarm 2: Glättegefahr bei Absinken der Belagstemperatur oder Annäherung des Gefrierpunktes an die Bodentemperatur um 2 grd.
	            A3 = Alarm 3: Glätte durch Bodensensorik festgestellt
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_368967699_BOSCHUNG_254_A1_A2_BOSO_A3_GT_SONDE_ = new AttUfdsGlaettewarnungHersteller("Boschung(254): A1+A2(BOSO), A3(GT-Sonde)", 		Long
	.valueOf("368967699"));

	/**
	Boschung(254): A3(BOSO), A3(GT-Sonde).
	<p>
	Herstellerdefinierte Meldung, Firma Boschung:
	            A1 = Alarm 1: Fahrbahnzustand ist feucht und Bodentemperatur oder Lufttemperatur sind kleiner als 0 Cº,
	            A2 = Alarm 2: Glättegefahr bei Absinken der Belagstemperatur oder Annäherung des Gefrierpunktes an die Bodentemperatur um 2 grd.
	            A3 = Alarm 3: Glätte durch Bodensensorik festgestellt
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_368967700_BOSCHUNG_254_A3_BOSO_A3_GT_SONDE_ = new AttUfdsGlaettewarnungHersteller("Boschung(254): A3(BOSO), A3(GT-Sonde)", 		Long
	.valueOf("368967700"));

	/**
	Boschung(254): A1+A3(BOSO), A3(GT-Sonde).
	<p>
	Herstellerdefinierte Meldung, Firma Boschung:
	            A1 = Alarm 1: Fahrbahnzustand ist feucht und Bodentemperatur oder Lufttemperatur sind kleiner als 0 Cº,
	            A2 = Alarm 2: Glättegefahr bei Absinken der Belagstemperatur oder Annäherung des Gefrierpunktes an die Bodentemperatur um 2 grd.
	            A3 = Alarm 3: Glätte durch Bodensensorik festgestellt
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_368967701_BOSCHUNG_254_A1_A3_BOSO_A3_GT_SONDE_ = new AttUfdsGlaettewarnungHersteller("Boschung(254): A1+A3(BOSO), A3(GT-Sonde)", 		Long
	.valueOf("368967701"));

	/**
	Boschung(254): A2+A3(BOSO), A3(GT-Sonde).
	<p>
	Herstellerdefinierte Meldung, Firma Boschung:
	            A1 = Alarm 1: Fahrbahnzustand ist feucht und Bodentemperatur oder Lufttemperatur sind kleiner als 0 Cº,
	            A2 = Alarm 2: Glättegefahr bei Absinken der Belagstemperatur oder Annäherung des Gefrierpunktes an die Bodentemperatur um 2 grd.
	            A3 = Alarm 3: Glätte durch Bodensensorik festgestellt
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_368967702_BOSCHUNG_254_A2_A3_BOSO_A3_GT_SONDE_ = new AttUfdsGlaettewarnungHersteller("Boschung(254): A2+A3(BOSO), A3(GT-Sonde)", 		Long
	.valueOf("368967702"));

	/**
	Boschung(254): A1+A2+A3(BOSO), A3(GT-Sonde).
	<p>
	Herstellerdefinierte Meldung, Firma Boschung:
	            A1 = Alarm 1: Fahrbahnzustand ist feucht und Bodentemperatur oder Lufttemperatur sind kleiner als 0 Cº,
	            A2 = Alarm 2: Glättegefahr bei Absinken der Belagstemperatur oder Annäherung des Gefrierpunktes an die Bodentemperatur um 2 grd.
	            A3 = Alarm 3: Glätte durch Bodensensorik festgestellt
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_368967703_BOSCHUNG_254_A1_A2_A3_BOSO_A3_GT_SONDE_ = new AttUfdsGlaettewarnungHersteller("Boschung(254): A1+A2+A3(BOSO), A3(GT-Sonde)", 		Long
	.valueOf("368967703"));

	/**
	Boschung(254): A2+A3(GT-Sonde).
	<p>
	Herstellerdefinierte Meldung, Firma Boschung:
	            A1 = Alarm 1: Fahrbahnzustand ist feucht und Bodentemperatur oder Lufttemperatur sind kleiner als 0 Cº,
	            A2 = Alarm 2: Glättegefahr bei Absinken der Belagstemperatur oder Annäherung des Gefrierpunktes an die Bodentemperatur um 2 grd.
	            A3 = Alarm 3: Glätte durch Bodensensorik festgestellt
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_368967704_BOSCHUNG_254_A2_A3_GT_SONDE_ = new AttUfdsGlaettewarnungHersteller("Boschung(254): A2+A3(GT-Sonde)", 		Long
	.valueOf("368967704"));

	/**
	Boschung(254): A1(BOSO), A2+A3(GT-Sonde).
	<p>
	Herstellerdefinierte Meldung, Firma Boschung:
	            A1 = Alarm 1: Fahrbahnzustand ist feucht und Bodentemperatur oder Lufttemperatur sind kleiner als 0 Cº,
	            A2 = Alarm 2: Glättegefahr bei Absinken der Belagstemperatur oder Annäherung des Gefrierpunktes an die Bodentemperatur um 2 grd.
	            A3 = Alarm 3: Glätte durch Bodensensorik festgestellt
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_368967705_BOSCHUNG_254_A1_BOSO_A2_A3_GT_SONDE_ = new AttUfdsGlaettewarnungHersteller("Boschung(254): A1(BOSO), A2+A3(GT-Sonde)", 		Long
	.valueOf("368967705"));

	/**
	Boschung(254): A2(BOSO), A2+A3(GT-Sonde).
	<p>
	Herstellerdefinierte Meldung, Firma Boschung:
	            A1 = Alarm 1: Fahrbahnzustand ist feucht und Bodentemperatur oder Lufttemperatur sind kleiner als 0 Cº,
	            A2 = Alarm 2: Glättegefahr bei Absinken der Belagstemperatur oder Annäherung des Gefrierpunktes an die Bodentemperatur um 2 grd.
	            A3 = Alarm 3: Glätte durch Bodensensorik festgestellt
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_368967706_BOSCHUNG_254_A2_BOSO_A2_A3_GT_SONDE_ = new AttUfdsGlaettewarnungHersteller("Boschung(254): A2(BOSO), A2+A3(GT-Sonde)", 		Long
	.valueOf("368967706"));

	/**
	Boschung(254): A1+A2(BOSO), A2+A3(GT-Sonde).
	<p>
	Herstellerdefinierte Meldung, Firma Boschung:
	            A1 = Alarm 1: Fahrbahnzustand ist feucht und Bodentemperatur oder Lufttemperatur sind kleiner als 0 Cº,
	            A2 = Alarm 2: Glättegefahr bei Absinken der Belagstemperatur oder Annäherung des Gefrierpunktes an die Bodentemperatur um 2 grd.
	            A3 = Alarm 3: Glätte durch Bodensensorik festgestellt
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_368967707_BOSCHUNG_254_A1_A2_BOSO_A2_A3_GT_SONDE_ = new AttUfdsGlaettewarnungHersteller("Boschung(254): A1+A2(BOSO), A2+A3(GT-Sonde)", 		Long
	.valueOf("368967707"));

	/**
	Boschung(254): A3(BOSO), A2+A3(GT-Sonde).
	<p>
	Herstellerdefinierte Meldung, Firma Boschung:
	            A1 = Alarm 1: Fahrbahnzustand ist feucht und Bodentemperatur oder Lufttemperatur sind kleiner als 0 Cº,
	            A2 = Alarm 2: Glättegefahr bei Absinken der Belagstemperatur oder Annäherung des Gefrierpunktes an die Bodentemperatur um 2 grd.
	            A3 = Alarm 3: Glätte durch Bodensensorik festgestellt
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_368967708_BOSCHUNG_254_A3_BOSO_A2_A3_GT_SONDE_ = new AttUfdsGlaettewarnungHersteller("Boschung(254): A3(BOSO), A2+A3(GT-Sonde)", 		Long
	.valueOf("368967708"));

	/**
	Boschung(254): A1+A3(BOSO), A2+A3(GT-Sonde).
	<p>
	Herstellerdefinierte Meldung, Firma Boschung:
	            A1 = Alarm 1: Fahrbahnzustand ist feucht und Bodentemperatur oder Lufttemperatur sind kleiner als 0 Cº,
	            A2 = Alarm 2: Glättegefahr bei Absinken der Belagstemperatur oder Annäherung des Gefrierpunktes an die Bodentemperatur um 2 grd.
	            A3 = Alarm 3: Glätte durch Bodensensorik festgestellt
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_368967709_BOSCHUNG_254_A1_A3_BOSO_A2_A3_GT_SONDE_ = new AttUfdsGlaettewarnungHersteller("Boschung(254): A1+A3(BOSO), A2+A3(GT-Sonde)", 		Long
	.valueOf("368967709"));

	/**
	Boschung(254): A2+A3(BOSO), A2+A3(GT-Sonde).
	<p>
	Herstellerdefinierte Meldung, Firma Boschung:
	            A1 = Alarm 1: Fahrbahnzustand ist feucht und Bodentemperatur oder Lufttemperatur sind kleiner als 0 Cº,
	            A2 = Alarm 2: Glättegefahr bei Absinken der Belagstemperatur oder Annäherung des Gefrierpunktes an die Bodentemperatur um 2 grd.
	            A3 = Alarm 3: Glätte durch Bodensensorik festgestellt
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_368967710_BOSCHUNG_254_A2_A3_BOSO_A2_A3_GT_SONDE_ = new AttUfdsGlaettewarnungHersteller("Boschung(254): A2+A3(BOSO), A2+A3(GT-Sonde)", 		Long
	.valueOf("368967710"));

	/**
	Boschung(254): A1+A2+A3(BOSO), A2+A3(GT-Sonde).
	<p>
	Herstellerdefinierte Meldung, Firma Boschung:
	            A1 = Alarm 1: Fahrbahnzustand ist feucht und Bodentemperatur oder Lufttemperatur sind kleiner als 0 Cº,
	            A2 = Alarm 2: Glättegefahr bei Absinken der Belagstemperatur oder Annäherung des Gefrierpunktes an die Bodentemperatur um 2 grd.
	            A3 = Alarm 3: Glätte durch Bodensensorik festgestellt
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_368967711_BOSCHUNG_254_A1_A2_A3_BOSO_A2_A3_GT_SONDE_ = new AttUfdsGlaettewarnungHersteller("Boschung(254): A1+A2+A3(BOSO), A2+A3(GT-Sonde)", 		Long
	.valueOf("368967711"));

	/**
	Vaisala(189): trocken.
	<p>
	
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_750583808_VAISALA_189_TROCKEN = new AttUfdsGlaettewarnungHersteller("Vaisala(189): trocken", 		Long
	.valueOf("750583808"));

	/**
	Vaisala(189): Schnee, Glättegefahr.
	<p>
	
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_750583873_VAISALA_189_SCHNEE_GLAETTEGEFAHR = new AttUfdsGlaettewarnungHersteller("Vaisala(189): Schnee, Glättegefahr", 		Long
	.valueOf("750583873"));

	/**
	Vaisala(189): Eis, Glättegefahr.
	<p>
	
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_750583874_VAISALA_189_EIS_GLAETTEGEFAHR = new AttUfdsGlaettewarnungHersteller("Vaisala(189): Eis, Glättegefahr", 		Long
	.valueOf("750583874"));

	/**
	Vaisala(189): Reif, Glättegefahr.
	<p>
	
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_750583875_VAISALA_189_REIF_GLAETTEGEFAHR = new AttUfdsGlaettewarnungHersteller("Vaisala(189): Reif, Glättegefahr", 		Long
	.valueOf("750583875"));

	/**
	Vaisala(189): feucht.
	<p>
	Fahrbahn-Temperatur liegt über der Gefriertemperatur
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_750583936_VAISALA_189_FEUCHT = new AttUfdsGlaettewarnungHersteller("Vaisala(189): feucht", 		Long
	.valueOf("750583936"));

	/**
	Vaisala(189): feucht (Restsalz vorhanden).
	<p>
	Fahrbahn-Temperatur liegt über der Gefriertemperatur
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_750583937_VAISALA_189_FEUCHT_RESTSALZ_VORHANDEN_ = new AttUfdsGlaettewarnungHersteller("Vaisala(189): feucht (Restsalz vorhanden)", 		Long
	.valueOf("750583937"));

	/**
	Vaisala(189): nass.
	<p>
	Fahrbahn-Temperatur liegt über der Gefriertemperatur
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_750583938_VAISALA_189_NASS = new AttUfdsGlaettewarnungHersteller("Vaisala(189): nass", 		Long
	.valueOf("750583938"));

	/**
	Vaisala(189): nass (Restsalz vorhanden).
	<p>
	Fahrbahn-Temperatur liegt über der Gefriertemperatur
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_750583939_VAISALA_189_NASS_RESTSALZ_VORHANDEN_ = new AttUfdsGlaettewarnungHersteller("Vaisala(189): nass (Restsalz vorhanden)", 		Long
	.valueOf("750583939"));

	/**
	Vaisala(189): Zustand nicht bestimmbar.
	<p>
	
	</p>
	*/
	public static final AttUfdsGlaettewarnungHersteller ZUSTAND_750584063_VAISALA_189_ZUSTAND_NICHT_BESTIMMBAR = new AttUfdsGlaettewarnungHersteller("Vaisala(189): Zustand nicht bestimmbar", 		Long
	.valueOf("750584063"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttUfdsGlaettewarnungHersteller getZustand(final 		Long
	 value) {
		for (AttUfdsGlaettewarnungHersteller e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttUfdsGlaettewarnungHersteller getZustand(final String value) {
		for (AttUfdsGlaettewarnungHersteller e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttUfdsGlaettewarnungHersteller> getZustaende() {
		List<AttUfdsGlaettewarnungHersteller> list = new ArrayList<AttUfdsGlaettewarnungHersteller>();
		list.add(ZUSTAND_1N_NICHT_ERMITTELBAR);
		list.add(ZUSTAND_2N_FEHLERHAFT);
		list.add(ZUSTAND_3N_NICHT_ERMITTELBAR_FEHLERHAFT);
		list.add(ZUSTAND_293666816_MICKS_129_INITIALISIERUNG_NACH_POWER_ON);
		list.add(ZUSTAND_293666818_MICKS_129_SONDE_DEFEKT);
		list.add(ZUSTAND_293666819_MICKS_129_TROCKEN);
		list.add(ZUSTAND_293666820_MICKS_129_FEUCHT_NASS);
		list.add(ZUSTAND_293666821_MICKS_129_GLAETTE_ALARM);
		list.add(ZUSTAND_293666822_MICKS_129_FAHRBAHNZUSTAND_KRITISCH);
		list.add(ZUSTAND_293666824_MICKS_129_SALZ_ZIEHT_FEUCHTE);
		list.add(ZUSTAND_293666825_MICKS_129_TAU);
		list.add(ZUSTAND_293666826_MICKS_129_FROST);
		list.add(ZUSTAND_293666827_MICKS_129_TAU_UND_SALZ);
		list.add(ZUSTAND_293666828_MICKS_129_REIFGLAETTE);
		list.add(ZUSTAND_293666829_MICKS_129_LEICHT_FEUCHT_ABTROCKNEND);
		list.add(ZUSTAND_293863424_MICKS_132_KEINE_GLAETTEGEFAHR_ERKENNBAR_FB_TROCKEN_);
		list.add(ZUSTAND_293863425_MICKS_132_KEINE_GLAETTEGEFAHR_ERKENNBAR_FB_FEUCHT_);
		list.add(ZUSTAND_293863427_MICKS_132_GLAETTEGEFAHR_DURCH_NAESSE);
		list.add(ZUSTAND_293863489_MICKS_132_SCHNEEMATSCHGEFAHR_SCHNEEGLAETTEGEFAHR);
		list.add(ZUSTAND_293863490_MICKS_132_EISGLAETTE_ODER_GLATTEIS_GEFAHR);
		list.add(ZUSTAND_293863491_MICKS_132_REIFGLAETTEGEFAHR);
		list.add(ZUSTAND_293863492_MICKS_132_MOEGLICHE_GLAETTEGEFAHR_DURCH_UNTERKUEHLTE_FAHRBAHN);
		list.add(ZUSTAND_293863679_MICKS_132_ZUSTAND_UND_GEFAHR_NICHT_BESTIMMBAR);
		list.add(ZUSTAND_368967680_BOSCHUNG_254_KEIN_ALARM);
		list.add(ZUSTAND_368967681_BOSCHUNG_254_A1_BOSO_);
		list.add(ZUSTAND_368967682_BOSCHUNG_254_A2_BOSO_);
		list.add(ZUSTAND_368967683_BOSCHUNG_254_A1_A2_BOSO_);
		list.add(ZUSTAND_368967684_BOSCHUNG_254_A3_BOSO_);
		list.add(ZUSTAND_368967685_BOSCHUNG_254_A1_A3_BOSO_);
		list.add(ZUSTAND_368967686_BOSCHUNG_254_A2_A3_BOSO_);
		list.add(ZUSTAND_368967687_BOSCHUNG_254_A1_A2_A3_BOSO_);
		list.add(ZUSTAND_368967688_BOSCHUNG_254_A2_GT_SONDE_);
		list.add(ZUSTAND_368967689_BOSCHUNG_254_A1_BOSO_A2_GT_SONDE_);
		list.add(ZUSTAND_368967690_BOSCHUNG_254_A2_BOSO_A2_GT_SONDE_);
		list.add(ZUSTAND_368967691_BOSCHUNG_254_A1_A2_BOSO_A2_GT_SONDE_);
		list.add(ZUSTAND_368967692_BOSCHUNG_254_A3_BOSO_A2_GT_SONDE_);
		list.add(ZUSTAND_368967693_BOSCHUNG_254_A1_A3_BOSO_A2_GT_SONDE_);
		list.add(ZUSTAND_368967694_BOSCHUNG_254_A2_A3_BOSO_A2_GT_SONDE_);
		list.add(ZUSTAND_368967695_BOSCHUNG_254_A1_A2_A3_BOSO_A2_GT_SONDE_);
		list.add(ZUSTAND_368967696_BOSCHUNG_254_A3_GT_SONDE_);
		list.add(ZUSTAND_368967697_BOSCHUNG_254_A1_BOSO_A3_GT_SONDE_);
		list.add(ZUSTAND_368967698_BOSCHUNG_254_A2_BOSO_A3_GT_SONDE_);
		list.add(ZUSTAND_368967699_BOSCHUNG_254_A1_A2_BOSO_A3_GT_SONDE_);
		list.add(ZUSTAND_368967700_BOSCHUNG_254_A3_BOSO_A3_GT_SONDE_);
		list.add(ZUSTAND_368967701_BOSCHUNG_254_A1_A3_BOSO_A3_GT_SONDE_);
		list.add(ZUSTAND_368967702_BOSCHUNG_254_A2_A3_BOSO_A3_GT_SONDE_);
		list.add(ZUSTAND_368967703_BOSCHUNG_254_A1_A2_A3_BOSO_A3_GT_SONDE_);
		list.add(ZUSTAND_368967704_BOSCHUNG_254_A2_A3_GT_SONDE_);
		list.add(ZUSTAND_368967705_BOSCHUNG_254_A1_BOSO_A2_A3_GT_SONDE_);
		list.add(ZUSTAND_368967706_BOSCHUNG_254_A2_BOSO_A2_A3_GT_SONDE_);
		list.add(ZUSTAND_368967707_BOSCHUNG_254_A1_A2_BOSO_A2_A3_GT_SONDE_);
		list.add(ZUSTAND_368967708_BOSCHUNG_254_A3_BOSO_A2_A3_GT_SONDE_);
		list.add(ZUSTAND_368967709_BOSCHUNG_254_A1_A3_BOSO_A2_A3_GT_SONDE_);
		list.add(ZUSTAND_368967710_BOSCHUNG_254_A2_A3_BOSO_A2_A3_GT_SONDE_);
		list.add(ZUSTAND_368967711_BOSCHUNG_254_A1_A2_A3_BOSO_A2_A3_GT_SONDE_);
		list.add(ZUSTAND_750583808_VAISALA_189_TROCKEN);
		list.add(ZUSTAND_750583873_VAISALA_189_SCHNEE_GLAETTEGEFAHR);
		list.add(ZUSTAND_750583874_VAISALA_189_EIS_GLAETTEGEFAHR);
		list.add(ZUSTAND_750583875_VAISALA_189_REIF_GLAETTEGEFAHR);
		list.add(ZUSTAND_750583936_VAISALA_189_FEUCHT);
		list.add(ZUSTAND_750583937_VAISALA_189_FEUCHT_RESTSALZ_VORHANDEN_);
		list.add(ZUSTAND_750583938_VAISALA_189_NASS);
		list.add(ZUSTAND_750583939_VAISALA_189_NASS_RESTSALZ_VORHANDEN_);
		list.add(ZUSTAND_750584063_VAISALA_189_ZUSTAND_NICHT_BESTIMMBAR);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut UfdsGlättewarnungHersteller.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttUfdsGlaettewarnungHersteller(final 		Long
	 value) {
		super(value);
	}
	
	private AttUfdsGlaettewarnungHersteller(final String zustand, final 		Long
	 value) {
		super(zustand, value);
	}
	
}
