/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameterwerte für die Analysewertberechnung des
					Aquivalenzfaktors für Lkw.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlAequivalenzFaktorLkw implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
			 _k1
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
			 _k2
			;
	
		/**
		Parameter für die Analysewertberechnung des
								Aquivalenzfaktors für Lkw.
		<p>
		
		</p>
		
		@return der Wert von K1.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
			 getK1() {
			return _k1;
		}
	
		/**
		Parameter für die Analysewertberechnung des
								Aquivalenzfaktors für Lkw.
		<p>
		
		</p>
		
		@param _k1 der neue Wert von K1.
		*/
		public void setK1(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
		 _k1) {
			this._k1 = _k1;
		}
	
		/**
		Parametersatz für die Analysewertberechnung des
								Aquivalenzfaktors für Lkw.
		<p>
		
		</p>
		
		@return der Wert von K2.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
			 getK2() {
			return _k2;
		}
	
		/**
		Parametersatz für die Analysewertberechnung des
								Aquivalenzfaktors für Lkw.
		<p>
		
		</p>
		
		@param _k2 der neue Wert von K2.
		*/
		public void setK2(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
		 _k2) {
			this._k2 = _k2;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getK1() != null) {
	                if (getK1().isZustand()) {
	                    datum.getUnscaledValue("k1").setText(getK1().toString());
	                } else {
						datum.
						getScaledValue
	                	("k1").set(getK1().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getK2() != null) {
	                if (getK2().isZustand()) {
	                    datum.getUnscaledValue("k2").setText(getK2().toString());
	                } else {
						datum.
						getScaledValue
	                	("k2").set(getK2().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						setK1(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
						(daten.
							getScaledValue
						("k1").
							doubleValue
						()));
				// GanzzahlAttributTyp
						setK2(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellen
						(daten.
							getScaledValue
						("k2").
							doubleValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlAequivalenzFaktorLkw clone() {
		AtlAequivalenzFaktorLkw klon = new AtlAequivalenzFaktorLkw();
		
						klon.setK1(getK1());
						klon.setK2(getK2());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
