/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Angabe der Betriebskilometer auf einem Linienobjekt.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlBetriebsKilometer implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttOffsetMeter
			 _offset
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttOffsetMeter
			 _wert
			;
			private String
			 _blockNummer
			= new String
			()
			;
	
		/**
		Abstand des Betriebskilometer-Punktes vom Anfang
								des Linienobjekts.
		<p>
		
		</p>
		
		@return der Wert von Offset.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttOffsetMeter
			 getOffset() {
			return _offset;
		}
	
		/**
		Abstand des Betriebskilometer-Punktes vom Anfang
								des Linienobjekts.
		<p>
		
		</p>
		
		@param _offset der neue Wert von Offset.
		*/
		public void setOffset(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttOffsetMeter
		 _offset) {
			this._offset = _offset;
		}
	
		/**
		Der Wert des Betriebskilometers.
		<p>
		
		</p>
		
		@return der Wert von Wert.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttOffsetMeter
			 getWert() {
			return _wert;
		}
	
		/**
		Der Wert des Betriebskilometers.
		<p>
		
		</p>
		
		@param _wert der neue Wert von Wert.
		*/
		public void setWert(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttOffsetMeter
		 _wert) {
			this._wert = _wert;
		}
	
		/**
		Blocknummer für diesen Betriebskilometer. Für
								eine Straße ist die Kombinaiton aus
								Betriebskilometer und Blocknummer eindeutig.
		<p>
		
		</p>
		
		@return der Wert von BlockNummer.
		*/
			public String
			 getBlockNummer() {
			return _blockNummer;
		}
	
		/**
		Blocknummer für diesen Betriebskilometer. Für
								eine Straße ist die Kombinaiton aus
								Betriebskilometer und Blocknummer eindeutig.
		<p>
		
		</p>
		
		@param _blockNummer der neue Wert von BlockNummer.
		*/
		public void setBlockNummer(String
		 _blockNummer) {
			if (_blockNummer.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._blockNummer = _blockNummer;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getOffset() != null) {
	                if (getOffset().isZustand()) {
	                    datum.getUnscaledValue("Offset").setText(getOffset().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Offset").set(getOffset().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getWert() != null) {
	                if (getWert().isZustand()) {
	                    datum.getUnscaledValue("Wert").setText(getWert().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Wert").set(getWert().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getBlockNummer() != null) {
					datum.getTextValue("BlockNummer").setText(getBlockNummer());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Offset").isState()) {
							setOffset(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttOffsetMeter
							.getZustand(daten.getScaledValue("Offset").getText()));
						} else {
						setOffset(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttOffsetMeter
						(daten.
							getUnscaledValue
						("Offset").
								longValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Wert").isState()) {
							setWert(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttOffsetMeter
							.getZustand(daten.getScaledValue("Wert").getText()));
						} else {
						setWert(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttOffsetMeter
						(daten.
							getUnscaledValue
						("Wert").
								longValue
						()));
						}
				// ZeichenkettenAttributTyp
					setBlockNummer(daten.getTextValue("BlockNummer").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlBetriebsKilometer clone() {
		AtlBetriebsKilometer klon = new AtlBetriebsKilometer();
		
						klon.setOffset(getOffset());
						klon.setWert(getWert());
						klon.setBlockNummer(getBlockNummer());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
