/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Eine Fuzzy-Variable.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 13
 */
public class AtlFuzzyVariable implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _variable
			= new String
			()
			;
			@Defaultwert(wert = "0")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttZyklus
			 _zyklus
			;
			private Feld<String
			> _term = new Feld<String
			>(0, true);
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Variable.
		*/
			public String
			 getVariable() {
			return _variable;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _variable der neue Wert von Variable.
		*/
		public void setVariable(String
		 _variable) {
			if (_variable.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._variable = _variable;
		}
	
		/**
		Angabe eines Zyklus relativ zum aktuellen Zyklus
							(0=aktueller Zyklus, 1=letzter Zyklus, ..., 127).
		<p>
		
		</p>
		
		@return der Wert von Zyklus.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttZyklus
			 getZyklus() {
			return _zyklus;
		}
	
		/**
		Angabe eines Zyklus relativ zum aktuellen Zyklus
							(0=aktueller Zyklus, 1=letzter Zyklus, ..., 127).
		<p>
		
		</p>
		
		@param _zyklus der neue Wert von Zyklus.
		*/
		public void setZyklus(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttZyklus
		 _zyklus) {
			this._zyklus = _zyklus;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Term.
		*/
			public Feld<String
			> getTerm() {
			return _term;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getVariable() != null) {
					datum.getTextValue("Variable").setText(getVariable());
				}
				// GanzzahlAttributTyp
				if (getZyklus() != null) {
	                if (getZyklus().isZustand()) {
	                    datum.getUnscaledValue("Zyklus").setText(getZyklus().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Zyklus").set(getZyklus().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getTerm() != null) {
					final Data.TextArray arrayTerm = datum.getTextArray("Term");
					arrayTerm.setLength(getTerm().size());
					for (int i = 0; i < arrayTerm.getLength(); ++i) {
						arrayTerm.getTextValue(i).setText(getTerm().get(i));
					}
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setVariable(daten.getTextValue("Variable").getText());
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Zyklus").isState()) {
							setZyklus(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttZyklus
							.getZustand(daten.getScaledValue("Zyklus").getText()));
						} else {
						setZyklus(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttZyklus
						(daten.
							getUnscaledValue
						("Zyklus").
								byteValue
						()));
						}
				// ZeichenkettenAttributTyp
					final Data.TextArray arrayTerm = daten.getTextArray("Term");
					for (int i = 0; i < arrayTerm.getLength(); ++i) {
						getTerm().add(arrayTerm.getText(i));
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlFuzzyVariable clone() {
		AtlFuzzyVariable klon = new AtlFuzzyVariable();
		
						klon.setVariable(getVariable());
						klon.setZyklus(getZyklus());
					klon._term = getTerm().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
