/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Liste der Messquerschnitte mit Angabe der
					Berechnungsvorschrift, wie aus diesen
					Messquerschnittswerten die Werte des virtuellen
					Messquerschnitts ermittelt werden sollen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class AtlMessQuerSchnittBestandTeile implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
			 _messQuerschnittReferenz
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttMessQuerschnittAnteil
			 _anteil
			;
	
		/**
		Referenz auf den Messquerschnitt, der Werte für
								die Berechnung des virtuellen MQ liefern soll.
		<p>
		
		</p>
		
		@return der Wert von MessQuerschnittReferenz.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
			 getMessQuerschnittReferenz() {
			return _messQuerschnittReferenz;
		}
	
		/**
		Referenz auf den Messquerschnitt, der Werte für
								die Berechnung des virtuellen MQ liefern soll.
		<p>
		
		</p>
		
		@param _messQuerschnittReferenz der neue Wert von MessQuerschnittReferenz.
		*/
		public void setMessQuerschnittReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
		 _messQuerschnittReferenz) {
			this._messQuerschnittReferenz = _messQuerschnittReferenz;
		}
	
		/**
		Faktor, mit dem die Werte bei der Berechnung
								berücksichtigt werden sollen.
		<p>
		
		</p>
		
		@return der Wert von Anteil.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttMessQuerschnittAnteil
			 getAnteil() {
			return _anteil;
		}
	
		/**
		Faktor, mit dem die Werte bei der Berechnung
								berücksichtigt werden sollen.
		<p>
		
		</p>
		
		@param _anteil der neue Wert von Anteil.
		*/
		public void setAnteil(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttMessQuerschnittAnteil
		 _anteil) {
			this._anteil = _anteil;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soMessQuerschnittReferenz = getMessQuerschnittReferenz();
					final SystemObject tmpMessQuerschnittReferenz;
						if (soMessQuerschnittReferenz instanceof SystemObject) {
							tmpMessQuerschnittReferenz = (SystemObject)soMessQuerschnittReferenz;
						} else if(soMessQuerschnittReferenz instanceof SystemObjekt){
							tmpMessQuerschnittReferenz = ((SystemObjekt)soMessQuerschnittReferenz).getSystemObject();
						} else{
							tmpMessQuerschnittReferenz = null;
						}
					datum.getReferenceValue("MessQuerschnittReferenz").setSystemObject(tmpMessQuerschnittReferenz);
				// GanzzahlAttributTyp
				if (getAnteil() != null) {
	                if (getAnteil().isZustand()) {
	                    datum.getUnscaledValue("Anteil").setText(getAnteil().toString());
	                } else {
						datum.
						getScaledValue
	                	("Anteil").set(getAnteil().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idMessQuerschnittReferenz = daten.getReferenceValue("MessQuerschnittReferenz").getId();
					final SystemObjekt tmpMessQuerschnittReferenz;
					if (idMessQuerschnittReferenz == 0) {
						tmpMessQuerschnittReferenz = null;
					} else {
						final SystemObject soMessQuerschnittReferenz = factory.getDav().getDataModel().getObject(idMessQuerschnittReferenz);
						if (soMessQuerschnittReferenz == null) {
								tmpMessQuerschnittReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.MessQuerschnittUngueltig(idMessQuerschnittReferenz);
						} else {
							tmpMessQuerschnittReferenz = factory.getModellobjekt(soMessQuerschnittReferenz);
						}
					}
					setMessQuerschnittReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
					) tmpMessQuerschnittReferenz);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Anteil").isState()) {
							setAnteil(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttMessQuerschnittAnteil
							.getZustand(daten.getScaledValue("Anteil").getText()));
						} else {
						setAnteil(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttMessQuerschnittAnteil
						(daten.
							getScaledValue
						("Anteil").
							doubleValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlMessQuerSchnittBestandTeile clone() {
		AtlMessQuerSchnittBestandTeile klon = new AtlMessQuerSchnittBestandTeile();
		
						klon.setMessQuerschnittReferenz(getMessQuerschnittReferenz());
						klon.setAnteil(getAnteil());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
