/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ergebnisse der Stauprognose.
<p>
&lt;absatz&gt;
						Ergebnisse der Stauprognose pro
						StraßenTeilSegment.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 19
 */
public class AtlNbaDatenStauPrognose implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Zeitstempel
			 _zeit
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
			 _deltaN
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _deltaL
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
			 _nprog
			;
	
		/**
		Zeitstempel des Prognoseintervall.
		<p>
		
		</p>
		
		@return der Wert von Zeit.
		*/
			public 	Zeitstempel
			 getZeit() {
			return _zeit;
		}
	
		/**
		Zeitstempel des Prognoseintervall.
		<p>
		
		</p>
		
		@param _zeit der neue Wert von Zeit.
		*/
		public void setZeit(	Zeitstempel
		 _zeit) {
			this._zeit = _zeit;
		}
	
		/**
		angestaute Fahrzeugmenge für das
								prognoseintervall.
		<p>
		
		</p>
		
		@return der Wert von DeltaN.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
			 getDeltaN() {
			return _deltaN;
		}
	
		/**
		angestaute Fahrzeugmenge für das
								prognoseintervall.
		<p>
		
		</p>
		
		@param _deltaN der neue Wert von DeltaN.
		*/
		public void setDeltaN(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
		 _deltaN) {
			this._deltaN = _deltaN;
		}
	
		/**
		Veränderung der Staulänge für das
								prognoseintervall.
		<p>
		
		</p>
		
		@return der Wert von DeltaL.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getDeltaL() {
			return _deltaL;
		}
	
		/**
		Veränderung der Staulänge für das
								prognoseintervall.
		<p>
		
		</p>
		
		@param _deltaL der neue Wert von DeltaL.
		*/
		public void setDeltaL(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _deltaL) {
			this._deltaL = _deltaL;
		}
	
		/**
		Anzahl der Fahrzeugmenge im Stau für das
								prognoseintervall.
		<p>
		
		</p>
		
		@return der Wert von Nprog.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
			 getNprog() {
			return _nprog;
		}
	
		/**
		Anzahl der Fahrzeugmenge im Stau für das
								prognoseintervall.
		<p>
		
		</p>
		
		@param _nprog der neue Wert von Nprog.
		*/
		public void setNprog(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
		 _nprog) {
			this._nprog = _nprog;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					datum.getTimeValue("Zeit").setMillis(getZeit().getTime());
				// GanzzahlAttributTyp
				if (getDeltaN() != null) {
	                if (getDeltaN().isZustand()) {
	                    datum.getUnscaledValue("deltaN").setText(getDeltaN().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("deltaN").set(getDeltaN().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getDeltaL() != null) {
	                if (getDeltaL().isZustand()) {
	                    datum.getUnscaledValue("deltaL").setText(getDeltaL().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("deltaL").set(getDeltaL().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getNprog() != null) {
	                if (getNprog().isZustand()) {
	                    datum.getUnscaledValue("Nprog").setText(getNprog().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Nprog").set(getNprog().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					setZeit(new
						Zeitstempel
						(daten.getTimeValue("Zeit").getMillis()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("deltaN").isState()) {
							setDeltaN(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
							.getZustand(daten.getScaledValue("deltaN").getText()));
						} else {
						setDeltaN(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
						(daten.
							getUnscaledValue
						("deltaN").
								intValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("deltaL").isState()) {
							setDeltaL(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("deltaL").getText()));
						} else {
						setDeltaL(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("deltaL").
								longValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Nprog").isState()) {
							setNprog(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
							.getZustand(daten.getScaledValue("Nprog").getText()));
						} else {
						setNprog(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
						(daten.
							getUnscaledValue
						("Nprog").
								intValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaDatenStauPrognose clone() {
		AtlNbaDatenStauPrognose klon = new AtlNbaDatenStauPrognose();
		
						klon.setZeit(getZeit());
						klon.setDeltaN(getDeltaN());
						klon.setDeltaL(getDeltaL());
						klon.setNprog(getNprog());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
