/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ergebnisse der Verkehrszustandsermittlung.
<p>
&lt;absatz&gt;
						Ergebnisse der Verkehrszustandsermittlung pro
						StraßenTeilSegment.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 33
 */
public class AtlNbaDatenVerkehrszustand implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttNbaStauindikator
			 _stauindikator
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 _psn
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 _pnsn
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
			 _gs
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
			 _gns
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
			 _d
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
			 _dp
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _vp
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _offsetSi
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _offsetSiStart
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _offsetSiEnde
			;
			private 	Object
			 _referenz
			;
	
		/**
		Aussage, ob an dieser Stelle Stau oder
								Nicht-Stau ist.
		<p>
		
		</p>
		
		@return der Wert von Stauindikator.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttNbaStauindikator
			 getStauindikator() {
			return _stauindikator;
		}
	
		/**
		Aussage, ob an dieser Stelle Stau oder
								Nicht-Stau ist.
		<p>
		
		</p>
		
		@param _stauindikator der neue Wert von Stauindikator.
		*/
		public void setStauindikator(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttNbaStauindikator
		 _stauindikator) {
			this._stauindikator = _stauindikator;
		}
	
		/**
		Produkt der Stauindikatoren für den Zustand Stau
								normiert.
		<p>
		
		</p>
		
		@return der Wert von Psn.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 getPsn() {
			return _psn;
		}
	
		/**
		Produkt der Stauindikatoren für den Zustand Stau
								normiert.
		<p>
		
		</p>
		
		@param _psn der neue Wert von Psn.
		*/
		public void setPsn(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
		 _psn) {
			this._psn = _psn;
		}
	
		/**
		Produkt der Stauindikatoren für den Zustand
								Nicht-Stau normiert.
		<p>
		
		</p>
		
		@return der Wert von Pnsn.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 getPnsn() {
			return _pnsn;
		}
	
		/**
		Produkt der Stauindikatoren für den Zustand
								Nicht-Stau normiert.
		<p>
		
		</p>
		
		@param _pnsn der neue Wert von Pnsn.
		*/
		public void setPnsn(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
		 _pnsn) {
			this._pnsn = _pnsn;
		}
	
		/**
		Güte des betrachteten Wertes im Zustand Stau.
		<p>
		
		</p>
		
		@return der Wert von Gs.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
			 getGs() {
			return _gs;
		}
	
		/**
		Güte des betrachteten Wertes im Zustand Stau.
		<p>
		
		</p>
		
		@param _gs der neue Wert von Gs.
		*/
		public void setGs(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
		 _gs) {
			this._gs = _gs;
		}
	
		/**
		Güte des betrachteten Wertes im Zustand
								Nicht-Stau.
		<p>
		
		</p>
		
		@return der Wert von Gns.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
			 getGns() {
			return _gns;
		}
	
		/**
		Güte des betrachteten Wertes im Zustand
								Nicht-Stau.
		<p>
		
		</p>
		
		@param _gns der neue Wert von Gns.
		*/
		public void setGns(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
		 _gns) {
			this._gns = _gns;
		}
	
		/**
		Abschnittsbezogene Verkehrsdichte in
								Abhängigkeit von der Stabilität des
								Verkehrsablaufs.
		<p>
		
		</p>
		
		@return der Wert von D.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
			 getD() {
			return _d;
		}
	
		/**
		Abschnittsbezogene Verkehrsdichte in
								Abhängigkeit von der Stabilität des
								Verkehrsablaufs.
		<p>
		
		</p>
		
		@param _d der neue Wert von D.
		*/
		public void setD(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
		 _d) {
			this._d = _d;
		}
	
		/**
		Abschnittsbezogene Verkehrsdichte in
								Abhängigkeit von der Stabilität des
								Verkehrsablaufs Trendprognose.
		<p>
		
		</p>
		
		@return der Wert von Dp.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
			 getDp() {
			return _dp;
		}
	
		/**
		Abschnittsbezogene Verkehrsdichte in
								Abhängigkeit von der Stabilität des
								Verkehrsablaufs Trendprognose.
		<p>
		
		</p>
		
		@param _dp der neue Wert von Dp.
		*/
		public void setDp(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
		 _dp) {
			this._dp = _dp;
		}
	
		/**
		Abschnittsbezogene Geschwindigkeit.
		<p>
		
		</p>
		
		@return der Wert von Vp.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 getVp() {
			return _vp;
		}
	
		/**
		Abschnittsbezogene Geschwindigkeit.
		<p>
		
		</p>
		
		@param _vp der neue Wert von Vp.
		*/
		public void setVp(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
		 _vp) {
			this._vp = _vp;
		}
	
		/**
		Offset des Messquerschnitt (Stauindikator) bezogen auf das StraßenTeilSegment.
								Ort an dem der Stauindikator lokalisiert wird.
		<p>
		
		</p>
		
		@return der Wert von OffsetSi.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getOffsetSi() {
			return _offsetSi;
		}
	
		/**
		Offset des Messquerschnitt (Stauindikator) bezogen auf das StraßenTeilSegment.
								Ort an dem der Stauindikator lokalisiert wird.
		<p>
		
		</p>
		
		@param _offsetSi der neue Wert von OffsetSi.
		*/
		public void setOffsetSi(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _offsetSi) {
			this._offsetSi = _offsetSi;
		}
	
		/**
		Offset für den Beginn des Stauindikator mit Ausdehnung bezogen auf das StraßenTeilSegment.
		<p>
		
		</p>
		
		@return der Wert von OffsetSiStart.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getOffsetSiStart() {
			return _offsetSiStart;
		}
	
		/**
		Offset für den Beginn des Stauindikator mit Ausdehnung bezogen auf das StraßenTeilSegment.
		<p>
		
		</p>
		
		@param _offsetSiStart der neue Wert von OffsetSiStart.
		*/
		public void setOffsetSiStart(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _offsetSiStart) {
			this._offsetSiStart = _offsetSiStart;
		}
	
		/**
		Offset für das Ende des Stauindikator mit Ausdehnung bezogen auf das StraßenTeilSegment.
		<p>
		
		</p>
		
		@return der Wert von OffsetSiEnde.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getOffsetSiEnde() {
			return _offsetSiEnde;
		}
	
		/**
		Offset für das Ende des Stauindikator mit Ausdehnung bezogen auf das StraßenTeilSegment.
		<p>
		
		</p>
		
		@param _offsetSiEnde der neue Wert von OffsetSiEnde.
		*/
		public void setOffsetSiEnde(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _offsetSiEnde) {
			this._offsetSiEnde = _offsetSiEnde;
		}
	
		/**
		Optionale Referenz auf das Objekt, das den Stauindikator realisiert. (Messquerschnitt,
								TMC-Meldung usw.).
		<p>
		
		</p>
		
		@return der Wert von Referenz.
		*/
			public 	Object
			 getReferenz() {
			return _referenz;
		}
	
		/**
		Optionale Referenz auf das Objekt, das den Stauindikator realisiert. (Messquerschnitt,
								TMC-Meldung usw.).
		<p>
		
		</p>
		
		@param _referenz der neue Wert von Referenz.
		*/
		public void setReferenz(	Object
		 _referenz) {
			this._referenz = _referenz;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getStauindikator() != null) {
	                if (getStauindikator().isZustand()) {
	                    datum.getUnscaledValue("Stauindikator").setText(getStauindikator().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Stauindikator").set(getStauindikator().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getPsn() != null) {
	                if (getPsn().isZustand()) {
	                    datum.getUnscaledValue("Psn").setText(getPsn().toString());
	                } else {
						datum.
						getScaledValue
	                	("Psn").set(getPsn().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getPnsn() != null) {
	                if (getPnsn().isZustand()) {
	                    datum.getUnscaledValue("Pnsn").setText(getPnsn().toString());
	                } else {
						datum.
						getScaledValue
	                	("Pnsn").set(getPnsn().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getGs() != null) {
	                if (getGs().isZustand()) {
	                    datum.getUnscaledValue("Gs").setText(getGs().toString());
	                } else {
						datum.
						getScaledValue
	                	("Gs").set(getGs().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getGns() != null) {
	                if (getGns().isZustand()) {
	                    datum.getUnscaledValue("Gns").setText(getGns().toString());
	                } else {
						datum.
						getScaledValue
	                	("Gns").set(getGns().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getD() != null) {
	                if (getD().isZustand()) {
	                    datum.getUnscaledValue("D").setText(getD().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("D").set(getD().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getDp() != null) {
	                if (getDp().isZustand()) {
	                    datum.getUnscaledValue("Dp").setText(getDp().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Dp").set(getDp().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getVp() != null) {
	                if (getVp().isZustand()) {
	                    datum.getUnscaledValue("Vp").setText(getVp().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Vp").set(getVp().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getOffsetSi() != null) {
	                if (getOffsetSi().isZustand()) {
	                    datum.getUnscaledValue("OffsetSi").setText(getOffsetSi().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("OffsetSi").set(getOffsetSi().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getOffsetSiStart() != null) {
	                if (getOffsetSiStart().isZustand()) {
	                    datum.getUnscaledValue("OffsetSiStart").setText(getOffsetSiStart().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("OffsetSiStart").set(getOffsetSiStart().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getOffsetSiEnde() != null) {
	                if (getOffsetSiEnde().isZustand()) {
	                    datum.getUnscaledValue("OffsetSiEnde").setText(getOffsetSiEnde().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("OffsetSiEnde").set(getOffsetSiEnde().getValue());
	                }
				}
				// ObjektReferenzAttributTyp
					final Object soReferenz = getReferenz();
					final SystemObject tmpReferenz;
						if (soReferenz instanceof SystemObject) {
							tmpReferenz = (SystemObject)soReferenz;
						} else if(soReferenz instanceof SystemObjekt){
							tmpReferenz = ((SystemObjekt)soReferenz).getSystemObject();
						} else{
							tmpReferenz = null;
						}
					datum.getReferenceValue("Referenz").setSystemObject(tmpReferenz);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Stauindikator").isState()) {
							setStauindikator(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttNbaStauindikator
							.getZustand(daten.getScaledValue("Stauindikator").getText()));
						} else {
						setStauindikator(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttNbaStauindikator
						(daten.
							getUnscaledValue
						("Stauindikator").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						setPsn(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
						(daten.
							getScaledValue
						("Psn").
							doubleValue
						()));
				// GanzzahlAttributTyp
						setPnsn(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
						(daten.
							getScaledValue
						("Pnsn").
							doubleValue
						()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Gs").isState()) {
							setGs(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
							.getZustand(daten.getScaledValue("Gs").getText()));
						} else {
						setGs(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
						(daten.
							getScaledValue
						("Gs").
							doubleValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Gns").isState()) {
							setGns(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
							.getZustand(daten.getScaledValue("Gns").getText()));
						} else {
						setGns(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
						(daten.
							getScaledValue
						("Gns").
							doubleValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("D").isState()) {
							setD(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
							.getZustand(daten.getScaledValue("D").getText()));
						} else {
						setD(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
						(daten.
							getUnscaledValue
						("D").
								shortValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Dp").isState()) {
							setDp(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
							.getZustand(daten.getScaledValue("Dp").getText()));
						} else {
						setDp(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
						(daten.
							getUnscaledValue
						("Dp").
								shortValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Vp").isState()) {
							setVp(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							.getZustand(daten.getScaledValue("Vp").getText()));
						} else {
						setVp(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
						(daten.
							getUnscaledValue
						("Vp").
								shortValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("OffsetSi").isState()) {
							setOffsetSi(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("OffsetSi").getText()));
						} else {
						setOffsetSi(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("OffsetSi").
								longValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("OffsetSiStart").isState()) {
							setOffsetSiStart(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("OffsetSiStart").getText()));
						} else {
						setOffsetSiStart(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("OffsetSiStart").
								longValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("OffsetSiEnde").isState()) {
							setOffsetSiEnde(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("OffsetSiEnde").getText()));
						} else {
						setOffsetSiEnde(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("OffsetSiEnde").
								longValue
						()));
						}
				// ObjektReferenzAttributTyp
					final long idReferenz = daten.getReferenceValue("Referenz").getId();
					final SystemObjekt tmpReferenz;
					if (idReferenz == 0) {
						tmpReferenz = null;
					} else {
						final SystemObject soReferenz = factory.getDav().getDataModel().getObject(idReferenz);
						if (soReferenz == null) {
								tmpReferenz = new BaseUngueltigesSystemObjekt(idReferenz);
						} else {
							tmpReferenz = factory.getModellobjekt(soReferenz);
						}
					}
					setReferenz((	Object
					) tmpReferenz);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaDatenVerkehrszustand clone() {
		AtlNbaDatenVerkehrszustand klon = new AtlNbaDatenVerkehrszustand();
		
						klon.setStauindikator(getStauindikator());
						klon.setPsn(getPsn());
						klon.setPnsn(getPnsn());
						klon.setGs(getGs());
						klon.setGns(getGns());
						klon.setD(getD());
						klon.setDp(getDp());
						klon.setVp(getVp());
						klon.setOffsetSi(getOffsetSi());
						klon.setOffsetSiStart(getOffsetSiStart());
						klon.setOffsetSiEnde(getOffsetSiEnde());
						klon.setReferenz(getReferenz());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
