/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ergebnisse der Kapazitätsermittlung.
<p>
&lt;absatz&gt;
						Ergebnisse der Kapazitätsermittlung pro
						StraßenTeilSegment.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 25
 */
public class AtlNbaKapazitaetsermittlung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Zeitstempel
			 _zeit
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlNbaKapazitaetsermittlungAbschnitt
			> _abschnitte = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlNbaKapazitaetsermittlungAbschnitt
			>(0, true);
	
		/**
		Zeitstempel des Prognosewertes.
		<p>
		
		</p>
		
		@return der Wert von Zeit.
		*/
			public 	Zeitstempel
			 getZeit() {
			return _zeit;
		}
	
		/**
		Zeitstempel des Prognosewertes.
		<p>
		
		</p>
		
		@param _zeit der neue Wert von Zeit.
		*/
		public void setZeit(	Zeitstempel
		 _zeit) {
			this._zeit = _zeit;
		}
	
		/**
		Leistungsfähigkeit der Abschnitte.
		<p>
		
		</p>
		
		@return der Wert von Abschnitte.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlNbaKapazitaetsermittlungAbschnitt
			> getAbschnitte() {
			return _abschnitte;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					datum.getTimeValue("Zeit").setMillis(getZeit().getTime());
				// AttributListenDefinition
					final Data.Array arrayAbschnitte = datum.getArray("Abschnitte");
					arrayAbschnitte.setLength(getAbschnitte().size());
					for (int i = 0; i < arrayAbschnitte.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlNbaKapazitaetsermittlungAbschnitt
						 atl = getAbschnitte().get(i);
						atl.bean2Atl(arrayAbschnitte.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					setZeit(new
						Zeitstempel
						(daten.getTimeValue("Zeit").getMillis()));
				// AttributListenDefinition
					final Data.Array arrayAbschnitte = daten.getArray("Abschnitte");
					for (int i = 0; i < arrayAbschnitte.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlNbaKapazitaetsermittlungAbschnitt
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlNbaKapazitaetsermittlungAbschnitt
						 ();
						atl.atl2Bean(arrayAbschnitte.getItem(i), factory);
						getAbschnitte().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaKapazitaetsermittlung clone() {
		AtlNbaKapazitaetsermittlung klon = new AtlNbaKapazitaetsermittlung();
		
						klon.setZeit(getZeit());
					klon._abschnitte = getAbschnitte().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
