/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definition einer Stützstelle für die Ganglinie.
<p>
&lt;absatz&gt;
						Die Definition umfasst eine Zuordnung von
						Attributen zu einer Stützstelle der
						nbaGanglinie.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 19
 */
public class AtlNbaStuetzstelleGanglinie implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Zeitstempel
			 _zeit
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttNbaGanglinienWert
			 _qB
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _anzahlVerschmelzungen
			;
	
		/**
		Zeitpunkt der Stützstelle.
		<p>
		
		</p>
		
		@return der Wert von Zeit.
		*/
			public 	Zeitstempel
			 getZeit() {
			return _zeit;
		}
	
		/**
		Zeitpunkt der Stützstelle.
		<p>
		
		</p>
		
		@param _zeit der neue Wert von Zeit.
		*/
		public void setZeit(	Zeitstempel
		 _zeit) {
			this._zeit = _zeit;
		}
	
		/**
		Verkehrsmenge des Fundamentaldiagramms.
		<p>
		
		</p>
		
		@return der Wert von QB.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttNbaGanglinienWert
			 getQB() {
			return _qB;
		}
	
		/**
		Verkehrsmenge des Fundamentaldiagramms.
		<p>
		
		</p>
		
		@param _qB der neue Wert von QB.
		*/
		public void setQB(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttNbaGanglinienWert
		 _qB) {
			this._qB = _qB;
		}
	
		/**
		Anzahl der Verschmelzungen aus der die Ganglinie
								hervorgeht.
		<p>
		
		</p>
		
		@return der Wert von AnzahlVerschmelzungen.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 getAnzahlVerschmelzungen() {
			return _anzahlVerschmelzungen;
		}
	
		/**
		Anzahl der Verschmelzungen aus der die Ganglinie
								hervorgeht.
		<p>
		
		</p>
		
		@param _anzahlVerschmelzungen der neue Wert von AnzahlVerschmelzungen.
		*/
		public void setAnzahlVerschmelzungen(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
		 _anzahlVerschmelzungen) {
			this._anzahlVerschmelzungen = _anzahlVerschmelzungen;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					datum.getTimeValue("Zeit").setMillis(getZeit().getTime());
				// GanzzahlAttributTyp
				if (getQB() != null) {
	                if (getQB().isZustand()) {
	                    datum.getUnscaledValue("QB").setText(getQB().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("QB").set(getQB().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getAnzahlVerschmelzungen() != null) {
	                if (getAnzahlVerschmelzungen().isZustand()) {
	                    datum.getUnscaledValue("AnzahlVerschmelzungen").setText(getAnzahlVerschmelzungen().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("AnzahlVerschmelzungen").set(getAnzahlVerschmelzungen().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					setZeit(new
						Zeitstempel
						(daten.getTimeValue("Zeit").getMillis()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("QB").isState()) {
							setQB(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttNbaGanglinienWert
							.getZustand(daten.getScaledValue("QB").getText()));
						} else {
						setQB(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttNbaGanglinienWert
						(daten.
							getUnscaledValue
						("QB").
								longValue
						()));
						}
				// GanzzahlAttributTyp
						setAnzahlVerschmelzungen(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
						(daten.
							getUnscaledValue
						("AnzahlVerschmelzungen").
								longValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNbaStuetzstelleGanglinie clone() {
		AtlNbaStuetzstelleGanglinie klon = new AtlNbaStuetzstelleGanglinie();
		
						klon.setZeit(getZeit());
						klon.setQB(getQB());
						klon.setAnzahlVerschmelzungen(getAnzahlVerschmelzungen());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
