/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Wird von externen Erfassungen gesetzt (z.B. TLS)
					gesetzt.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlStatusExterneErfassung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _nichtErfasst
			;
	
		/**
		Wird auf ja gesetzt, wenn der entsprechende Wert
								nicht erfasst wurde, aber durch Berechnung oder
								Interpolation bestimmt werden konnte.
		<p>
		
		</p>
		
		@return der Wert von NichtErfasst.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getNichtErfasst() {
			return _nichtErfasst;
		}
	
		/**
		Wird auf ja gesetzt, wenn der entsprechende Wert
								nicht erfasst wurde, aber durch Berechnung oder
								Interpolation bestimmt werden konnte.
		<p>
		
		</p>
		
		@param _nichtErfasst der neue Wert von NichtErfasst.
		*/
		public void setNichtErfasst(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _nichtErfasst) {
			this._nichtErfasst = _nichtErfasst;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getNichtErfasst() != null) {
	                if (getNichtErfasst().isZustand()) {
	                    datum.getUnscaledValue("NichtErfasst").setText(getNichtErfasst().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("NichtErfasst").set(getNichtErfasst().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("NichtErfasst").isState()) {
							setNichtErfasst(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("NichtErfasst").getText()));
						} else {
						setNichtErfasst(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("NichtErfasst").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlStatusExterneErfassung clone() {
		AtlStatusExterneErfassung klon = new AtlStatusExterneErfassung();
		
						klon.setNichtErfasst(getNichtErfasst());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
