/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Statusinformationen werden von den
					Plausibilitätsprüfungen für die Messwertersetzung
					und von der Messwertersetzung nach Interpolation
					gesetzt.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlStatusMessWertErsetzung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _implausibel
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _interpoliert
			;
	
		/**
		Wird von den Plausibilitätsprüfung auf ja
								gesetzt, wenn Wert als implausibel festgestellt
								wird. Da dieser Wert von unterschiedlichen
								Verfahren gesetzt werden kann und bei der
								Messwertersetzung ausgewertet wird, ist der der
								Gruppe MessWertErsetzung zugeordnet.
		<p>
		
		</p>
		
		@return der Wert von Implausibel.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getImplausibel() {
			return _implausibel;
		}
	
		/**
		Wird von den Plausibilitätsprüfung auf ja
								gesetzt, wenn Wert als implausibel festgestellt
								wird. Da dieser Wert von unterschiedlichen
								Verfahren gesetzt werden kann und bei der
								Messwertersetzung ausgewertet wird, ist der der
								Gruppe MessWertErsetzung zugeordnet.
		<p>
		
		</p>
		
		@param _implausibel der neue Wert von Implausibel.
		*/
		public void setImplausibel(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _implausibel) {
			this._implausibel = _implausibel;
		}
	
		/**
		Wird auf ja gesetzt, Wird gesetzt, wenn die
								entsprechenden Eingangswerte als implausibel
								gekennzeichnet waren und von der
								Messwertersetzung ersetzt wurden.
		<p>
		
		</p>
		
		@return der Wert von Interpoliert.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getInterpoliert() {
			return _interpoliert;
		}
	
		/**
		Wird auf ja gesetzt, Wird gesetzt, wenn die
								entsprechenden Eingangswerte als implausibel
								gekennzeichnet waren und von der
								Messwertersetzung ersetzt wurden.
		<p>
		
		</p>
		
		@param _interpoliert der neue Wert von Interpoliert.
		*/
		public void setInterpoliert(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _interpoliert) {
			this._interpoliert = _interpoliert;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getImplausibel() != null) {
	                if (getImplausibel().isZustand()) {
	                    datum.getUnscaledValue("Implausibel").setText(getImplausibel().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Implausibel").set(getImplausibel().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getInterpoliert() != null) {
	                if (getInterpoliert().isZustand()) {
	                    datum.getUnscaledValue("Interpoliert").setText(getInterpoliert().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Interpoliert").set(getInterpoliert().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Implausibel").isState()) {
							setImplausibel(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("Implausibel").getText()));
						} else {
						setImplausibel(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("Implausibel").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Interpoliert").isState()) {
							setInterpoliert(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("Interpoliert").getText()));
						} else {
						setInterpoliert(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("Interpoliert").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlStatusMessWertErsetzung clone() {
		AtlStatusMessWertErsetzung klon = new AtlStatusMessWertErsetzung();
		
						klon.setImplausibel(getImplausibel());
						klon.setInterpoliert(getInterpoliert());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
