/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Daten eines Prognoseschritts bei der
					Stauverlaufsprognose eines Stauobjekts.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 18
 */
public class AtlStauVerlaufPrognoseSchritt implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
			 _zufluss
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
			 _kapazitaet
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _laenge
			;
			private 	RelativerZeitstempel
			 _verlustZeit
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _vKfz
			;
	
		/**
		Zum Stau zufließender Verkehr im
								Prognoseschritt.
		<p>
		
		</p>
		
		@return der Wert von Zufluss.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
			 getZufluss() {
			return _zufluss;
		}
	
		/**
		Zum Stau zufließender Verkehr im
								Prognoseschritt.
		<p>
		
		</p>
		
		@param _zufluss der neue Wert von Zufluss.
		*/
		public void setZufluss(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
		 _zufluss) {
			this._zufluss = _zufluss;
		}
	
		/**
		Engpasskapazität des Stauobjekts.
		<p>
		
		</p>
		
		@return der Wert von Kapazitaet.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
			 getKapazitaet() {
			return _kapazitaet;
		}
	
		/**
		Engpasskapazität des Stauobjekts.
		<p>
		
		</p>
		
		@param _kapazitaet der neue Wert von Kapazitaet.
		*/
		public void setKapazitaet(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
		 _kapazitaet) {
			this._kapazitaet = _kapazitaet;
		}
	
		/**
		Prognose der räumlichen Ausdehnung des
								Stauobjekts im Prognoseschritt.
		<p>
		
		</p>
		
		@return der Wert von Laenge.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getLaenge() {
			return _laenge;
		}
	
		/**
		Prognose der räumlichen Ausdehnung des
								Stauobjekts im Prognoseschritt.
		<p>
		
		</p>
		
		@param _laenge der neue Wert von Laenge.
		*/
		public void setLaenge(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _laenge) {
			this._laenge = _laenge;
		}
	
		/**
		Maximale Verlustzeit durch den Stau.
		<p>
		
		</p>
		
		@return der Wert von VerlustZeit.
		*/
			public 	RelativerZeitstempel
			 getVerlustZeit() {
			return _verlustZeit;
		}
	
		/**
		Maximale Verlustzeit durch den Stau.
		<p>
		
		</p>
		
		@param _verlustZeit der neue Wert von VerlustZeit.
		*/
		public void setVerlustZeit(	RelativerZeitstempel
		 _verlustZeit) {
			this._verlustZeit = _verlustZeit;
		}
	
		/**
		Geschwindigkeit der Fahrzeuge im Stau.
		<p>
		
		</p>
		
		@return der Wert von VKfz.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 getVKfz() {
			return _vKfz;
		}
	
		/**
		Geschwindigkeit der Fahrzeuge im Stau.
		<p>
		
		</p>
		
		@param _vKfz der neue Wert von VKfz.
		*/
		public void setVKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
		 _vKfz) {
			this._vKfz = _vKfz;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getZufluss() != null) {
	                if (getZufluss().isZustand()) {
	                    datum.getUnscaledValue("Zufluss").setText(getZufluss().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Zufluss").set(getZufluss().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getKapazitaet() != null) {
	                if (getKapazitaet().isZustand()) {
	                    datum.getUnscaledValue("Kapazität").setText(getKapazitaet().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Kapazität").set(getKapazitaet().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getLaenge() != null) {
	                if (getLaenge().isZustand()) {
	                    datum.getUnscaledValue("Länge").setText(getLaenge().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Länge").set(getLaenge().getValue());
	                }
				}
				// ZeitstempelAttributTyp
					datum.getTimeValue("VerlustZeit").setMillis(getVerlustZeit().getTime());
				// GanzzahlAttributTyp
				if (getVKfz() != null) {
	                if (getVKfz().isZustand()) {
	                    datum.getUnscaledValue("vKfz").setText(getVKfz().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("vKfz").set(getVKfz().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Zufluss").isState()) {
							setZufluss(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
							.getZustand(daten.getScaledValue("Zufluss").getText()));
						} else {
						setZufluss(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
						(daten.
							getUnscaledValue
						("Zufluss").
								intValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Kapazität").isState()) {
							setKapazitaet(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
							.getZustand(daten.getScaledValue("Kapazität").getText()));
						} else {
						setKapazitaet(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
						(daten.
							getUnscaledValue
						("Kapazität").
								intValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Länge").isState()) {
							setLaenge(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("Länge").getText()));
						} else {
						setLaenge(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("Länge").
								longValue
						()));
						}
				// ZeitstempelAttributTyp
					setVerlustZeit(new
						RelativerZeitstempel
						(daten.getTimeValue("VerlustZeit").getMillis()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("vKfz").isState()) {
							setVKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							.getZustand(daten.getScaledValue("vKfz").getText()));
						} else {
						setVKfz(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
						(daten.
							getUnscaledValue
						("vKfz").
								shortValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlStauVerlaufPrognoseSchritt clone() {
		AtlStauVerlaufPrognoseSchritt klon = new AtlStauVerlaufPrognoseSchritt();
		
						klon.setZufluss(getZufluss());
						klon.setKapazitaet(getKapazitaet());
						klon.setLaenge(getLaenge());
						klon.setVerlustZeit(getVerlustZeit());
						klon.setVKfz(getVKfz());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
