/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameterwerte für die Berechnung von geglätteten
					und trendextrapolierten Werten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTrendExtraPolation implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 _alpha1
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 _beta1
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 _alpha2
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 _beta2
			;
	
		/**
		Glättungsparameter für abnehmende Messwerte.
		<p>
		
		</p>
		
		@return der Wert von Alpha1.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 getAlpha1() {
			return _alpha1;
		}
	
		/**
		Glättungsparameter für abnehmende Messwerte.
		<p>
		
		</p>
		
		@param _alpha1 der neue Wert von Alpha1.
		*/
		public void setAlpha1(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
		 _alpha1) {
			this._alpha1 = _alpha1;
		}
	
		/**
		Prognoseparameter für abnehmende Messwerte.
		<p>
		
		</p>
		
		@return der Wert von Beta1.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 getBeta1() {
			return _beta1;
		}
	
		/**
		Prognoseparameter für abnehmende Messwerte.
		<p>
		
		</p>
		
		@param _beta1 der neue Wert von Beta1.
		*/
		public void setBeta1(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
		 _beta1) {
			this._beta1 = _beta1;
		}
	
		/**
		Glättungsparameter für steigende Messwerte.
		<p>
		
		</p>
		
		@return der Wert von Alpha2.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 getAlpha2() {
			return _alpha2;
		}
	
		/**
		Glättungsparameter für steigende Messwerte.
		<p>
		
		</p>
		
		@param _alpha2 der neue Wert von Alpha2.
		*/
		public void setAlpha2(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
		 _alpha2) {
			this._alpha2 = _alpha2;
		}
	
		/**
		Prognoseparameter für steigende Messwerte.
		<p>
		
		</p>
		
		@return der Wert von Beta2.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
			 getBeta2() {
			return _beta2;
		}
	
		/**
		Prognoseparameter für steigende Messwerte.
		<p>
		
		</p>
		
		@param _beta2 der neue Wert von Beta2.
		*/
		public void setBeta2(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
		 _beta2) {
			this._beta2 = _beta2;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getAlpha1() != null) {
	                if (getAlpha1().isZustand()) {
	                    datum.getUnscaledValue("alpha1").setText(getAlpha1().toString());
	                } else {
						datum.
						getScaledValue
	                	("alpha1").set(getAlpha1().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getBeta1() != null) {
	                if (getBeta1().isZustand()) {
	                    datum.getUnscaledValue("beta1").setText(getBeta1().toString());
	                } else {
						datum.
						getScaledValue
	                	("beta1").set(getBeta1().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getAlpha2() != null) {
	                if (getAlpha2().isZustand()) {
	                    datum.getUnscaledValue("alpha2").setText(getAlpha2().toString());
	                } else {
						datum.
						getScaledValue
	                	("alpha2").set(getAlpha2().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getBeta2() != null) {
	                if (getBeta2().isZustand()) {
	                    datum.getUnscaledValue("beta2").setText(getBeta2().toString());
	                } else {
						datum.
						getScaledValue
	                	("beta2").set(getBeta2().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						setAlpha1(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
						(daten.
							getScaledValue
						("alpha1").
							doubleValue
						()));
				// GanzzahlAttributTyp
						setBeta1(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
						(daten.
							getScaledValue
						("beta1").
							doubleValue
						()));
				// GanzzahlAttributTyp
						setAlpha2(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
						(daten.
							getScaledValue
						("alpha2").
							doubleValue
						()));
				// GanzzahlAttributTyp
						setBeta2(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv2NachKommaStellenVon0Bis1
						(daten.
							getScaledValue
						("beta2").
							doubleValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTrendExtraPolation clone() {
		AtlTrendExtraPolation klon = new AtlTrendExtraPolation();
		
						klon.setAlpha1(getAlpha1());
						klon.setBeta1(getBeta1());
						klon.setAlpha2(getAlpha2());
						klon.setBeta2(getBeta2());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
