/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributtyp zur Identifikation der einzelnen Module.
					Ggf. können hier noch Weitere hinzukommen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 7
 */
public class AttModulTyp extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttModulTyp ZUSTAND_1_PLPRUEFUNGFORMAL = new AttModulTyp("PlPrüfungFormal", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttModulTyp ZUSTAND_2_PLPRUEFUNGLOGISCHUFD = new AttModulTyp("PlPrüfungLogischUFD", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttModulTyp ZUSTAND_3_PLPRUEFUNGLOGISCHWZG = new AttModulTyp("PlPrüfungLogischWZG", 		Byte
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttModulTyp ZUSTAND_4_PLPRUEFUNGMESSWERTERSETZUNGLVE = new AttModulTyp("PlPrüfungMesswertErsetzungLVE", 		Byte
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttModulTyp ZUSTAND_5_PLPRUEFUNGMESSWERTERSETZUNGUFD = new AttModulTyp("PlPrüfungMesswertErsetzungUFD", 		Byte
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttModulTyp ZUSTAND_6_PLPRUEFUNGLANGZEITUFD = new AttModulTyp("PlPrüfungLangZeitUFD", 		Byte
	.valueOf("6"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttModulTyp getZustand(final 		Byte
	 value) {
		for (AttModulTyp e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttModulTyp getZustand(final String value) {
		for (AttModulTyp e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttModulTyp> getZustaende() {
		List<AttModulTyp> list = new ArrayList<AttModulTyp>();
		list.add(ZUSTAND_1_PLPRUEFUNGFORMAL);
		list.add(ZUSTAND_2_PLPRUEFUNGLOGISCHUFD);
		list.add(ZUSTAND_3_PLPRUEFUNGLOGISCHWZG);
		list.add(ZUSTAND_4_PLPRUEFUNGMESSWERTERSETZUNGLVE);
		list.add(ZUSTAND_5_PLPRUEFUNGMESSWERTERSETZUNGUFD);
		list.add(ZUSTAND_6_PLPRUEFUNGLANGZEITUFD);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut ModulTyp.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttModulTyp(final 		Byte
	 value) {
		super(value);
	}
	
	private AttModulTyp(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
