/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Typ des Straßenknotens (AutobahnKreuz,
					Anschlussstelle, ..
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttStrassenKnotenTyp extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Sonstiger unspezifizierter Knoten.
	<p>
	
	</p>
	*/
	public static final AttStrassenKnotenTyp ZUSTAND_0_SONSTIGERKNOTEN = new AttStrassenKnotenTyp("SonstigerKnoten", 		Byte
	.valueOf("0"));

	/**
	Knoten ist ein Autobahnkreuz.
	<p>
	
	</p>
	*/
	public static final AttStrassenKnotenTyp ZUSTAND_1_AUTOBAHNKREUZ = new AttStrassenKnotenTyp("AutobahnKreuz", 		Byte
	.valueOf("1"));

	/**
	Knoten ist ein Autobahndreieck.
	<p>
	
	</p>
	*/
	public static final AttStrassenKnotenTyp ZUSTAND_2_AUTOBAHNDREIECK = new AttStrassenKnotenTyp("AutobahnDreieck", 		Byte
	.valueOf("2"));

	/**
	Knoten ist eine Autobahnanschlussstelle.
	<p>
	
	</p>
	*/
	public static final AttStrassenKnotenTyp ZUSTAND_3_AUTOBAHNANSCHLUSSSTELLE = new AttStrassenKnotenTyp("AutobahnAnschlussStelle", 		Byte
	.valueOf("3"));

	/**
	Knoten markiert das Ende der Autobahn.
	<p>
	
	</p>
	*/
	public static final AttStrassenKnotenTyp ZUSTAND_4_AUTOBAHNENDE = new AttStrassenKnotenTyp("AutobahnEnde", 		Byte
	.valueOf("4"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttStrassenKnotenTyp getZustand(final 		Byte
	 value) {
		for (AttStrassenKnotenTyp e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttStrassenKnotenTyp getZustand(final String value) {
		for (AttStrassenKnotenTyp e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttStrassenKnotenTyp> getZustaende() {
		List<AttStrassenKnotenTyp> list = new ArrayList<AttStrassenKnotenTyp>();
		list.add(ZUSTAND_0_SONSTIGERKNOTEN);
		list.add(ZUSTAND_1_AUTOBAHNKREUZ);
		list.add(ZUSTAND_2_AUTOBAHNDREIECK);
		list.add(ZUSTAND_3_AUTOBAHNANSCHLUSSSTELLE);
		list.add(ZUSTAND_4_AUTOBAHNENDE);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut StraßenKnotenTyp.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttStrassenKnotenTyp(final 		Byte
	 value) {
		super(value);
	}
	
	private AttStrassenKnotenTyp(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
