/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Typ der Straße (Autobahn, Bundesstraße,
					Landstraße,...).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttStrassenTyp extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Sonstiger Straßentyp.
	<p>
	
	</p>
	*/
	public static final AttStrassenTyp ZUSTAND_0_SONSTIGESTRASSE = new AttStrassenTyp("SonstigeStraße", 		Byte
	.valueOf("0"));

	/**
	Straße ist Autobahn.
	<p>
	
	</p>
	*/
	public static final AttStrassenTyp ZUSTAND_1_AUTOBAHN = new AttStrassenTyp("Autobahn", 		Byte
	.valueOf("1"));

	/**
	Straße ist Bundesstraße.
	<p>
	
	</p>
	*/
	public static final AttStrassenTyp ZUSTAND_2_BUNDESSTRASSE = new AttStrassenTyp("Bundesstraße", 		Byte
	.valueOf("2"));

	/**
	Straße ist Landstraße.
	<p>
	
	</p>
	*/
	public static final AttStrassenTyp ZUSTAND_3_LANDSTRASSE = new AttStrassenTyp("Landstraße", 		Byte
	.valueOf("3"));

	/**
	Straße ist Kreisstraße.
	<p>
	
	</p>
	*/
	public static final AttStrassenTyp ZUSTAND_4_KREISSTRASSE = new AttStrassenTyp("Kreisstraße", 		Byte
	.valueOf("4"));

	/**
	Straße ist Stadtstraße.
	<p>
	
	</p>
	*/
	public static final AttStrassenTyp ZUSTAND_5_STADTSTRASSE = new AttStrassenTyp("Stadtstraße", 		Byte
	.valueOf("5"));

	/**
	Straße ist städtische Hauptverkehrsstraße.
	<p>
	
	</p>
	*/
	public static final AttStrassenTyp ZUSTAND_6_HAUPTVERKEHRSSTRASSE = new AttStrassenTyp("Hauptverkehrsstraße", 		Byte
	.valueOf("6"));

	/**
	Straße ist städtische Sammelstraße.
	<p>
	
	</p>
	*/
	public static final AttStrassenTyp ZUSTAND_7_SAMMELSTRASSE = new AttStrassenTyp("Sammelstraße", 		Byte
	.valueOf("7"));

	/**
	Straße ist städtische Anliegerstraße.
	<p>
	
	</p>
	*/
	public static final AttStrassenTyp ZUSTAND_8_ANLIEGERSTRASSE = new AttStrassenTyp("Anliegerstraße", 		Byte
	.valueOf("8"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttStrassenTyp getZustand(final 		Byte
	 value) {
		for (AttStrassenTyp e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttStrassenTyp getZustand(final String value) {
		for (AttStrassenTyp e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttStrassenTyp> getZustaende() {
		List<AttStrassenTyp> list = new ArrayList<AttStrassenTyp>();
		list.add(ZUSTAND_0_SONSTIGESTRASSE);
		list.add(ZUSTAND_1_AUTOBAHN);
		list.add(ZUSTAND_2_BUNDESSTRASSE);
		list.add(ZUSTAND_3_LANDSTRASSE);
		list.add(ZUSTAND_4_KREISSTRASSE);
		list.add(ZUSTAND_5_STADTSTRASSE);
		list.add(ZUSTAND_6_HAUPTVERKEHRSSTRASSE);
		list.add(ZUSTAND_7_SAMMELSTRASSE);
		list.add(ZUSTAND_8_ANLIEGERSTRASSE);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut StraßenTyp.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttStrassenTyp(final 		Byte
	 value) {
		super(value);
	}
	
	private AttStrassenTyp(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
