/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definiert das Verhalten der Grenzwertprüfung bei Überschreitung des Grenzwerts.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 59
 */
public class AttVerhaltenGrenzwertPruefungVerkehr extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Es wird keine Wertebereichsprüfung durchgeführt und demnach der Wert nicht verändert,
								kein Statusflag
								gesetzt und die Güte nicht verändert.
	<p>
	
	</p>
	*/
	public static final AttVerhaltenGrenzwertPruefungVerkehr ZUSTAND_0_KEINE_PRUEFUNG = new AttVerhaltenGrenzwertPruefungVerkehr("Keine Prüfung", 		Byte
	.valueOf("0"));

	/**
	Bei Messwertüberschreitung wird der Wert auf den parametrierten maximalen Wert gesetzt und
								mit dem Statusflag
								WertMaxLogisch gekennzeichnet. Die Güte der Werte ist nicht zu verändern.
	<p>
	
	</p>
	*/
	public static final AttVerhaltenGrenzwertPruefungVerkehr ZUSTAND_1_WERT_REDUZIEREN = new AttVerhaltenGrenzwertPruefungVerkehr("Wert reduzieren", 		Byte
	.valueOf("1"));

	/**
	Bei Messwertüberschreitung wird der Wert als implausibel und mit dem Statusflag
								WertMaxLogisch
								gekennzeichnet und auf fehlerhaft gesetzt. Die Güte der Werte ist um 20 % zu reduzieren
								(Faktor 0,8).
								Es wird eine Betriebsmeldung erzeugt.
	<p>
	
	</p>
	*/
	public static final AttVerhaltenGrenzwertPruefungVerkehr ZUSTAND_2_AUF_FEHLERHAFT_SETZEN = new AttVerhaltenGrenzwertPruefungVerkehr("Auf fehlerhaft setzen", 		Byte
	.valueOf("2"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttVerhaltenGrenzwertPruefungVerkehr getZustand(final 		Byte
	 value) {
		for (AttVerhaltenGrenzwertPruefungVerkehr e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttVerhaltenGrenzwertPruefungVerkehr getZustand(final String value) {
		for (AttVerhaltenGrenzwertPruefungVerkehr e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttVerhaltenGrenzwertPruefungVerkehr> getZustaende() {
		List<AttVerhaltenGrenzwertPruefungVerkehr> list = new ArrayList<AttVerhaltenGrenzwertPruefungVerkehr>();
		list.add(ZUSTAND_0_KEINE_PRUEFUNG);
		list.add(ZUSTAND_1_WERT_REDUZIEREN);
		list.add(ZUSTAND_2_AUF_FEHLERHAFT_SETZEN);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut verhaltenGrenzwertPrüfungVerkehr.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttVerhaltenGrenzwertPruefungVerkehr(final 		Byte
	 value) {
		super(value);
	}
	
	private AttVerhaltenGrenzwertPruefungVerkehr(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
