/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Verkehrliche Einschränkung auf einem Streckenabschnitt.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 55
 */
public class AttVerkehrlicheBeschraenkung extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Zulässige Höchstgeschwindigkeit 5 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_1__5_KM_H = new AttVerkehrlicheBeschraenkung("5 km/h", 		Short
	.valueOf("1"));

	/**
	Zulässige Höchstgeschwindigkeit 10 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_2__10_KM_H = new AttVerkehrlicheBeschraenkung("10 km/h", 		Short
	.valueOf("2"));

	/**
	Zulässige Höchstgeschwindigkeit 15 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_3__15_KM_H = new AttVerkehrlicheBeschraenkung("15 km/h", 		Short
	.valueOf("3"));

	/**
	Zulässige Höchstgeschwindigkeit 20 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_4__20_KM_H = new AttVerkehrlicheBeschraenkung("20 km/h", 		Short
	.valueOf("4"));

	/**
	Zulässige Höchstgeschwindigkeit 25 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_5__25_KM_H = new AttVerkehrlicheBeschraenkung("25 km/h", 		Short
	.valueOf("5"));

	/**
	Zulässige Höchstgeschwindigkeit 30 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_6__30_KM_H = new AttVerkehrlicheBeschraenkung("30 km/h", 		Short
	.valueOf("6"));

	/**
	Zulässige Höchstgeschwindigkeit 35 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_7__35_KM_H = new AttVerkehrlicheBeschraenkung("35 km/h", 		Short
	.valueOf("7"));

	/**
	Zulässige Höchstgeschwindigkeit 40 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_8__40_KM_H = new AttVerkehrlicheBeschraenkung("40 km/h", 		Short
	.valueOf("8"));

	/**
	Zulässige Höchstgeschwindigkeit 45 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_9__45_KM_H = new AttVerkehrlicheBeschraenkung("45 km/h", 		Short
	.valueOf("9"));

	/**
	Zulässige Höchstgeschwindigkeit 50 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_10__50_KM_H = new AttVerkehrlicheBeschraenkung("50 km/h", 		Short
	.valueOf("10"));

	/**
	Zulässige Höchstgeschwindigkeit 55 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_11__55_KM_H = new AttVerkehrlicheBeschraenkung("55 km/h", 		Short
	.valueOf("11"));

	/**
	Zulässige Höchstgeschwindigkeit 60 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_12__60_KM_H = new AttVerkehrlicheBeschraenkung("60 km/h", 		Short
	.valueOf("12"));

	/**
	Zulässige Höchstgeschwindigkeit 65 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_13__65_KM_H = new AttVerkehrlicheBeschraenkung("65 km/h", 		Short
	.valueOf("13"));

	/**
	Zulässige Höchstgeschwindigkeit 70 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_14__70_KM_H = new AttVerkehrlicheBeschraenkung("70 km/h", 		Short
	.valueOf("14"));

	/**
	Zulässige Höchstgeschwindigkeit 75 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_15__75_KM_H = new AttVerkehrlicheBeschraenkung("75 km/h", 		Short
	.valueOf("15"));

	/**
	Zulässige Höchstgeschwindigkeit 80 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_16__80_KM_H = new AttVerkehrlicheBeschraenkung("80 km/h", 		Short
	.valueOf("16"));

	/**
	Zulässige Höchstgeschwindigkeit 85 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_17__85_KM_H = new AttVerkehrlicheBeschraenkung("85 km/h", 		Short
	.valueOf("17"));

	/**
	Zulässige Höchstgeschwindigkeit 90 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_18__90_KM_H = new AttVerkehrlicheBeschraenkung("90 km/h", 		Short
	.valueOf("18"));

	/**
	Zulässige Höchstgeschwindigkeit 95 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_19__95_KM_H = new AttVerkehrlicheBeschraenkung("95 km/h", 		Short
	.valueOf("19"));

	/**
	Zulässige Höchstgeschwindigkeit 100 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_20__100_KM_H = new AttVerkehrlicheBeschraenkung("100 km/h", 		Short
	.valueOf("20"));

	/**
	Zulässige Höchstgeschwindigkeit 105 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_21__105_KM_H = new AttVerkehrlicheBeschraenkung("105 km/h", 		Short
	.valueOf("21"));

	/**
	Zulässige Höchstgeschwindigkeit 110 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_22__110_KM_H = new AttVerkehrlicheBeschraenkung("110 km/h", 		Short
	.valueOf("22"));

	/**
	Zulässige Höchstgeschwindigkeit 115 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_23__115_KM_H = new AttVerkehrlicheBeschraenkung("115 km/h", 		Short
	.valueOf("23"));

	/**
	Zulässige Höchstgeschwindigkeit 120 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_24__120_KM_H = new AttVerkehrlicheBeschraenkung("120 km/h", 		Short
	.valueOf("24"));

	/**
	Zulässige Höchstgeschwindigkeit 125 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_25__125_KM_H = new AttVerkehrlicheBeschraenkung("125 km/h", 		Short
	.valueOf("25"));

	/**
	Zulässige Höchstgeschwindigkeit 130 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_26__130_KM_H = new AttVerkehrlicheBeschraenkung("130 km/h", 		Short
	.valueOf("26"));

	/**
	Zulässige Höchstgeschwindigkeit 135 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_27__135_KM_H = new AttVerkehrlicheBeschraenkung("135 km/h", 		Short
	.valueOf("27"));

	/**
	Zulässige Höchstgeschwindigkeit 140 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_28__140_KM_H = new AttVerkehrlicheBeschraenkung("140 km/h", 		Short
	.valueOf("28"));

	/**
	Zulässige Höchstgeschwindigkeit 145 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_29__145_KM_H = new AttVerkehrlicheBeschraenkung("145 km/h", 		Short
	.valueOf("29"));

	/**
	Zulässige Höchstgeschwindigkeit 150 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_30__150_KM_H = new AttVerkehrlicheBeschraenkung("150 km/h", 		Short
	.valueOf("30"));

	/**
	Zulässige Höchstgeschwindigkeit 155 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_31__155_KM_H = new AttVerkehrlicheBeschraenkung("155 km/h", 		Short
	.valueOf("31"));

	/**
	Zulässige Höchstgeschwindigkeit 160 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_32__160_KM_H = new AttVerkehrlicheBeschraenkung("160 km/h", 		Short
	.valueOf("32"));

	/**
	Zulässige Höchstgeschwindigkeit 165 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_33__165_KM_H = new AttVerkehrlicheBeschraenkung("165 km/h", 		Short
	.valueOf("33"));

	/**
	Zulässige Höchstgeschwindigkeit 170 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_34__170_KM_H = new AttVerkehrlicheBeschraenkung("170 km/h", 		Short
	.valueOf("34"));

	/**
	Zulässige Höchstgeschwindigkeit 175 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_35__175_KM_H = new AttVerkehrlicheBeschraenkung("175 km/h", 		Short
	.valueOf("35"));

	/**
	Zulässige Höchstgeschwindigkeit 180 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_36__180_KM_H = new AttVerkehrlicheBeschraenkung("180 km/h", 		Short
	.valueOf("36"));

	/**
	Zulässige Höchstgeschwindigkeit 185 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_37__185_KM_H = new AttVerkehrlicheBeschraenkung("185 km/h", 		Short
	.valueOf("37"));

	/**
	Zulässige Höchstgeschwindigkeit 190 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_38__190_KM_H = new AttVerkehrlicheBeschraenkung("190 km/h", 		Short
	.valueOf("38"));

	/**
	Zulässige Höchstgeschwindigkeit 195 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_39__195_KM_H = new AttVerkehrlicheBeschraenkung("195 km/h", 		Short
	.valueOf("39"));

	/**
	Zulässige Höchstgeschwindigkeit 200 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_40__200_KM_H = new AttVerkehrlicheBeschraenkung("200 km/h", 		Short
	.valueOf("40"));

	/**
	Keine Geschwindigkeitsschränkung, insbesondere relevant auf (deutschen) BAB.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_41_KEINE_GESCHWINDIGKEITSSCHRAENKUNG = new AttVerkehrlicheBeschraenkung("Keine Geschwindigkeitsschränkung", 		Short
	.valueOf("41"));

	/**
	Variable Geschwindigkeitsbeschränkung, wird im Bereich von WZG mit variabler
								Geschwindigkeitsbeschränkung verwendet.
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_42_VARIABLE_GESCHWINDIGKEITSBESCHRAENKUNG = new AttVerkehrlicheBeschraenkung("Variable Geschwindigkeitsbeschränkung", 		Short
	.valueOf("42"));

	/**
	Überholverbot, weitere Bedingungen enthält das Attrribut "Bedingung".
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_43_UEBERHOLVERBOT = new AttVerkehrlicheBeschraenkung("Überholverbot", 		Short
	.valueOf("43"));

	/**
	Verkehrsverbot, weitere Bedingungen enthält das Attrribut "Bedingung".
	<p>
	
	</p>
	*/
	public static final AttVerkehrlicheBeschraenkung ZUSTAND_44_VERKEHRSVERBOT = new AttVerkehrlicheBeschraenkung("Verkehrsverbot", 		Short
	.valueOf("44"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttVerkehrlicheBeschraenkung getZustand(final 		Short
	 value) {
		for (AttVerkehrlicheBeschraenkung e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttVerkehrlicheBeschraenkung getZustand(final String value) {
		for (AttVerkehrlicheBeschraenkung e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttVerkehrlicheBeschraenkung> getZustaende() {
		List<AttVerkehrlicheBeschraenkung> list = new ArrayList<AttVerkehrlicheBeschraenkung>();
		list.add(ZUSTAND_1__5_KM_H);
		list.add(ZUSTAND_2__10_KM_H);
		list.add(ZUSTAND_3__15_KM_H);
		list.add(ZUSTAND_4__20_KM_H);
		list.add(ZUSTAND_5__25_KM_H);
		list.add(ZUSTAND_6__30_KM_H);
		list.add(ZUSTAND_7__35_KM_H);
		list.add(ZUSTAND_8__40_KM_H);
		list.add(ZUSTAND_9__45_KM_H);
		list.add(ZUSTAND_10__50_KM_H);
		list.add(ZUSTAND_11__55_KM_H);
		list.add(ZUSTAND_12__60_KM_H);
		list.add(ZUSTAND_13__65_KM_H);
		list.add(ZUSTAND_14__70_KM_H);
		list.add(ZUSTAND_15__75_KM_H);
		list.add(ZUSTAND_16__80_KM_H);
		list.add(ZUSTAND_17__85_KM_H);
		list.add(ZUSTAND_18__90_KM_H);
		list.add(ZUSTAND_19__95_KM_H);
		list.add(ZUSTAND_20__100_KM_H);
		list.add(ZUSTAND_21__105_KM_H);
		list.add(ZUSTAND_22__110_KM_H);
		list.add(ZUSTAND_23__115_KM_H);
		list.add(ZUSTAND_24__120_KM_H);
		list.add(ZUSTAND_25__125_KM_H);
		list.add(ZUSTAND_26__130_KM_H);
		list.add(ZUSTAND_27__135_KM_H);
		list.add(ZUSTAND_28__140_KM_H);
		list.add(ZUSTAND_29__145_KM_H);
		list.add(ZUSTAND_30__150_KM_H);
		list.add(ZUSTAND_31__155_KM_H);
		list.add(ZUSTAND_32__160_KM_H);
		list.add(ZUSTAND_33__165_KM_H);
		list.add(ZUSTAND_34__170_KM_H);
		list.add(ZUSTAND_35__175_KM_H);
		list.add(ZUSTAND_36__180_KM_H);
		list.add(ZUSTAND_37__185_KM_H);
		list.add(ZUSTAND_38__190_KM_H);
		list.add(ZUSTAND_39__195_KM_H);
		list.add(ZUSTAND_40__200_KM_H);
		list.add(ZUSTAND_41_KEINE_GESCHWINDIGKEITSSCHRAENKUNG);
		list.add(ZUSTAND_42_VARIABLE_GESCHWINDIGKEITSBESCHRAENKUNG);
		list.add(ZUSTAND_43_UEBERHOLVERBOT);
		list.add(ZUSTAND_44_VERKEHRSVERBOT);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut VerkehrlicheBeschränkung.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttVerkehrlicheBeschraenkung(final 		Short
	 value) {
		super(value);
	}
	
	private AttVerkehrlicheBeschraenkung(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
