/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Konfigurierende Eigenschaften der Objekte des Typs.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 10
 */
public class KdAeusseresStrassenSegment extends AbstractKonfigurationsDatensatz<KdAeusseresStrassenSegment.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenKnoten
				 _vonKnoten
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenKnoten
				 _nachKnoten
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.TmcPunkt
				 _tmcPrimaerOrt
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcRichtung
				 _tmcRichtung
				;
		
			/**
			Äußeres Straßensegment wird begrenzt durch
									vonKnoten.
			<p>
			
			</p>
			
			@return der Wert von VonKnoten.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenKnoten
				 getVonKnoten() {
				return _vonKnoten;
			}
		
			/**
			Äußeres Straßensegment wird begrenzt durch
									vonKnoten.
			<p>
			
			</p>
			
			@param _vonKnoten der neue Wert von VonKnoten.
			*/
			public void setVonKnoten(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenKnoten
			 _vonKnoten) {
				this._vonKnoten = _vonKnoten;
			}
		
			/**
			... bis zu nachKnoten.
			<p>
			
			</p>
			
			@return der Wert von NachKnoten.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenKnoten
				 getNachKnoten() {
				return _nachKnoten;
			}
		
			/**
			... bis zu nachKnoten.
			<p>
			
			</p>
			
			@param _nachKnoten der neue Wert von NachKnoten.
			*/
			public void setNachKnoten(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenKnoten
			 _nachKnoten) {
				this._nachKnoten = _nachKnoten;
			}
		
			/**
			TMCPunkt, am Ende des Segments (in
									Fahrtrichtung).
			<p>
			
			</p>
			
			@return der Wert von TmcPrimaerOrt.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.TmcPunkt
				 getTmcPrimaerOrt() {
				return _tmcPrimaerOrt;
			}
		
			/**
			TMCPunkt, am Ende des Segments (in
									Fahrtrichtung).
			<p>
			
			</p>
			
			@param _tmcPrimaerOrt der neue Wert von TmcPrimaerOrt.
			*/
			public void setTmcPrimaerOrt(	de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.TmcPunkt
			 _tmcPrimaerOrt) {
				this._tmcPrimaerOrt = _tmcPrimaerOrt;
			}
		
			/**
			Richtung der TMCLocation.
			<p>
			
			</p>
			
			@return der Wert von TmcRichtung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcRichtung
				 getTmcRichtung() {
				return _tmcRichtung;
			}
		
			/**
			Richtung der TMCLocation.
			<p>
			
			</p>
			
			@param _tmcRichtung der neue Wert von TmcRichtung.
			*/
			public void setTmcRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcRichtung
			 _tmcRichtung) {
				this._tmcRichtung = _tmcRichtung;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Object soVonKnoten = getVonKnoten();
						final SystemObject tmpVonKnoten;
							if (soVonKnoten instanceof SystemObject) {
								tmpVonKnoten = (SystemObject)soVonKnoten;
							} else if(soVonKnoten instanceof SystemObjekt){
								tmpVonKnoten = ((SystemObjekt)soVonKnoten).getSystemObject();
							} else{
								tmpVonKnoten = null;
							}
						datum.getReferenceValue("vonKnoten").setSystemObject(tmpVonKnoten);
					// ObjektReferenzAttributTyp
						final Object soNachKnoten = getNachKnoten();
						final SystemObject tmpNachKnoten;
							if (soNachKnoten instanceof SystemObject) {
								tmpNachKnoten = (SystemObject)soNachKnoten;
							} else if(soNachKnoten instanceof SystemObjekt){
								tmpNachKnoten = ((SystemObjekt)soNachKnoten).getSystemObject();
							} else{
								tmpNachKnoten = null;
							}
						datum.getReferenceValue("nachKnoten").setSystemObject(tmpNachKnoten);
					// ObjektReferenzAttributTyp
						final Object soTmcPrimaerOrt = getTmcPrimaerOrt();
						final SystemObject tmpTmcPrimaerOrt;
							if (soTmcPrimaerOrt instanceof SystemObject) {
								tmpTmcPrimaerOrt = (SystemObject)soTmcPrimaerOrt;
							} else if(soTmcPrimaerOrt instanceof SystemObjekt){
								tmpTmcPrimaerOrt = ((SystemObjekt)soTmcPrimaerOrt).getSystemObject();
							} else{
								tmpTmcPrimaerOrt = null;
							}
						datum.getReferenceValue("TmcPrimärOrt").setSystemObject(tmpTmcPrimaerOrt);
					// GanzzahlAttributTyp
					if (getTmcRichtung() != null) {
		                if (getTmcRichtung().isZustand()) {
		                    datum.getUnscaledValue("TmcRichtung").setText(getTmcRichtung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("TmcRichtung").set(getTmcRichtung().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final long idVonKnoten = daten.getReferenceValue("vonKnoten").getId();
						final SystemObjekt tmpVonKnoten;
						if (idVonKnoten == 0) {
							tmpVonKnoten = null;
						} else {
							final SystemObject soVonKnoten = factory.getDav().getDataModel().getObject(idVonKnoten);
							if (soVonKnoten == null) {
									tmpVonKnoten = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.StrassenKnotenUngueltig(idVonKnoten);
							} else {
								tmpVonKnoten = factory.getModellobjekt(soVonKnoten);
							}
						}
						setVonKnoten((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenKnoten
						) tmpVonKnoten);
					// ObjektReferenzAttributTyp
						final long idNachKnoten = daten.getReferenceValue("nachKnoten").getId();
						final SystemObjekt tmpNachKnoten;
						if (idNachKnoten == 0) {
							tmpNachKnoten = null;
						} else {
							final SystemObject soNachKnoten = factory.getDav().getDataModel().getObject(idNachKnoten);
							if (soNachKnoten == null) {
									tmpNachKnoten = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.StrassenKnotenUngueltig(idNachKnoten);
							} else {
								tmpNachKnoten = factory.getModellobjekt(soNachKnoten);
							}
						}
						setNachKnoten((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenKnoten
						) tmpNachKnoten);
					// ObjektReferenzAttributTyp
						final long idTmcPrimaerOrt = daten.getReferenceValue("TmcPrimärOrt").getId();
						final SystemObjekt tmpTmcPrimaerOrt;
						if (idTmcPrimaerOrt == 0) {
							tmpTmcPrimaerOrt = null;
						} else {
							final SystemObject soTmcPrimaerOrt = factory.getDav().getDataModel().getObject(idTmcPrimaerOrt);
							if (soTmcPrimaerOrt == null) {
									tmpTmcPrimaerOrt = new de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.impl.TmcPunktUngueltig(idTmcPrimaerOrt);
							} else {
								tmpTmcPrimaerOrt = factory.getModellobjekt(soTmcPrimaerOrt);
							}
						}
						setTmcPrimaerOrt((	de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.TmcPunkt
						) tmpTmcPrimaerOrt);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("TmcRichtung").isState()) {
								setTmcRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcRichtung
								.getZustand(daten.getScaledValue("TmcRichtung").getText()));
							} else {
							setTmcRichtung(new de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcRichtung
							(daten.
								getUnscaledValue
							("TmcRichtung").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setVonKnoten(getVonKnoten());
							klon.setNachKnoten(getNachKnoten());
							klon.setTmcPrimaerOrt(getTmcPrimaerOrt());
							klon.setTmcRichtung(getTmcRichtung());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.äußeresStraßenSegment";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdAeusseresStrassenSegment(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
