/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Konfigurierende Eigenschaften der Objekte des Typs.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 10
 */
public class KdInneresStrassenSegment extends AbstractKonfigurationsDatensatz<KdInneresStrassenSegment.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.AeusseresStrassenSegment
				 _vonStrassenSegment
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.AeusseresStrassenSegment
				 _nachStrassenSegment
				;
		
			/**
			Inneres Straßensegment bildet Fahrbeziehung im
									Knoten von diesem referenzierten
									Strßensegment...
			<p>
			
			</p>
			
			@return der Wert von VonStrassenSegment.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.AeusseresStrassenSegment
				 getVonStrassenSegment() {
				return _vonStrassenSegment;
			}
		
			/**
			Inneres Straßensegment bildet Fahrbeziehung im
									Knoten von diesem referenzierten
									Strßensegment...
			<p>
			
			</p>
			
			@param _vonStrassenSegment der neue Wert von VonStrassenSegment.
			*/
			public void setVonStrassenSegment(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.AeusseresStrassenSegment
			 _vonStrassenSegment) {
				this._vonStrassenSegment = _vonStrassenSegment;
			}
		
			/**
			... bis zu diesem referenzierten Strßensegment.
			<p>
			
			</p>
			
			@return der Wert von NachStrassenSegment.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.AeusseresStrassenSegment
				 getNachStrassenSegment() {
				return _nachStrassenSegment;
			}
		
			/**
			... bis zu diesem referenzierten Strßensegment.
			<p>
			
			</p>
			
			@param _nachStrassenSegment der neue Wert von NachStrassenSegment.
			*/
			public void setNachStrassenSegment(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.AeusseresStrassenSegment
			 _nachStrassenSegment) {
				this._nachStrassenSegment = _nachStrassenSegment;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Object soVonStrassenSegment = getVonStrassenSegment();
						final SystemObject tmpVonStrassenSegment;
							if (soVonStrassenSegment instanceof SystemObject) {
								tmpVonStrassenSegment = (SystemObject)soVonStrassenSegment;
							} else if(soVonStrassenSegment instanceof SystemObjekt){
								tmpVonStrassenSegment = ((SystemObjekt)soVonStrassenSegment).getSystemObject();
							} else{
								tmpVonStrassenSegment = null;
							}
						datum.getReferenceValue("vonStraßenSegment").setSystemObject(tmpVonStrassenSegment);
					// ObjektReferenzAttributTyp
						final Object soNachStrassenSegment = getNachStrassenSegment();
						final SystemObject tmpNachStrassenSegment;
							if (soNachStrassenSegment instanceof SystemObject) {
								tmpNachStrassenSegment = (SystemObject)soNachStrassenSegment;
							} else if(soNachStrassenSegment instanceof SystemObjekt){
								tmpNachStrassenSegment = ((SystemObjekt)soNachStrassenSegment).getSystemObject();
							} else{
								tmpNachStrassenSegment = null;
							}
						datum.getReferenceValue("nachStraßenSegment").setSystemObject(tmpNachStrassenSegment);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final long idVonStrassenSegment = daten.getReferenceValue("vonStraßenSegment").getId();
						final SystemObjekt tmpVonStrassenSegment;
						if (idVonStrassenSegment == 0) {
							tmpVonStrassenSegment = null;
						} else {
							final SystemObject soVonStrassenSegment = factory.getDav().getDataModel().getObject(idVonStrassenSegment);
							if (soVonStrassenSegment == null) {
									tmpVonStrassenSegment = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.AeusseresStrassenSegmentUngueltig(idVonStrassenSegment);
							} else {
								tmpVonStrassenSegment = factory.getModellobjekt(soVonStrassenSegment);
							}
						}
						setVonStrassenSegment((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.AeusseresStrassenSegment
						) tmpVonStrassenSegment);
					// ObjektReferenzAttributTyp
						final long idNachStrassenSegment = daten.getReferenceValue("nachStraßenSegment").getId();
						final SystemObjekt tmpNachStrassenSegment;
						if (idNachStrassenSegment == 0) {
							tmpNachStrassenSegment = null;
						} else {
							final SystemObject soNachStrassenSegment = factory.getDav().getDataModel().getObject(idNachStrassenSegment);
							if (soNachStrassenSegment == null) {
									tmpNachStrassenSegment = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.AeusseresStrassenSegmentUngueltig(idNachStrassenSegment);
							} else {
								tmpNachStrassenSegment = factory.getModellobjekt(soNachStrassenSegment);
							}
						}
						setNachStrassenSegment((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.AeusseresStrassenSegment
						) tmpNachStrassenSegment);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setVonStrassenSegment(getVonStrassenSegment());
							klon.setNachStrassenSegment(getNachStrassenSegment());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.inneresStraßenSegment";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdInneresStrassenSegment(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
