/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Konfigurierende Eigenschaften der Objekte des Typs.
<p>
Diese Attributgruppe wird für die Definition von
					virtuellen MessQuerschnitten verwendet, die
					entsprechend der Spezifikation DUA ermittelt werden.
					Aus den Typen der bei der Berechnung zu verwendenden
					realen MessQuerschnitte ergibt sich sowohl die
					Berechnungsvorschrift als auch der&#47;die zu wählenden
					MQ für die Geschwindigkeitsübernahme oder die
					Messwertersetzung.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 10
 */
public class KdMessQuerschnittVirtuellStandard extends AbstractKonfigurationsDatensatz<KdMessQuerschnittVirtuellStandard.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttMessQuerschnittVirtuellLage
				 _lage
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
				 _messQuerschnittVor
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
				 _messQuerschnittMitte
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
				 _messQuerschnittNach
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
				 _messQuerschnittAusfahrt
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
				 _messQuerschnittEinfahrt
				;
		
			/**
			Lage des virtuellen Messquerschnitts.
			<p>
			
			</p>
			
			@return der Wert von Lage.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttMessQuerschnittVirtuellLage
				 getLage() {
				return _lage;
			}
		
			/**
			Lage des virtuellen Messquerschnitts.
			<p>
			
			</p>
			
			@param _lage der neue Wert von Lage.
			*/
			public void setLage(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttMessQuerschnittVirtuellLage
			 _lage) {
				this._lage = _lage;
			}
		
			/**
			Messquerschnitt VOR der Anschlussstelle.
			<p>
			
			</p>
			
			@return der Wert von MessQuerschnittVor.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
				 getMessQuerschnittVor() {
				return _messQuerschnittVor;
			}
		
			/**
			Messquerschnitt VOR der Anschlussstelle.
			<p>
			
			</p>
			
			@param _messQuerschnittVor der neue Wert von MessQuerschnittVor.
			*/
			public void setMessQuerschnittVor(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
			 _messQuerschnittVor) {
				this._messQuerschnittVor = _messQuerschnittVor;
			}
		
			/**
			Messquerschnitt MITTE der Anschlussstelle.
			<p>
			
			</p>
			
			@return der Wert von MessQuerschnittMitte.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
				 getMessQuerschnittMitte() {
				return _messQuerschnittMitte;
			}
		
			/**
			Messquerschnitt MITTE der Anschlussstelle.
			<p>
			
			</p>
			
			@param _messQuerschnittMitte der neue Wert von MessQuerschnittMitte.
			*/
			public void setMessQuerschnittMitte(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
			 _messQuerschnittMitte) {
				this._messQuerschnittMitte = _messQuerschnittMitte;
			}
		
			/**
			Messquerschnitt NACH der Anschlussstelle.
			<p>
			
			</p>
			
			@return der Wert von MessQuerschnittNach.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
				 getMessQuerschnittNach() {
				return _messQuerschnittNach;
			}
		
			/**
			Messquerschnitt NACH der Anschlussstelle.
			<p>
			
			</p>
			
			@param _messQuerschnittNach der neue Wert von MessQuerschnittNach.
			*/
			public void setMessQuerschnittNach(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
			 _messQuerschnittNach) {
				this._messQuerschnittNach = _messQuerschnittNach;
			}
		
			/**
			Messquerschnitt AUSFAHRT der Anschlussstelle.
			<p>
			
			</p>
			
			@return der Wert von MessQuerschnittAusfahrt.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
				 getMessQuerschnittAusfahrt() {
				return _messQuerschnittAusfahrt;
			}
		
			/**
			Messquerschnitt AUSFAHRT der Anschlussstelle.
			<p>
			
			</p>
			
			@param _messQuerschnittAusfahrt der neue Wert von MessQuerschnittAusfahrt.
			*/
			public void setMessQuerschnittAusfahrt(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
			 _messQuerschnittAusfahrt) {
				this._messQuerschnittAusfahrt = _messQuerschnittAusfahrt;
			}
		
			/**
			Messquerschnitt EINFAHRT der Anschlussstelle.
			<p>
			
			</p>
			
			@return der Wert von MessQuerschnittEinfahrt.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
				 getMessQuerschnittEinfahrt() {
				return _messQuerschnittEinfahrt;
			}
		
			/**
			Messquerschnitt EINFAHRT der Anschlussstelle.
			<p>
			
			</p>
			
			@param _messQuerschnittEinfahrt der neue Wert von MessQuerschnittEinfahrt.
			*/
			public void setMessQuerschnittEinfahrt(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
			 _messQuerschnittEinfahrt) {
				this._messQuerschnittEinfahrt = _messQuerschnittEinfahrt;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getLage() != null) {
		                if (getLage().isZustand()) {
		                    datum.getUnscaledValue("Lage").setText(getLage().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Lage").set(getLage().getValue());
		                }
					}
					// ObjektReferenzAttributTyp
						final Object soMessQuerschnittVor = getMessQuerschnittVor();
						final SystemObject tmpMessQuerschnittVor;
							if (soMessQuerschnittVor instanceof SystemObject) {
								tmpMessQuerschnittVor = (SystemObject)soMessQuerschnittVor;
							} else if(soMessQuerschnittVor instanceof SystemObjekt){
								tmpMessQuerschnittVor = ((SystemObjekt)soMessQuerschnittVor).getSystemObject();
							} else{
								tmpMessQuerschnittVor = null;
							}
						datum.getReferenceValue("MessQuerschnittVor").setSystemObject(tmpMessQuerschnittVor);
					// ObjektReferenzAttributTyp
						final Object soMessQuerschnittMitte = getMessQuerschnittMitte();
						final SystemObject tmpMessQuerschnittMitte;
							if (soMessQuerschnittMitte instanceof SystemObject) {
								tmpMessQuerschnittMitte = (SystemObject)soMessQuerschnittMitte;
							} else if(soMessQuerschnittMitte instanceof SystemObjekt){
								tmpMessQuerschnittMitte = ((SystemObjekt)soMessQuerschnittMitte).getSystemObject();
							} else{
								tmpMessQuerschnittMitte = null;
							}
						datum.getReferenceValue("MessQuerschnittMitte").setSystemObject(tmpMessQuerschnittMitte);
					// ObjektReferenzAttributTyp
						final Object soMessQuerschnittNach = getMessQuerschnittNach();
						final SystemObject tmpMessQuerschnittNach;
							if (soMessQuerschnittNach instanceof SystemObject) {
								tmpMessQuerschnittNach = (SystemObject)soMessQuerschnittNach;
							} else if(soMessQuerschnittNach instanceof SystemObjekt){
								tmpMessQuerschnittNach = ((SystemObjekt)soMessQuerschnittNach).getSystemObject();
							} else{
								tmpMessQuerschnittNach = null;
							}
						datum.getReferenceValue("MessQuerschnittNach").setSystemObject(tmpMessQuerschnittNach);
					// ObjektReferenzAttributTyp
						final Object soMessQuerschnittAusfahrt = getMessQuerschnittAusfahrt();
						final SystemObject tmpMessQuerschnittAusfahrt;
							if (soMessQuerschnittAusfahrt instanceof SystemObject) {
								tmpMessQuerschnittAusfahrt = (SystemObject)soMessQuerschnittAusfahrt;
							} else if(soMessQuerschnittAusfahrt instanceof SystemObjekt){
								tmpMessQuerschnittAusfahrt = ((SystemObjekt)soMessQuerschnittAusfahrt).getSystemObject();
							} else{
								tmpMessQuerschnittAusfahrt = null;
							}
						datum.getReferenceValue("MessQuerschnittAusfahrt").setSystemObject(tmpMessQuerschnittAusfahrt);
					// ObjektReferenzAttributTyp
						final Object soMessQuerschnittEinfahrt = getMessQuerschnittEinfahrt();
						final SystemObject tmpMessQuerschnittEinfahrt;
							if (soMessQuerschnittEinfahrt instanceof SystemObject) {
								tmpMessQuerschnittEinfahrt = (SystemObject)soMessQuerschnittEinfahrt;
							} else if(soMessQuerschnittEinfahrt instanceof SystemObjekt){
								tmpMessQuerschnittEinfahrt = ((SystemObjekt)soMessQuerschnittEinfahrt).getSystemObject();
							} else{
								tmpMessQuerschnittEinfahrt = null;
							}
						datum.getReferenceValue("MessQuerschnittEinfahrt").setSystemObject(tmpMessQuerschnittEinfahrt);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Lage").isState()) {
								setLage(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttMessQuerschnittVirtuellLage
								.getZustand(daten.getScaledValue("Lage").getText()));
							} else {
							setLage(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttMessQuerschnittVirtuellLage
							(daten.
								getUnscaledValue
							("Lage").
									byteValue
							()));
							}
					// ObjektReferenzAttributTyp
						final long idMessQuerschnittVor = daten.getReferenceValue("MessQuerschnittVor").getId();
						final SystemObjekt tmpMessQuerschnittVor;
						if (idMessQuerschnittVor == 0) {
							tmpMessQuerschnittVor = null;
						} else {
							final SystemObject soMessQuerschnittVor = factory.getDav().getDataModel().getObject(idMessQuerschnittVor);
							if (soMessQuerschnittVor == null) {
									tmpMessQuerschnittVor = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.MessQuerschnittUngueltig(idMessQuerschnittVor);
							} else {
								tmpMessQuerschnittVor = factory.getModellobjekt(soMessQuerschnittVor);
							}
						}
						setMessQuerschnittVor((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
						) tmpMessQuerschnittVor);
					// ObjektReferenzAttributTyp
						final long idMessQuerschnittMitte = daten.getReferenceValue("MessQuerschnittMitte").getId();
						final SystemObjekt tmpMessQuerschnittMitte;
						if (idMessQuerschnittMitte == 0) {
							tmpMessQuerschnittMitte = null;
						} else {
							final SystemObject soMessQuerschnittMitte = factory.getDav().getDataModel().getObject(idMessQuerschnittMitte);
							if (soMessQuerschnittMitte == null) {
									tmpMessQuerschnittMitte = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.MessQuerschnittUngueltig(idMessQuerschnittMitte);
							} else {
								tmpMessQuerschnittMitte = factory.getModellobjekt(soMessQuerschnittMitte);
							}
						}
						setMessQuerschnittMitte((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
						) tmpMessQuerschnittMitte);
					// ObjektReferenzAttributTyp
						final long idMessQuerschnittNach = daten.getReferenceValue("MessQuerschnittNach").getId();
						final SystemObjekt tmpMessQuerschnittNach;
						if (idMessQuerschnittNach == 0) {
							tmpMessQuerschnittNach = null;
						} else {
							final SystemObject soMessQuerschnittNach = factory.getDav().getDataModel().getObject(idMessQuerschnittNach);
							if (soMessQuerschnittNach == null) {
									tmpMessQuerschnittNach = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.MessQuerschnittUngueltig(idMessQuerschnittNach);
							} else {
								tmpMessQuerschnittNach = factory.getModellobjekt(soMessQuerschnittNach);
							}
						}
						setMessQuerschnittNach((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
						) tmpMessQuerschnittNach);
					// ObjektReferenzAttributTyp
						final long idMessQuerschnittAusfahrt = daten.getReferenceValue("MessQuerschnittAusfahrt").getId();
						final SystemObjekt tmpMessQuerschnittAusfahrt;
						if (idMessQuerschnittAusfahrt == 0) {
							tmpMessQuerschnittAusfahrt = null;
						} else {
							final SystemObject soMessQuerschnittAusfahrt = factory.getDav().getDataModel().getObject(idMessQuerschnittAusfahrt);
							if (soMessQuerschnittAusfahrt == null) {
									tmpMessQuerschnittAusfahrt = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.MessQuerschnittUngueltig(idMessQuerschnittAusfahrt);
							} else {
								tmpMessQuerschnittAusfahrt = factory.getModellobjekt(soMessQuerschnittAusfahrt);
							}
						}
						setMessQuerschnittAusfahrt((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
						) tmpMessQuerschnittAusfahrt);
					// ObjektReferenzAttributTyp
						final long idMessQuerschnittEinfahrt = daten.getReferenceValue("MessQuerschnittEinfahrt").getId();
						final SystemObjekt tmpMessQuerschnittEinfahrt;
						if (idMessQuerschnittEinfahrt == 0) {
							tmpMessQuerschnittEinfahrt = null;
						} else {
							final SystemObject soMessQuerschnittEinfahrt = factory.getDav().getDataModel().getObject(idMessQuerschnittEinfahrt);
							if (soMessQuerschnittEinfahrt == null) {
									tmpMessQuerschnittEinfahrt = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.MessQuerschnittUngueltig(idMessQuerschnittEinfahrt);
							} else {
								tmpMessQuerschnittEinfahrt = factory.getModellobjekt(soMessQuerschnittEinfahrt);
							}
						}
						setMessQuerschnittEinfahrt((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
						) tmpMessQuerschnittEinfahrt);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setLage(getLage());
							klon.setMessQuerschnittVor(getMessQuerschnittVor());
							klon.setMessQuerschnittMitte(getMessQuerschnittMitte());
							klon.setMessQuerschnittNach(getMessQuerschnittNach());
							klon.setMessQuerschnittAusfahrt(getMessQuerschnittAusfahrt());
							klon.setMessQuerschnittEinfahrt(getMessQuerschnittEinfahrt());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.messQuerschnittVirtuellStandard";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdMessQuerschnittVirtuellStandard(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
