/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Konfigurierende Eigenschaften der Objekte des Typs.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class KdMessStellenGruppe extends AbstractKonfigurationsDatensatz<KdMessStellenGruppe.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessStelle
				> _messStellen = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessStelle
				>(0, true);
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _systematischeDetektorfehler
				;
		
			/**
			Legt die MessStellen der MessStellenGruppe fest.
									Die Reihenfolge entspricht der Fahrtrichtung.
									Eine MessStellenGruppe besteht aus mindestens 2
									MessStellen.
			<p>
			
			</p>
			
			@return der Wert von MessStellen.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessStelle
				> getMessStellen() {
				return _messStellen;
			}
		
		
			/**
			Legt fest, ob die Ermittlung systematischer
									Detektorfehler für diese MessStellenGruppe
									durchgeführt werden soll.
			<p>
			
			</p>
			
			@return der Wert von SystematischeDetektorfehler.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getSystematischeDetektorfehler() {
				return _systematischeDetektorfehler;
			}
		
			/**
			Legt fest, ob die Ermittlung systematischer
									Detektorfehler für diese MessStellenGruppe
									durchgeführt werden soll.
			<p>
			
			</p>
			
			@param _systematischeDetektorfehler der neue Wert von SystematischeDetektorfehler.
			*/
			public void setSystematischeDetektorfehler(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _systematischeDetektorfehler) {
				this._systematischeDetektorfehler = _systematischeDetektorfehler;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayMessStellen = datum.getReferenceArray("MessStellen");
						arrayMessStellen.setLength(getMessStellen().size());
						for (int i = 0; i < arrayMessStellen.getLength(); ++i) {
							final Object soMessStellen = getMessStellen().get(i);
							final SystemObject tmpMessStellen;
							if (soMessStellen instanceof SystemObject) {
								tmpMessStellen = (SystemObject)soMessStellen;
							} else if(soMessStellen instanceof SystemObjekt){
								tmpMessStellen = ((SystemObjekt)soMessStellen).getSystemObject();
							} else{
								tmpMessStellen = null;
							}
							arrayMessStellen.getReferenceValue(i).setSystemObject(tmpMessStellen);
						}
					// GanzzahlAttributTyp
					if (getSystematischeDetektorfehler() != null) {
		                if (getSystematischeDetektorfehler().isZustand()) {
		                    datum.getUnscaledValue("SystematischeDetektorfehler").setText(getSystematischeDetektorfehler().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("SystematischeDetektorfehler").set(getSystematischeDetektorfehler().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayMessStellen = daten.getReferenceArray("MessStellen");
						for (int i = 0; i < arrayMessStellen.getLength(); ++i) {
							final long idMessStellen = daten.getReferenceArray("MessStellen").getReferenceValue(i).getId();
							final SystemObjekt tmpMessStellen;
							if (idMessStellen == 0) {
								tmpMessStellen = null;
							} else {
								final SystemObject soMessStellen = factory.getDav().getDataModel().getObject(idMessStellen);
								if (soMessStellen == null) {
										tmpMessStellen = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.MessStelleUngueltig(idMessStellen);
								} else {
									tmpMessStellen = factory.getModellobjekt(soMessStellen);
								}
							}
								getMessStellen().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessStelle
								) tmpMessStellen);
						}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("SystematischeDetektorfehler").isState()) {
								setSystematischeDetektorfehler(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("SystematischeDetektorfehler").getText()));
							} else {
							setSystematischeDetektorfehler(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("SystematischeDetektorfehler").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
						klon._messStellen = getMessStellen().clone();
							klon.setSystematischeDetektorfehler(getSystematischeDetektorfehler());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.messStellenGruppe";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdMessStellenGruppe(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
