/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Konfigurierende Eigenschaften der Objekte des Typs.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class KdStrassenAbschnitt extends AbstractKonfigurationsDatensatz<KdStrassenAbschnitt.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
				 _vonMessQuerschnitt
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
				 _bisMessQuerschnitt
				;
		
			/**
			Einfahrquerschnitt dieses Straßenabschnittes.
			<p>
			
			</p>
			
			@return der Wert von VonMessQuerschnitt.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
				 getVonMessQuerschnitt() {
				return _vonMessQuerschnitt;
			}
		
			/**
			Einfahrquerschnitt dieses Straßenabschnittes.
			<p>
			
			</p>
			
			@param _vonMessQuerschnitt der neue Wert von VonMessQuerschnitt.
			*/
			public void setVonMessQuerschnitt(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
			 _vonMessQuerschnitt) {
				this._vonMessQuerschnitt = _vonMessQuerschnitt;
			}
		
			/**
			Ausfahrquerschnitt dieses Straßenabschnittes.
			<p>
			
			</p>
			
			@return der Wert von BisMessQuerschnitt.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
				 getBisMessQuerschnitt() {
				return _bisMessQuerschnitt;
			}
		
			/**
			Ausfahrquerschnitt dieses Straßenabschnittes.
			<p>
			
			</p>
			
			@param _bisMessQuerschnitt der neue Wert von BisMessQuerschnitt.
			*/
			public void setBisMessQuerschnitt(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
			 _bisMessQuerschnitt) {
				this._bisMessQuerschnitt = _bisMessQuerschnitt;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Object soVonMessQuerschnitt = getVonMessQuerschnitt();
						final SystemObject tmpVonMessQuerschnitt;
							if (soVonMessQuerschnitt instanceof SystemObject) {
								tmpVonMessQuerschnitt = (SystemObject)soVonMessQuerschnitt;
							} else if(soVonMessQuerschnitt instanceof SystemObjekt){
								tmpVonMessQuerschnitt = ((SystemObjekt)soVonMessQuerschnitt).getSystemObject();
							} else{
								tmpVonMessQuerschnitt = null;
							}
						datum.getReferenceValue("vonMessQuerschnitt").setSystemObject(tmpVonMessQuerschnitt);
					// ObjektReferenzAttributTyp
						final Object soBisMessQuerschnitt = getBisMessQuerschnitt();
						final SystemObject tmpBisMessQuerschnitt;
							if (soBisMessQuerschnitt instanceof SystemObject) {
								tmpBisMessQuerschnitt = (SystemObject)soBisMessQuerschnitt;
							} else if(soBisMessQuerschnitt instanceof SystemObjekt){
								tmpBisMessQuerschnitt = ((SystemObjekt)soBisMessQuerschnitt).getSystemObject();
							} else{
								tmpBisMessQuerschnitt = null;
							}
						datum.getReferenceValue("bisMessQuerschnitt").setSystemObject(tmpBisMessQuerschnitt);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final long idVonMessQuerschnitt = daten.getReferenceValue("vonMessQuerschnitt").getId();
						final SystemObjekt tmpVonMessQuerschnitt;
						if (idVonMessQuerschnitt == 0) {
							tmpVonMessQuerschnitt = null;
						} else {
							final SystemObject soVonMessQuerschnitt = factory.getDav().getDataModel().getObject(idVonMessQuerschnitt);
							if (soVonMessQuerschnitt == null) {
									tmpVonMessQuerschnitt = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.MessQuerschnittAllgemeinUngueltig(idVonMessQuerschnitt);
							} else {
								tmpVonMessQuerschnitt = factory.getModellobjekt(soVonMessQuerschnitt);
							}
						}
						setVonMessQuerschnitt((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
						) tmpVonMessQuerschnitt);
					// ObjektReferenzAttributTyp
						final long idBisMessQuerschnitt = daten.getReferenceValue("bisMessQuerschnitt").getId();
						final SystemObjekt tmpBisMessQuerschnitt;
						if (idBisMessQuerschnitt == 0) {
							tmpBisMessQuerschnitt = null;
						} else {
							final SystemObject soBisMessQuerschnitt = factory.getDav().getDataModel().getObject(idBisMessQuerschnitt);
							if (soBisMessQuerschnitt == null) {
									tmpBisMessQuerschnitt = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.MessQuerschnittAllgemeinUngueltig(idBisMessQuerschnitt);
							} else {
								tmpBisMessQuerschnitt = factory.getModellobjekt(soBisMessQuerschnitt);
							}
						}
						setBisMessQuerschnitt((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein
						) tmpBisMessQuerschnitt);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setVonMessQuerschnitt(getVonMessQuerschnitt());
							klon.setBisMessQuerschnitt(getBisMessQuerschnitt());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.straßenAbschnitt";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdStrassenAbschnitt(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
