/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Eine Messstelle fasst jeweils einen Messquerschnitt
					auf dem betrachteten Streckenabschnitt (der
					eigentliche Prüfling) und die Menge der Zu- und
					Abfahrten hinter dem Prüfling bis zum nächsten
					Prüfling zusammen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface MessStelle extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.messStelle"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	
/**
MessQuerschnitte der Zufahrten einer MessStelle.
<p>

</p>

@return die Menge Zufahrten oder <code>null</code>, wenn eine optionale Menge nicht versorgt ist.
*/
	Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein> getZufahrten();

/**
MessQuerschnitte der Abfahrten einer MessStelle.
<p>

</p>

@return die Menge Abfahrten oder <code>null</code>, wenn eine optionale Menge nicht versorgt ist.
*/
	Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein> getAbfahrten();


	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Bilanzverkehrsdaten für die Langzeitfehlererkennung
						von Verkehrsdaten.
	<p>
	
	</p>
	@return der Datensatz BilanzVerkehrsStaerke.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdBilanzVerkehrsStaerke getOdBilanzVerkehrsStaerke();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Abweichungen der Verkehrsdaten für die
						Langzeitfehlererkennung von Verkehrsdaten.
	<p>
	
	</p>
	@return der Datensatz AbweichungVerkehrsStaerke.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdAbweichungVerkehrsStaerke getOdAbweichungVerkehrsStaerke();
	
	/**
	Intervallverkehrsdaten für die
						Langzeitfehlererkennung von Verkehrsdaten.
	<p>
	
	</p>
	@return der Datensatz IntervallVerkehrsStaerke.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdIntervallVerkehrsStaerke getOdIntervallVerkehrsStaerke();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz MessStelle.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdMessStelle getKdMessStelle();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
