/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Unterteilung eines Straßensegments bei Änderung der
					verkehrlichen Eigenschaften.
<p>
&lt;absatz&gt;
						Richtlinie für die Vergabe der Pid und des
						Namens: 'sts.nr.bundesland' mit
					&lt;&#47;absatz&gt;
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;
							'sts': Abkürzung für StraßenTeilSegment.
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							'nr': Laufende Nummer des
							StraßenTeilSegments eines StraßenSegments
							(Äußeres- oder InneresStraßenSegment),
							siebenstellig mit führenden Nullen.
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							'bundesland': Kürzel des Bundeslandes (zwei
							Zeichen): BB Brandenburg, BE Berlin, BW
							Baden-Württemberg, BY Bayern, HB Bremen, HE
							Hessen, HH Hamburg, MV
							Mecklenburg-Vorpommern, NI Niedersachsen, NW
							Nordrhein-Westfalen, RP Rheinland-Pfalz, SH
							Schleswig-Holstein, SL Saarland, SN Sachsen,
							ST Sachsen-Anhalt, TH Thüringen.
						&lt;&#47;listenPunkt&gt;
					&lt;&#47;liste&gt;
					&lt;absatz&gt;
						Beispiele für gültige PID&#47;Namen eines
						StraßenTeilSegments:
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;sts.0000001.BW&lt;&#47;absatz&gt;
					&lt;absatz&gt;sts.1234567.NW&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface StrassenTeilSegment extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StoerfallIndikator,de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.LinieXY
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.straßenTeilSegment"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Ausgewähltes Fundamentaldiagramm pro
						StraßenTeilSegment.
	<p>
	
	</p>
	@return der Datensatz NbaFundamentaldiagrammAuswahl.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdNbaFundamentaldiagrammAuswahl getPdNbaFundamentaldiagrammAuswahl();
	
	/**
	Parameter eines Fundamentaldiagramms.
	<p>
	
	</p>
	@return der Datensatz FundamentalDiagramm.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdFundamentalDiagramm getPdFundamentalDiagramm();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Zustand plus Verkehrsinformationen für einen
						Streckenabschnitt.
	<p>
	&lt;absatz&gt;
							Objekte dieses Typs beschreiben den
							Verkehrszustand auf Streckenabschnitten durch
							die Größen:
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;
								Referenzzeit (Zeitpunkt der verwendeten
								Daten)
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Prognosehorizont&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Verkehrssituation (Level of Service)
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Fahrzeitprognose für alle Kfz
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Fahrzeitprognose für alle Pkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Fahrzeitprognose für alle Lkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlere Geschwindigkeit Kfz
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlere Geschwindigkeit Pkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlere Geschwindigkeit Lkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlerer Fluss aller Kfz
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlerer Fluss aller Pkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlerer Fluss aller Lkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlere Dichte aller Kfz
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlere Dichte aller Pkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								mittlere Dichte aller Lkw
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								Güteindex für den Störfall-Verkehrszustand
							&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
	</p>
	@return der Datensatz StoerfallVerkehrsZustand.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallVerkehrsZustand getOdStoerfallVerkehrsZustand();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	ASB-Stationierungssystems: Die Kreuzungen
						(Netzknoten) des klassifizierten Straßennetzes
						erhalten innerhalb eines Kartenblattes einer
						Topographischen Karte eine eindeutige Nummer. Die
						Beschreibung eines Straßenabschnitts ergibt sich nun
						aus der Nennung von Anfangsknoten und Endknoten.
						Diesem Straßenabschnitt wird die reale Länge (Keine
						Berechnung aufgrund von Koordinaten!) zugewiesen.
						Innerhalb eines Netzknotens können Äste definiert
						werden. Diese Äste starten und Enden an so genannten
						Nullpunkten, die im Bezug zum Netzknoten eindeutig
						indiziert sind. Den Ästen wird ebenfalls die reale
						Länge zugewiesen. Die Lagebeschreibung von Punkte
						entlang eines Abschnitts oder eines Astes kann man
						nun eindeutig durch den Anfangs- und Endpunkt
						(Netzknoten bzw. Nullpunkt) sowie der Stationierung
						im Wertebereich von 0 bis zugewiesene Länge sowie
						der Richtung erfolgen. Bei dem Übergang auf die
						Darstellung von Verkehrsbeziehungen werden die
						Nullpunkte zu Verbindungspunkte. Zwischen den
						Verbindungspunkten sind Straßenelemente definiert.
						Dabei besitzen die Straßenelemente nach Definition
						ASB eine Referenz auf das oben beschriebene ASB
						Stationierungssystem. Durch diese Referenzierung der
						Straßenelemente auf die Straßenabschnitte lassen
						sich alle Informationen von Abschnitten und Ästen
						über das Stationierungssystem auf die
						Straßenelemente übertragen. Eine StraßenTeilSegment
						kann dabei aus mehreren Straßenelementen bestehen.
	</p>
	@return der Datensatz AsbStationierung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdAsbStationierung getKdAsbStationierung();
	
	/**
	Prognose der Stauentwicklung pro StraßenTeilSegment.
	<p>
	
	</p>
	@return der Datensatz NbaDatenStauPrognose.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdNbaDatenStauPrognose getOdNbaDatenStauPrognose();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz BetriebsKilometer.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdBetriebsKilometer getKdBetriebsKilometer();
	
	/**
	Fuzzy-Set (Parameter) für Verkehrsstärke
						(Stundenwerte).
	<p>
	
	</p>
	@return der Datensatz VerkehrsStaerkeStundeFuzzy.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsStaerkeStundeFuzzy getPdVerkehrsStaerkeStundeFuzzy();
	
	/**
	Ergebnisdaten Kapazitätsermittlung. Festellung der
						verkehrstechnischen Leistungsfähigkeit pro
						StraßenTeilSegment.
	<p>
	
	</p>
	@return der Datensatz NbaDatenKapazitaetsermittlung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdNbaDatenKapazitaetsermittlung getOdNbaDatenKapazitaetsermittlung();
	
	/**
	Fuzzy-Regelbasis.
	<p>
	
	</p>
	@return der Datensatz FuzzyRegelbasis.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdFuzzyRegelbasis getPdFuzzyRegelbasis();
	
	/**
	Fuzzy-Set (Parameter) für Geschwindigkeit.
	<p>
	
	</p>
	@return der Datensatz VerkehrGeschwindigkeitFuzzy.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrGeschwindigkeitFuzzy getPdVerkehrGeschwindigkeitFuzzy();
	
	/**
	Fuzzy-Set (Parameter) für Verkehrszustand im
						Verkehr.
	<p>
	
	</p>
	@return der Datensatz VerkehrsZustandFuzzy.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsZustandFuzzy getPdVerkehrsZustandFuzzy();
	
	/**
	Unruhe im Verkehr als lingustischer Term.
	<p>
	
	</p>
	@return der Datensatz VerkehrsUnruhe.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsUnruhe getOdVerkehrsUnruhe();
	
	/**
	Fuzzy-Set (Parameter) für BemessungsDichte .
	<p>
	
	</p>
	@return der Datensatz BemessungsDichteFuzzy.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdBemessungsDichteFuzzy getPdBemessungsDichteFuzzy();
	
	/**
	Ergebnisdaten Verkehrszustandsanalyse pro
						StraßenTeilSegment.
	<p>
	
	</p>
	@return der Datensatz NbaDatenVerkehrszustand.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdNbaDatenVerkehrszustand getOdNbaDatenVerkehrszustand();
	
	/**
	Fuzzy-Set (Parameter) für den Lkw-Anteil.
	<p>
	
	</p>
	@return der Datensatz AnteilLkwFuzzy.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdAnteilLkwFuzzy getPdAnteilLkwFuzzy();
	
	/**
	Geschwindigkeit als linguistischer Term.
	<p>
	
	</p>
	@return der Datensatz VerkehrGeschwindigkeit.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrGeschwindigkeit getOdVerkehrGeschwindigkeit();
	
	/**
	Enthält die FCD-Daten für ein StraßenTeilSegment, ggf. aufgeteilt in mehrere Teilabschnitte.
	<p>
	
	</p>
	@return der Datensatz FcdStrassenTeilSegmentDaten.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdFcdStrassenTeilSegmentDaten getOdFcdStrassenTeilSegmentDaten();
	
	/**
	Verkehrzustand bezogen auf Unruhe im Verkehr als
						linguistischer Term.
	<p>
	
	</p>
	@return der Datensatz VerkehrsZustandUnruhe.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsZustandUnruhe getOdVerkehrsZustandUnruhe();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	BemessungsDichte als linguistischer Term.
	<p>
	
	</p>
	@return der Datensatz BemessungsDichte.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdBemessungsDichte getOdBemessungsDichte();
	
	/**
	Verkehrzustand als linguistischer Term.
	<p>
	
	</p>
	@return der Datensatz VerkehrsZustand.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsZustand getOdVerkehrsZustand();
	
	/**
	Verkehrsstärke als linguistischer Term
						(Stundenwerte).
	<p>
	
	</p>
	@return der Datensatz VerkehrsStaerkeStunde.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsStaerkeStunde getOdVerkehrsStaerkeStunde();
	
	/**
	Liste mit den Angaben zur Längsneigung.
	<p>
	
	</p>
	@return der Datensatz LaengsNeigungListe.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdLaengsNeigungListe getKdLaengsNeigungListe();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz StrassenTeilSegment.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStrassenTeilSegment getKdStrassenTeilSegment();
	
	/**
	Lkw-Anteil als lingustischer Term.
	<p>
	
	</p>
	@return der Datensatz AnteilLkw.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdAnteilLkw getOdAnteilLkw();
	
	/**
	Fuzzy-Set (Parameter) für Verkehrzustand bezogen auf
						Unruhe im Verkehr.
	<p>
	
	</p>
	@return der Datensatz VerkehrsZustandUnruheFuzzy.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsZustandUnruheFuzzy getPdVerkehrsZustandUnruheFuzzy();
	
	/**
	Zustand eines Störfallindikators.
	<p>
	
	</p>
	@return der Datensatz StoerfallZustand.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallZustand getOdStoerfallZustand();
	
	/**
	Liste mit den Angaben zur statischen Beschilderung.
	<p>
	
	</p>
	@return der Datensatz StatischeBeschilderungVerkehrListe.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStatischeBeschilderungVerkehrListe getKdStatischeBeschilderungVerkehrListe();
	
	/**
	Verkehrszustandsprognose pro StraßenTeilSegment.
	<p>
	
	</p>
	@return der Datensatz NbaPrognoseGanglinie.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdNbaPrognoseGanglinie getPdNbaPrognoseGanglinie();
	
	/**
	Liste mit den Angaben zu den Betriebskilometern der jeweils betroffenen Straße.
	<p>
	
	</p>
	@return der Datensatz BetriebsKilometerListe.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdBetriebsKilometerListe getKdBetriebsKilometerListe();
	
	/**
	Fuzzy-Set (Parameter) für Unruhe im Verkehr.
	<p>
	
	</p>
	@return der Datensatz VerkehrsUnruheFuzzy.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsUnruheFuzzy getPdVerkehrsUnruheFuzzy();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz StrassenTeilSegmentVerkehr.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStrassenTeilSegmentVerkehr getKdStrassenTeilSegmentVerkehr();
	
	/**
	Ausgewählte Standardganglinie pro StraßenTeilSegment.
	<p>
	
	</p>
	@return der Datensatz NbaGanglinienAuswahl.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdNbaGanglinienAuswahl getPdNbaGanglinienAuswahl();
	
	/**
	Koordinaten einer Linie in Grad entsprechend WGS84.
	<p>
	
	</p>
	@return der Datensatz LinienKoordinaten.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdLinienKoordinaten getKdLinienKoordinaten();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz Linie.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdLinie getKdLinie();
	
	/**
	Lokale Parameter für die Constrainberechnung auf
						(Sub)Segmenten.
	<p>
	
	</p>
	@return der Datensatz Constraint.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdConstraint getPdConstraint();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
