/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Unterteilung eines Straßensegments bei Änderung der
					verkehrlichen Eigenschaften.
<p>
&lt;absatz&gt;
						Richtlinie für die Vergabe der Pid und des
						Namens: 'sts.nr.bundesland' mit
					&lt;&#47;absatz&gt;
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;
							'sts': Abkürzung für StraßenTeilSegment.
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							'nr': Laufende Nummer des
							StraßenTeilSegments eines StraßenSegments
							(Äußeres- oder InneresStraßenSegment),
							siebenstellig mit führenden Nullen.
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							'bundesland': Kürzel des Bundeslandes (zwei
							Zeichen): BB Brandenburg, BE Berlin, BW
							Baden-Württemberg, BY Bayern, HB Bremen, HE
							Hessen, HH Hamburg, MV
							Mecklenburg-Vorpommern, NI Niedersachsen, NW
							Nordrhein-Westfalen, RP Rheinland-Pfalz, SH
							Schleswig-Holstein, SL Saarland, SN Sachsen,
							ST Sachsen-Anhalt, TH Thüringen.
						&lt;&#47;listenPunkt&gt;
					&lt;&#47;liste&gt;
					&lt;absatz&gt;
						Beispiele für gültige PID&#47;Namen eines
						StraßenTeilSegments:
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;sts.0000001.BW&lt;&#47;absatz&gt;
					&lt;absatz&gt;sts.1234567.NW&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class StrassenTeilSegmentImpl extends AbstractSystemObjekt
	implements de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenTeilSegment { 

	/**
	 * Der Defaultkonstruktor wird für das Erzeugen des Systemobjekts über per
	 * Reflection-API benötigt.
	 */
	public StrassenTeilSegmentImpl() {
		// tut nix
	}
	
	/**
	 * Initialisierung.
	 * 
	 * @param objekt
	 *            ein beliebiges Systemobjekt.
	 * @param factory
	 *            die Fabrik, die das Systemobjekt angelegt hat.
	 */
	public StrassenTeilSegmentImpl(final SystemObject objekt, final ObjektFactory factory) {
		super(objekt, factory);
		
		if (!objekt.isOfType(getTyp().getPid())) {
			throw new IllegalArgumentException(
					"Systemobjekt ist kein StraßenTeilSegment.");
		}
	}
	
	@Override
	protected String doGetTypPid() {
		return PID;
	}
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdNbaFundamentaldiagrammAuswahl getPdNbaFundamentaldiagrammAuswahl() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdNbaFundamentaldiagrammAuswahl.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdFundamentalDiagramm getPdFundamentalDiagramm() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdFundamentalDiagramm.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallVerkehrsZustand getOdStoerfallVerkehrsZustand() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallVerkehrsZustand.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdAsbStationierung getKdAsbStationierung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdAsbStationierung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdNbaDatenStauPrognose getOdNbaDatenStauPrognose() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdNbaDatenStauPrognose.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdBetriebsKilometer getKdBetriebsKilometer() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdBetriebsKilometer.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsStaerkeStundeFuzzy getPdVerkehrsStaerkeStundeFuzzy() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsStaerkeStundeFuzzy.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdNbaDatenKapazitaetsermittlung getOdNbaDatenKapazitaetsermittlung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdNbaDatenKapazitaetsermittlung.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdFuzzyRegelbasis getPdFuzzyRegelbasis() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdFuzzyRegelbasis.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrGeschwindigkeitFuzzy getPdVerkehrGeschwindigkeitFuzzy() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrGeschwindigkeitFuzzy.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsZustandFuzzy getPdVerkehrsZustandFuzzy() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsZustandFuzzy.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsUnruhe getOdVerkehrsUnruhe() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsUnruhe.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdBemessungsDichteFuzzy getPdBemessungsDichteFuzzy() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdBemessungsDichteFuzzy.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdNbaDatenVerkehrszustand getOdNbaDatenVerkehrszustand() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdNbaDatenVerkehrszustand.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdAnteilLkwFuzzy getPdAnteilLkwFuzzy() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdAnteilLkwFuzzy.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrGeschwindigkeit getOdVerkehrGeschwindigkeit() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrGeschwindigkeit.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdFcdStrassenTeilSegmentDaten getOdFcdStrassenTeilSegmentDaten() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdFcdStrassenTeilSegmentDaten.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsZustandUnruhe getOdVerkehrsZustandUnruhe() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsZustandUnruhe.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdBemessungsDichte getOdBemessungsDichte() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdBemessungsDichte.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsZustand getOdVerkehrsZustand() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsZustand.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsStaerkeStunde getOdVerkehrsStaerkeStunde() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsStaerkeStunde.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdLaengsNeigungListe getKdLaengsNeigungListe() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdLaengsNeigungListe.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStrassenTeilSegment getKdStrassenTeilSegment() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStrassenTeilSegment.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdAnteilLkw getOdAnteilLkw() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdAnteilLkw.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsZustandUnruheFuzzy getPdVerkehrsZustandUnruheFuzzy() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsZustandUnruheFuzzy.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallZustand getOdStoerfallZustand() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallZustand.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStatischeBeschilderungVerkehrListe getKdStatischeBeschilderungVerkehrListe() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStatischeBeschilderungVerkehrListe.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdNbaPrognoseGanglinie getPdNbaPrognoseGanglinie() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdNbaPrognoseGanglinie.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdBetriebsKilometerListe getKdBetriebsKilometerListe() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdBetriebsKilometerListe.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsUnruheFuzzy getPdVerkehrsUnruheFuzzy() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdVerkehrsUnruheFuzzy.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStrassenTeilSegmentVerkehr getKdStrassenTeilSegmentVerkehr() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStrassenTeilSegmentVerkehr.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdNbaGanglinienAuswahl getPdNbaGanglinienAuswahl() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdNbaGanglinienAuswahl.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdLinienKoordinaten getKdLinienKoordinaten() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdLinienKoordinaten.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdLinie getKdLinie() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdLinie.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdConstraint getPdConstraint() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdConstraint.class);
	}
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	
	// Sonderfall Klasse AttributImpl
	 

}
