/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zusammenfassung von Netzen zu einem für die
					Verkehrsmodelle relevanten Netz.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class VerkehrsModellNetzImpl extends AbstractSystemObjekt
	implements de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.VerkehrsModellNetz { 

	/**
	 * Der Defaultkonstruktor wird für das Erzeugen des Systemobjekts über per
	 * Reflection-API benötigt.
	 */
	public VerkehrsModellNetzImpl() {
		// tut nix
	}
	
	/**
	 * Initialisierung.
	 * 
	 * @param objekt
	 *            ein beliebiges Systemobjekt.
	 * @param factory
	 *            die Fabrik, die das Systemobjekt angelegt hat.
	 */
	public VerkehrsModellNetzImpl(final SystemObject objekt, final ObjektFactory factory) {
		super(objekt, factory);
		
		if (!objekt.isOfType(getTyp().getPid())) {
			throw new IllegalArgumentException(
					"Systemobjekt ist kein VerkehrsModellNetz.");
		}
	}
	
	@Override
	protected String doGetTypPid() {
		return PID;
	}
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	
	private AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.FcdStau> fcdStaus;
	
	public AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.FcdStau> getFcdStaus() {
		if (fcdStaus == null) {
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("FcdStaus") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			fcdStaus = new AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.FcdStau>(getObjektFactory(), (MutableSet)ko.getObjectSet("FcdStaus"), 0, 0, this);
		}
		return fcdStaus;
	}
	private AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.SeitenStreifenFreigabe> seitenStreifenFreigaben;
	
	public AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.SeitenStreifenFreigabe> getSeitenStreifenFreigaben() {
		if (seitenStreifenFreigaben == null) {
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("SeitenStreifenFreigaben") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			seitenStreifenFreigaben = new AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.SeitenStreifenFreigabe>(getObjektFactory(), (MutableSet)ko.getObjectSet("SeitenStreifenFreigaben"), 0, 0, this);
		}
		return seitenStreifenFreigaben;
	}
	private AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Aktion> aktionen;
	
	public AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Aktion> getAktionen() {
		if (aktionen == null) {
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("Aktionen") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			aktionen = new AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Aktion>(getObjektFactory(), (MutableSet)ko.getObjectSet("Aktionen"), 0, 0, this);
		}
		return aktionen;
	}
	private AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Situation> situationen;
	
	public AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Situation> getSituationen() {
		if (situationen == null) {
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("Situationen") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			situationen = new AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Situation>(getObjektFactory(), (MutableSet)ko.getObjectSet("Situationen"), 0, 0, this);
		}
		return situationen;
	}
	private AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Baustelle> baustellen;
	
	public AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Baustelle> getBaustellen() {
		if (baustellen == null) {
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("Baustellen") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			baustellen = new AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Baustelle>(getObjektFactory(), (MutableSet)ko.getObjectSet("Baustellen"), 0, 0, this);
		}
		return baustellen;
	}
	private AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Stau> staus;
	
	public AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Stau> getStaus() {
		if (staus == null) {
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("Staus") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			staus = new AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Stau>(getObjektFactory(), (MutableSet)ko.getObjectSet("Staus"), 0, 0, this);
		}
		return staus;
	}
	private Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.NetzBestandTeil> netzBestandTeile;
	
	public Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.NetzBestandTeil> getNetzBestandTeile() {
		if (netzBestandTeile == null) {
			final Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.NetzBestandTeil> menge = new ArrayList<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.NetzBestandTeil>();
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("NetzBestandTeile") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			for (SystemObject so : ko.getObjectSet("NetzBestandTeile").getElements()) {
				menge.add((de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.NetzBestandTeil) getObjektFactory().getModellobjekt(so));
			}
			netzBestandTeile = Collections.unmodifiableCollection(menge);
		}
		return netzBestandTeile;
	}
	private AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Unfall> unfaelle;
	
	public AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Unfall> getUnfaelle() {
		if (unfaelle == null) {
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("Unfälle") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			unfaelle = new AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Unfall>(getObjektFactory(), (MutableSet)ko.getObjectSet("Unfälle"), 0, 0, this);
		}
		return unfaelle;
	}

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdBaustellenSimulationModell getPdBaustellenSimulationModell() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdBaustellenSimulationModell.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallVerkehrsZustand getOdStoerfallVerkehrsZustand() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallVerkehrsZustand.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallZustand getOdStoerfallZustand() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdStoerfallZustand.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdStauPrognoseModell getPdStauPrognoseModell() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdStauPrognoseModell.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdStauBestimmungModell getPdStauBestimmungModell() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdStauBestimmungModell.class);
	}
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	
	// Sonderfall Klasse AttributImpl
	 

}
