/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ermöglicht die umgehende Neuberechnung der
					Baustellenprogrnose (z. B. in der Entwurfsphase
					einer Baustelle).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 56
 */
public class OdBaustellenSimulationStartenMitMq extends AbstractOnlineDatensatz<OdBaustellenSimulationStartenMitMq.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Senden,
				};
			}
	
			/**
			 * Zu sendende Daten.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Senden = new Aspekte("Senden", "asp.senden");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private String
				 _name
				= new String
				()
				;
				private String
				 _bemerkung
				= new String
				()
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
				 _berechnungsMQ
				;
		
			/**
			Name des Verantwortlichen, der Neuberechnung
									ausgelöst hat.
			<p>
			
			</p>
			
			@return der Wert von Name.
			*/
				public String
				 getName() {
				return _name;
			}
		
			/**
			Name des Verantwortlichen, der Neuberechnung
									ausgelöst hat.
			<p>
			
			</p>
			
			@param _name der neue Wert von Name.
			*/
			public void setName(String
			 _name) {
				if (_name.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._name = _name;
			}
		
			/**
			Bemerkung, warum Baustellensimulation
									durchgeführt wurde.
			<p>
			
			</p>
			
			@return der Wert von Bemerkung.
			*/
				public String
				 getBemerkung() {
				return _bemerkung;
			}
		
			/**
			Bemerkung, warum Baustellensimulation
									durchgeführt wurde.
			<p>
			
			</p>
			
			@param _bemerkung der neue Wert von Bemerkung.
			*/
			public void setBemerkung(String
			 _bemerkung) {
				if (_bemerkung.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._bemerkung = _bemerkung;
			}
		
			/**
			Referenz auf den MQ, der zur Berechnung des Simulation benutzt werden soll.
			<p>
			
			</p>
			
			@return der Wert von BerechnungsMQ.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
				 getBerechnungsMQ() {
				return _berechnungsMQ;
			}
		
			/**
			Referenz auf den MQ, der zur Berechnung des Simulation benutzt werden soll.
			<p>
			
			</p>
			
			@param _berechnungsMQ der neue Wert von BerechnungsMQ.
			*/
			public void setBerechnungsMQ(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
			 _berechnungsMQ) {
				this._berechnungsMQ = _berechnungsMQ;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getName() != null) {
						datum.getTextValue("Name").setText(getName());
					}
					// ZeichenkettenAttributTyp
					if (getBemerkung() != null) {
						datum.getTextValue("Bemerkung").setText(getBemerkung());
					}
					// ObjektReferenzAttributTyp
						final Object soBerechnungsMQ = getBerechnungsMQ();
						final SystemObject tmpBerechnungsMQ;
							if (soBerechnungsMQ instanceof SystemObject) {
								tmpBerechnungsMQ = (SystemObject)soBerechnungsMQ;
							} else if(soBerechnungsMQ instanceof SystemObjekt){
								tmpBerechnungsMQ = ((SystemObjekt)soBerechnungsMQ).getSystemObject();
							} else{
								tmpBerechnungsMQ = null;
							}
						datum.getReferenceValue("BerechnungsMQ").setSystemObject(tmpBerechnungsMQ);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						setName(daten.getTextValue("Name").getText());
					// ZeichenkettenAttributTyp
						setBemerkung(daten.getTextValue("Bemerkung").getText());
					// ObjektReferenzAttributTyp
						final long idBerechnungsMQ = daten.getReferenceValue("BerechnungsMQ").getId();
						final SystemObjekt tmpBerechnungsMQ;
						if (idBerechnungsMQ == 0) {
							tmpBerechnungsMQ = null;
						} else {
							final SystemObject soBerechnungsMQ = factory.getDav().getDataModel().getObject(idBerechnungsMQ);
							if (soBerechnungsMQ == null) {
									tmpBerechnungsMQ = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.MessQuerschnittUngueltig(idBerechnungsMQ);
							} else {
								tmpBerechnungsMQ = factory.getModellobjekt(soBerechnungsMQ);
							}
						}
						setBerechnungsMQ((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt
						) tmpBerechnungsMQ);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setName(getName());
							klon.setBemerkung(getBemerkung());
							klon.setBerechnungsMQ(getBerechnungsMQ());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.baustellenSimulationStartenMitMq";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdBaustellenSimulationStartenMitMq(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
