/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Prognose der Stauentwicklung pro StraßenTeilSegment.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 19
 */
public class OdNbaDatenStauPrognose extends AbstractOnlineDatensatz<OdNbaDatenStauPrognose.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Analyse,
					Aspekte.PrognoseNormal,
					Aspekte.PrognoseStauLaengeNull,
				};
			}
	
			/**
			 * Analysewerte.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Analyse = new Aspekte("Analyse", "asp.analyse");
			
			/**
			 * Prognosewertberechnung mit normaler"Dämpfung", d.h.
						den Analysewerten normal" folgend.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt PrognoseNormal = new Aspekte("PrognoseNormal", "asp.prognoseNormal");
			
			/**
			 * Publizieren der Prognoseberechnung mit Staulänge 0.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt PrognoseStauLaengeNull = new Aspekte("PrognoseStauLängeNull", "asp.prognoseStauLängeNull");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlNbaDatenStauPrognose
				> _prognose = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlNbaDatenStauPrognose
				>(0, true);
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
				 _n
				;
				private 	RelativerZeitstempel
				 _verlustzeit
				;
		
			/**
			Ergebnisse der Stauprognose über den gesamten
									Prognosezeitraum.
			<p>
			
			</p>
			
			@return der Wert von Prognose.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlNbaDatenStauPrognose
				> getPrognose() {
				return _prognose;
			}
		
		
			/**
			Anzahl der Fahrzeuge im Stau.
			<p>
			
			</p>
			
			@return der Wert von N.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
				 getN() {
				return _n;
			}
		
			/**
			Anzahl der Fahrzeuge im Stau.
			<p>
			
			</p>
			
			@param _n der neue Wert von N.
			*/
			public void setN(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
			 _n) {
				this._n = _n;
			}
		
			/**
			Verlustzeit auf einem Abschnitt im Stau.
			<p>
			
			</p>
			
			@return der Wert von Verlustzeit.
			*/
				public 	RelativerZeitstempel
				 getVerlustzeit() {
				return _verlustzeit;
			}
		
			/**
			Verlustzeit auf einem Abschnitt im Stau.
			<p>
			
			</p>
			
			@param _verlustzeit der neue Wert von Verlustzeit.
			*/
			public void setVerlustzeit(	RelativerZeitstempel
			 _verlustzeit) {
				this._verlustzeit = _verlustzeit;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						final Data.Array arrayPrognose = datum.getArray("Prognose");
						arrayPrognose.setLength(getPrognose().size());
						for (int i = 0; i < arrayPrognose.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlNbaDatenStauPrognose
							 atl = getPrognose().get(i);
							atl.bean2Atl(arrayPrognose.getItem(i), factory);
		
						}
					// GanzzahlAttributTyp
					if (getN() != null) {
		                if (getN().isZustand()) {
		                    datum.getUnscaledValue("N").setText(getN().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("N").set(getN().getValue());
		                }
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("Verlustzeit").setMillis(getVerlustzeit().getTime());
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						final Data.Array arrayPrognose = daten.getArray("Prognose");
						for (int i = 0; i < arrayPrognose.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlNbaDatenStauPrognose
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlNbaDatenStauPrognose
							 ();
							atl.atl2Bean(arrayPrognose.getItem(i), factory);
							getPrognose().add(atl);
						}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("N").isState()) {
								setN(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
								.getZustand(daten.getScaledValue("N").getText()));
							} else {
							setN(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeIntervall
							(daten.
								getUnscaledValue
							("N").
									intValue
							()));
							}
					// ZeitstempelAttributTyp
						setVerlustzeit(new
							RelativerZeitstempel
							(daten.getTimeValue("Verlustzeit").getMillis()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
						klon._prognose = getPrognose().clone();
							klon.setN(getN());
							klon.setVerlustzeit(getVerlustzeit());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.nbaDatenStauPrognose";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdNbaDatenStauPrognose(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
