/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zustand plus Verkehrsinformationen für einen
					Streckenabschnitt.
<p>
&lt;absatz&gt;
						Objekte dieses Typs beschreiben den
						Verkehrszustand auf Streckenabschnitten durch
						die Größen:
					&lt;&#47;absatz&gt;
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;
							Referenzzeit (Zeitpunkt der verwendeten
							Daten)
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;Prognosehorizont&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							Verkehrssituation (Level of Service)
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							Fahrzeitprognose für alle Kfz
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							Fahrzeitprognose für alle Pkw
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							Fahrzeitprognose für alle Lkw
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							mittlere Geschwindigkeit Kfz
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							mittlere Geschwindigkeit Pkw
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							mittlere Geschwindigkeit Lkw
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							mittlerer Fluss aller Kfz
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							mittlerer Fluss aller Pkw
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							mittlerer Fluss aller Lkw
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							mittlere Dichte aller Kfz
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							mittlere Dichte aller Pkw
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							mittlere Dichte aller Lkw
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							Güteindex für den Störfall-Verkehrszustand
						&lt;&#47;listenPunkt&gt;
					&lt;&#47;liste&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 27
 */
public class OdStoerfallVerkehrsZustand extends AbstractOnlineDatensatz<OdStoerfallVerkehrsZustand.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.StoerfallVerfahrenMOBINET,
					Aspekte.StoerfallVerfahrenOLSIM1Delta,
					Aspekte.StoerfallVerfahrenOLSIM2Delta,
					Aspekte.StoerfallVerfahrenStandard,
					Aspekte.StoerfallVerfahrenMARZ,
					Aspekte.StoerfallVerfahrenNRW,
					Aspekte.StoerfallVerfahrenRDS,
					Aspekte.StoerfallVerfahrenVKDiffKfz,
					Aspekte.StoerfallVerfahrenOLSIM3Delta,
					Aspekte.StoerfallVerfahrenFD,
					Aspekte.StoerfallVerfahrenOLSIM4Delta,
					Aspekte.StoerfallVerfahrenOLSIM1,
					Aspekte.StoerfallVerfahrenConstraint,
					Aspekte.StoerfallVerfahrenOLSIM2,
					Aspekte.StoerfallVerfahrenFuzzy,
					Aspekte.StoerfallVerfahrenOLSIM3,
					Aspekte.StoerfallVerfahrenOLSIM4,
				};
			}
	
			/**
			 * StörfallIndikator wurde mit einem MOBINET-Verfahren
						ermittelt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenMOBINET = new Aspekte("StörfallVerfahrenMOBINET", "asp.störfallVerfahrenMOBINET");
			
			/**
			 * StörfallIndikator wurde mit dem
						Störfall-Analyse-Verfahrens OLSIM ermittelt.
						Datenübertragung nur bei Vorliegen von Datenveränderungen.
						(Prognosehorizont in Attributgruppe, Standard: aktuelle Werte).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenOLSIM1Delta = new Aspekte("StörfallVerfahrenOLSIM1Delta", "asp.störfallVerfahrenOLSIM1Delta");
			
			/**
			 * StörfallIndikator wurde mit dem
						Störfall-Analyse-Verfahrens OLSIM ermittelt.
						Datenübertragung nur bei Vorliegen von Datenveränderungen.
						(Prognosehorizont in Attributgruppe, Standard: Prognose 30 Minuten).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenOLSIM2Delta = new Aspekte("StörfallVerfahrenOLSIM2Delta", "asp.störfallVerfahrenOLSIM2Delta");
			
			/**
			 * StörfallIndikator wurde mit dem Standard-Verfahren
						ermittelt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenStandard = new Aspekte("StörfallVerfahrenStandard", "asp.störfallVerfahrenStandard");
			
			/**
			 * StörfallIndikator wurde mit dem Verfahren nach MARZ
						ermittelt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenMARZ = new Aspekte("StörfallVerfahrenMARZ", "asp.störfallVerfahrenMARZ");
			
			/**
			 * StörfallIndikator wurde mit dem Verfahren nach NRW
						ermittelt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenNRW = new Aspekte("StörfallVerfahrenNRW", "asp.störfallVerfahrenNRW");
			
			/**
			 * StörfallIndikator wurde mit dem Verfahren für RDS
						ermittelt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenRDS = new Aspekte("StörfallVerfahrenRDS", "asp.störfallVerfahrenRDS");
			
			/**
			 * StörfallIndikator wurde mit dem Verfahren VKdiffKfz
						für StraßenAbschnitte ermittelt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenVKDiffKfz = new Aspekte("StörfallVerfahrenVKDiffKfz", "asp.störfallVerfahrenVKDiffKfz");
			
			/**
			 * StörfallIndikator wurde mit dem
						Störfall-Analyse-Verfahrens OLSIM ermittelt.
						Datenübertragung nur bei Vorliegen von Datenveränderungen.
						(Prognosehorizont in Attributgruppe, Standard: Prognose 60 Minuten).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenOLSIM3Delta = new Aspekte("StörfallVerfahrenOLSIM3Delta", "asp.störfallVerfahrenOLSIM3Delta");
			
			/**
			 * StörfallIndikator wurde mit dem Verfahren
						LokaleStörfallerkennung mit Fundamentaldiagramm
						ermittelt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenFD = new Aspekte("StörfallVerfahrenFD", "asp.störfallVerfahrenFD");
			
			/**
			 * StörfallIndikator wurde mit dem
						Störfall-Analyse-Verfahrens OLSIM ermittelt.
						Datenübertragung nur bei Vorliegen von Datenveränderungen.
						(Prognosehorizont in Attributgruppe, Standard: Prognose 7 Tage).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenOLSIM4Delta = new Aspekte("StörfallVerfahrenOLSIM4Delta", "asp.störfallVerfahrenOLSIM4Delta");
			
			/**
			 * StörfallIndikator wurde mit dem
						Störfall-Analyse-Verfahrens OLSIM ermittelt
						(Prognosehorizont in Attributgruppe, Standard: aktuelle Werte).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenOLSIM1 = new Aspekte("StörfallVerfahrenOLSIM1", "asp.störfallVerfahrenOLSIM1");
			
			/**
			 * StörfallIndikator wurde mit dem Constraint-Verfahren
						ermittelt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenConstraint = new Aspekte("StörfallVerfahrenConstraint", "asp.störfallVerfahrenConstraint");
			
			/**
			 * StörfallIndikator wurde mit dem
						Störfall-Analyse-Verfahrens OLSIM ermittelt
						(Prognosehorizont in Attributgruppe, Standard: Prognose 30 Minuten).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenOLSIM2 = new Aspekte("StörfallVerfahrenOLSIM2", "asp.störfallVerfahrenOLSIM2");
			
			/**
			 * StörfallIndikator wurde mit einem Fuzzy-Verfahren
						ermittelt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenFuzzy = new Aspekte("StörfallVerfahrenFuzzy", "asp.störfallVerfahrenFuzzy");
			
			/**
			 * StörfallIndikator wurde mit dem
						Störfall-Analyse-Verfahrens OLSIM ermittelt
						(Prognosehorizont in Attributgruppe, Standard: Prognose 60 Minuten).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenOLSIM3 = new Aspekte("StörfallVerfahrenOLSIM3", "asp.störfallVerfahrenOLSIM3");
			
			/**
			 * StörfallIndikator wurde mit dem
						Störfall-Analyse-Verfahrens OLSIM ermittelt
						(Prognosehorizont in Attributgruppe, Standard: Prognose 7 Tage).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt StoerfallVerfahrenOLSIM4 = new Aspekte("StörfallVerfahrenOLSIM4", "asp.störfallVerfahrenOLSIM4");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	Zeitstempel
				 _referenzZeit
				;
				private 	RelativerZeitstempel
				 _prognoseHorizont
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStoerfallSituation
				 _situation
				;
				private 	RelativerZeitstempel
				 _reisezeitKfz
				;
				private 	RelativerZeitstempel
				 _reisezeitLkw
				;
				private 	RelativerZeitstempel
				 _reisezeitPkw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 _vKfz
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 _vLkw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 _vPkw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
				 _flussKfz
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
				 _flussLkw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
				 _flussPkw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
				 _dichteKfz
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
				 _dichteLkw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
				 _dichtePkw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AtlGuete
				 _guete
				= new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AtlGuete
				()
				;
		
			/**
			Referenz-Zeitpunkt der Situation bzw. der
									verwendeten Daten.
			<p>
			
			</p>
			
			@return der Wert von ReferenzZeit.
			*/
				public 	Zeitstempel
				 getReferenzZeit() {
				return _referenzZeit;
			}
		
			/**
			Referenz-Zeitpunkt der Situation bzw. der
									verwendeten Daten.
			<p>
			
			</p>
			
			@param _referenzZeit der neue Wert von ReferenzZeit.
			*/
			public void setReferenzZeit(	Zeitstempel
			 _referenzZeit) {
				this._referenzZeit = _referenzZeit;
			}
		
			/**
			Prognosehorizont (0 entspricht Analysewert).
			<p>
			
			</p>
			
			@return der Wert von PrognoseHorizont.
			*/
				public 	RelativerZeitstempel
				 getPrognoseHorizont() {
				return _prognoseHorizont;
			}
		
			/**
			Prognosehorizont (0 entspricht Analysewert).
			<p>
			
			</p>
			
			@param _prognoseHorizont der neue Wert von PrognoseHorizont.
			*/
			public void setPrognoseHorizont(	RelativerZeitstempel
			 _prognoseHorizont) {
				this._prognoseHorizont = _prognoseHorizont;
			}
		
			/**
			Verkehrssituation (Level Of Service).
			<p>
			
			</p>
			
			@return der Wert von Situation.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStoerfallSituation
				 getSituation() {
				return _situation;
			}
		
			/**
			Verkehrssituation (Level Of Service).
			<p>
			
			</p>
			
			@param _situation der neue Wert von Situation.
			*/
			public void setSituation(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStoerfallSituation
			 _situation) {
				this._situation = _situation;
			}
		
			/**
			Prognostizierte, benötigte Fahrzeit in Sekunden
									für Kfz (unspezifisch) des Streckenabschnitts.
			<p>
			
			</p>
			
			@return der Wert von ReisezeitKfz.
			*/
				public 	RelativerZeitstempel
				 getReisezeitKfz() {
				return _reisezeitKfz;
			}
		
			/**
			Prognostizierte, benötigte Fahrzeit in Sekunden
									für Kfz (unspezifisch) des Streckenabschnitts.
			<p>
			
			</p>
			
			@param _reisezeitKfz der neue Wert von ReisezeitKfz.
			*/
			public void setReisezeitKfz(	RelativerZeitstempel
			 _reisezeitKfz) {
				this._reisezeitKfz = _reisezeitKfz;
			}
		
			/**
			Prognostizierte, benötigte Fahrzeit in Sekunden
									für alle LKWs des Streckenabschnitts.
			<p>
			
			</p>
			
			@return der Wert von ReisezeitLkw.
			*/
				public 	RelativerZeitstempel
				 getReisezeitLkw() {
				return _reisezeitLkw;
			}
		
			/**
			Prognostizierte, benötigte Fahrzeit in Sekunden
									für alle LKWs des Streckenabschnitts.
			<p>
			
			</p>
			
			@param _reisezeitLkw der neue Wert von ReisezeitLkw.
			*/
			public void setReisezeitLkw(	RelativerZeitstempel
			 _reisezeitLkw) {
				this._reisezeitLkw = _reisezeitLkw;
			}
		
			/**
			Prognostizierte, benötigte Fahrzeit in Sekunden
									für alle PKWs des Streckenabschnitts.
			<p>
			
			</p>
			
			@return der Wert von ReisezeitPkw.
			*/
				public 	RelativerZeitstempel
				 getReisezeitPkw() {
				return _reisezeitPkw;
			}
		
			/**
			Prognostizierte, benötigte Fahrzeit in Sekunden
									für alle PKWs des Streckenabschnitts.
			<p>
			
			</p>
			
			@param _reisezeitPkw der neue Wert von ReisezeitPkw.
			*/
			public void setReisezeitPkw(	RelativerZeitstempel
			 _reisezeitPkw) {
				this._reisezeitPkw = _reisezeitPkw;
			}
		
			/**
			Prognostizierte, mittlere Geschwindigkeit aller
									Fahrzeuge (unspezifisch).
			<p>
			
			</p>
			
			@return der Wert von VKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 getVKfz() {
				return _vKfz;
			}
		
			/**
			Prognostizierte, mittlere Geschwindigkeit aller
									Fahrzeuge (unspezifisch).
			<p>
			
			</p>
			
			@param _vKfz der neue Wert von VKfz.
			*/
			public void setVKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _vKfz) {
				this._vKfz = _vKfz;
			}
		
			/**
			Prognostizierte, mittlere Geschwindigkeit aller
									LKWs.
			<p>
			
			</p>
			
			@return der Wert von VLkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 getVLkw() {
				return _vLkw;
			}
		
			/**
			Prognostizierte, mittlere Geschwindigkeit aller
									LKWs.
			<p>
			
			</p>
			
			@param _vLkw der neue Wert von VLkw.
			*/
			public void setVLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _vLkw) {
				this._vLkw = _vLkw;
			}
		
			/**
			Prognostizierte, mittlere Geschwindigkeit aller
									PKWs.
			<p>
			
			</p>
			
			@return der Wert von VPkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
				 getVPkw() {
				return _vPkw;
			}
		
			/**
			Prognostizierte, mittlere Geschwindigkeit aller
									PKWs.
			<p>
			
			</p>
			
			@param _vPkw der neue Wert von VPkw.
			*/
			public void setVPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
			 _vPkw) {
				this._vPkw = _vPkw;
			}
		
			/**
			Prognosewert für den Fluss aller Kfz
									(unspezifisch).
			<p>
			
			</p>
			
			@return der Wert von FlussKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
				 getFlussKfz() {
				return _flussKfz;
			}
		
			/**
			Prognosewert für den Fluss aller Kfz
									(unspezifisch).
			<p>
			
			</p>
			
			@param _flussKfz der neue Wert von FlussKfz.
			*/
			public void setFlussKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
			 _flussKfz) {
				this._flussKfz = _flussKfz;
			}
		
			/**
			Prognosewert für den Fluss normiert auf Lkw.
			<p>
			
			</p>
			
			@return der Wert von FlussLkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
				 getFlussLkw() {
				return _flussLkw;
			}
		
			/**
			Prognosewert für den Fluss normiert auf Lkw.
			<p>
			
			</p>
			
			@param _flussLkw der neue Wert von FlussLkw.
			*/
			public void setFlussLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
			 _flussLkw) {
				this._flussLkw = _flussLkw;
			}
		
			/**
			Prognosewert für den Fluss normiert auf Pkw.
			<p>
			
			</p>
			
			@return der Wert von FlussPkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
				 getFlussPkw() {
				return _flussPkw;
			}
		
			/**
			Prognosewert für den Fluss normiert auf Pkw.
			<p>
			
			</p>
			
			@param _flussPkw der neue Wert von FlussPkw.
			*/
			public void setFlussPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
			 _flussPkw) {
				this._flussPkw = _flussPkw;
			}
		
			/**
			Dichte aller Kfz (unspezifisch) bezogen auf den
									Streckenabschnitt.
			<p>
			
			</p>
			
			@return der Wert von DichteKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
				 getDichteKfz() {
				return _dichteKfz;
			}
		
			/**
			Dichte aller Kfz (unspezifisch) bezogen auf den
									Streckenabschnitt.
			<p>
			
			</p>
			
			@param _dichteKfz der neue Wert von DichteKfz.
			*/
			public void setDichteKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
			 _dichteKfz) {
				this._dichteKfz = _dichteKfz;
			}
		
			/**
			Dichte aller Lkw bezogen auf den
									Streckenabschnitt.
			<p>
			
			</p>
			
			@return der Wert von DichteLkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
				 getDichteLkw() {
				return _dichteLkw;
			}
		
			/**
			Dichte aller Lkw bezogen auf den
									Streckenabschnitt.
			<p>
			
			</p>
			
			@param _dichteLkw der neue Wert von DichteLkw.
			*/
			public void setDichteLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
			 _dichteLkw) {
				this._dichteLkw = _dichteLkw;
			}
		
			/**
			Dichte aller Pkw bezogen auf den
									Streckenabschnitt.
			<p>
			
			</p>
			
			@return der Wert von DichtePkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
				 getDichtePkw() {
				return _dichtePkw;
			}
		
			/**
			Dichte aller Pkw bezogen auf den
									Streckenabschnitt.
			<p>
			
			</p>
			
			@param _dichtePkw der neue Wert von DichtePkw.
			*/
			public void setDichtePkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
			 _dichtePkw) {
				this._dichtePkw = _dichtePkw;
			}
		
			/**
			Güteindex für den Störfall-Verkehrszustand.
			<p>
			
			</p>
			
			@return der Wert von Guete.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AtlGuete
				 getGuete() {
				return _guete;
			}
		
			/**
			Güteindex für den Störfall-Verkehrszustand.
			<p>
			
			</p>
			
			@param _guete der neue Wert von Guete.
			*/
			public void setGuete(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AtlGuete
			 _guete) {
				this._guete = _guete;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						datum.getTimeValue("ReferenzZeit").setMillis(getReferenzZeit().getTime());
					// ZeitstempelAttributTyp
						datum.getTimeValue("PrognoseHorizont").setMillis(getPrognoseHorizont().getTime());
					// GanzzahlAttributTyp
					if (getSituation() != null) {
		                if (getSituation().isZustand()) {
		                    datum.getUnscaledValue("Situation").setText(getSituation().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Situation").set(getSituation().getValue());
		                }
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("ReisezeitKfz").setMillis(getReisezeitKfz().getTime());
					// ZeitstempelAttributTyp
						datum.getTimeValue("ReisezeitLkw").setMillis(getReisezeitLkw().getTime());
					// ZeitstempelAttributTyp
						datum.getTimeValue("ReisezeitPkw").setMillis(getReisezeitPkw().getTime());
					// GanzzahlAttributTyp
					if (getVKfz() != null) {
		                if (getVKfz().isZustand()) {
		                    datum.getUnscaledValue("vKfz").setText(getVKfz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vKfz").set(getVKfz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVLkw() != null) {
		                if (getVLkw().isZustand()) {
		                    datum.getUnscaledValue("vLkw").setText(getVLkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vLkw").set(getVLkw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVPkw() != null) {
		                if (getVPkw().isZustand()) {
		                    datum.getUnscaledValue("vPkw").setText(getVPkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vPkw").set(getVPkw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getFlussKfz() != null) {
		                if (getFlussKfz().isZustand()) {
		                    datum.getUnscaledValue("FlussKfz").setText(getFlussKfz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("FlussKfz").set(getFlussKfz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getFlussLkw() != null) {
		                if (getFlussLkw().isZustand()) {
		                    datum.getUnscaledValue("FlussLkw").setText(getFlussLkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("FlussLkw").set(getFlussLkw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getFlussPkw() != null) {
		                if (getFlussPkw().isZustand()) {
		                    datum.getUnscaledValue("FlussPkw").setText(getFlussPkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("FlussPkw").set(getFlussPkw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getDichteKfz() != null) {
		                if (getDichteKfz().isZustand()) {
		                    datum.getUnscaledValue("DichteKfz").setText(getDichteKfz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("DichteKfz").set(getDichteKfz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getDichteLkw() != null) {
		                if (getDichteLkw().isZustand()) {
		                    datum.getUnscaledValue("DichteLkw").setText(getDichteLkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("DichteLkw").set(getDichteLkw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getDichtePkw() != null) {
		                if (getDichtePkw().isZustand()) {
		                    datum.getUnscaledValue("DichtePkw").setText(getDichtePkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("DichtePkw").set(getDichtePkw().getValue());
		                }
					}
					// AttributListenDefinition
						getGuete().bean2Atl(datum.getItem("Güte"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						setReferenzZeit(new
							Zeitstempel
							(daten.getTimeValue("ReferenzZeit").getMillis()));
					// ZeitstempelAttributTyp
						setPrognoseHorizont(new
							RelativerZeitstempel
							(daten.getTimeValue("PrognoseHorizont").getMillis()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Situation").isState()) {
								setSituation(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStoerfallSituation
								.getZustand(daten.getScaledValue("Situation").getText()));
							} else {
							setSituation(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStoerfallSituation
							(daten.
								getUnscaledValue
							("Situation").
									byteValue
							()));
							}
					// ZeitstempelAttributTyp
						setReisezeitKfz(new
							RelativerZeitstempel
							(daten.getTimeValue("ReisezeitKfz").getMillis()));
					// ZeitstempelAttributTyp
						setReisezeitLkw(new
							RelativerZeitstempel
							(daten.getTimeValue("ReisezeitLkw").getMillis()));
					// ZeitstempelAttributTyp
						setReisezeitPkw(new
							RelativerZeitstempel
							(daten.getTimeValue("ReisezeitPkw").getMillis()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vKfz").isState()) {
								setVKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
								.getZustand(daten.getScaledValue("vKfz").getText()));
							} else {
							setVKfz(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							(daten.
								getUnscaledValue
							("vKfz").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vLkw").isState()) {
								setVLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
								.getZustand(daten.getScaledValue("vLkw").getText()));
							} else {
							setVLkw(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							(daten.
								getUnscaledValue
							("vLkw").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vPkw").isState()) {
								setVPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
								.getZustand(daten.getScaledValue("vPkw").getText()));
							} else {
							setVPkw(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit
							(daten.
								getUnscaledValue
							("vPkw").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("FlussKfz").isState()) {
								setFlussKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
								.getZustand(daten.getScaledValue("FlussKfz").getText()));
							} else {
							setFlussKfz(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
							(daten.
								getUnscaledValue
							("FlussKfz").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("FlussLkw").isState()) {
								setFlussLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
								.getZustand(daten.getScaledValue("FlussLkw").getText()));
							} else {
							setFlussLkw(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
							(daten.
								getUnscaledValue
							("FlussLkw").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("FlussPkw").isState()) {
								setFlussPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
								.getZustand(daten.getScaledValue("FlussPkw").getText()));
							} else {
							setFlussPkw(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde
							(daten.
								getUnscaledValue
							("FlussPkw").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("DichteKfz").isState()) {
								setDichteKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
								.getZustand(daten.getScaledValue("DichteKfz").getText()));
							} else {
							setDichteKfz(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
							(daten.
								getUnscaledValue
							("DichteKfz").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("DichteLkw").isState()) {
								setDichteLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
								.getZustand(daten.getScaledValue("DichteLkw").getText()));
							} else {
							setDichteLkw(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
							(daten.
								getUnscaledValue
							("DichteLkw").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("DichtePkw").isState()) {
								setDichtePkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
								.getZustand(daten.getScaledValue("DichtePkw").getText()));
							} else {
							setDichtePkw(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttFahrzeugDichte
							(daten.
								getUnscaledValue
							("DichtePkw").
									shortValue
							()));
							}
					// AttributListenDefinition
						getGuete().atl2Bean(daten.getItem("Güte"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setReferenzZeit(getReferenzZeit());
							klon.setPrognoseHorizont(getPrognoseHorizont());
							klon.setSituation(getSituation());
							klon.setReisezeitKfz(getReisezeitKfz());
							klon.setReisezeitLkw(getReisezeitLkw());
							klon.setReisezeitPkw(getReisezeitPkw());
							klon.setVKfz(getVKfz());
							klon.setVLkw(getVLkw());
							klon.setVPkw(getVPkw());
							klon.setFlussKfz(getFlussKfz());
							klon.setFlussLkw(getFlussLkw());
							klon.setFlussPkw(getFlussPkw());
							klon.setDichteKfz(getDichteKfz());
							klon.setDichteLkw(getDichteLkw());
							klon.setDichtePkw(getDichtePkw());
							klon._guete = getGuete().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.störfallVerkehrsZustand";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdStoerfallVerkehrsZustand(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
