/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Streckenbezogene Verkehrsdaten (Kurzzeit) mit
					Intervallwerten (nicht normiert auf Stundenwerte).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class OdVerkehrsDatenKurzZeitAbschnitt extends AbstractOnlineDatensatz<OdVerkehrsDatenKurzZeitAbschnitt.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.PlausibilitaetsPruefungLogisch,
					Aspekte.MessWertErsetzung,
					Aspekte.PlausibilitaetsPruefungFormal,
					Aspekte.ExterneErfassung,
				};
			}
	
			/**
			 * Attributgruppe nach Modifikation durch die logische Plausibilitätsprüfung.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt PlausibilitaetsPruefungLogisch = new Aspekte("PlausibilitätsPrüfungLogisch", "asp.plausibilitätsPrüfungLogisch");
			
			/**
			 * Attributgruppe nach Modifikation durch die Messwertersetzung.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt MessWertErsetzung = new Aspekte("MessWertErsetzung", "asp.messWertErsetzung");
			
			/**
			 * Attributgruppe nach Modifikation durch die formale Plausibilitätsprüfung.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt PlausibilitaetsPruefungFormal = new Aspekte("PlausibilitätsPrüfungFormal", "asp.plausibilitätsPrüfungFormal");
			
			/**
			 * Attributgruppe wurde durch eine externe Erfassungseinheit geschrieben (z.B. TLS).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ExterneErfassung = new Aspekte("ExterneErfassung", "asp.externeErfassung");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	RelativerZeitstempel
				 _t
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _vKfzReise
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _vPkwReise
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _vLkwReise
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				 _kKfz
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				 _kPkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				 _kLkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				()
				;
		
			/**
			Intervalldauer, mit dem die Werte erfasst
									wurden.
			<p>
			
			</p>
			
			@return der Wert von T.
			*/
				public 	RelativerZeitstempel
				 getT() {
				return _t;
			}
		
			/**
			Intervalldauer, mit dem die Werte erfasst
									wurden.
			<p>
			
			</p>
			
			@param _t der neue Wert von T.
			*/
			public void setT(	RelativerZeitstempel
			 _t) {
				this._t = _t;
			}
		
			/**
			Mittlere Reisegeschwindigkeit Kfz.
			<p>
			
			</p>
			
			@return der Wert von VKfzReise.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getVKfzReise() {
				return _vKfzReise;
			}
		
			/**
			Mittlere Reisegeschwindigkeit Kfz.
			<p>
			
			</p>
			
			@param _vKfzReise der neue Wert von VKfzReise.
			*/
			public void setVKfzReise(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _vKfzReise) {
				this._vKfzReise = _vKfzReise;
			}
		
			/**
			Mittlere Reisegeschwindigkeit Pkw.
			<p>
			
			</p>
			
			@return der Wert von VPkwReise.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getVPkwReise() {
				return _vPkwReise;
			}
		
			/**
			Mittlere Reisegeschwindigkeit Pkw.
			<p>
			
			</p>
			
			@param _vPkwReise der neue Wert von VPkwReise.
			*/
			public void setVPkwReise(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _vPkwReise) {
				this._vPkwReise = _vPkwReise;
			}
		
			/**
			Mittlere Reisegeschwindigkeit Lkw.
			<p>
			
			</p>
			
			@return der Wert von VLkwReise.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getVLkwReise() {
				return _vLkwReise;
			}
		
			/**
			Mittlere Reisegeschwindigkeit Lkw.
			<p>
			
			</p>
			
			@param _vLkwReise der neue Wert von VLkwReise.
			*/
			public void setVLkwReise(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _vLkwReise) {
				this._vLkwReise = _vLkwReise;
			}
		
			/**
			Dichte der KFZ.
			<p>
			
			</p>
			
			@return der Wert von KKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				 getKKfz() {
				return _kKfz;
			}
		
			/**
			Dichte der KFZ.
			<p>
			
			</p>
			
			@param _kKfz der neue Wert von KKfz.
			*/
			public void setKKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
			 _kKfz) {
				this._kKfz = _kKfz;
			}
		
			/**
			Dichte der Pkw.
			<p>
			
			</p>
			
			@return der Wert von KPkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				 getKPkw() {
				return _kPkw;
			}
		
			/**
			Dichte der Pkw.
			<p>
			
			</p>
			
			@param _kPkw der neue Wert von KPkw.
			*/
			public void setKPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
			 _kPkw) {
				this._kPkw = _kPkw;
			}
		
			/**
			Dichte der Lkw.
			<p>
			
			</p>
			
			@return der Wert von KLkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				 getKLkw() {
				return _kLkw;
			}
		
			/**
			Dichte der Lkw.
			<p>
			
			</p>
			
			@param _kLkw der neue Wert von KLkw.
			*/
			public void setKLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
			 _kLkw) {
				this._kLkw = _kLkw;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						datum.getTimeValue("T").setMillis(getT().getTime());
					// AttributListenDefinition
						getVKfzReise().bean2Atl(datum.getItem("vKfzReise"), factory);
					// AttributListenDefinition
						getVPkwReise().bean2Atl(datum.getItem("vPkwReise"), factory);
					// AttributListenDefinition
						getVLkwReise().bean2Atl(datum.getItem("vLkwReise"), factory);
					// AttributListenDefinition
						getKKfz().bean2Atl(datum.getItem("kKfz"), factory);
					// AttributListenDefinition
						getKPkw().bean2Atl(datum.getItem("kPkw"), factory);
					// AttributListenDefinition
						getKLkw().bean2Atl(datum.getItem("kLkw"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						setT(new
							RelativerZeitstempel
							(daten.getTimeValue("T").getMillis()));
					// AttributListenDefinition
						getVKfzReise().atl2Bean(daten.getItem("vKfzReise"), factory);
					// AttributListenDefinition
						getVPkwReise().atl2Bean(daten.getItem("vPkwReise"), factory);
					// AttributListenDefinition
						getVLkwReise().atl2Bean(daten.getItem("vLkwReise"), factory);
					// AttributListenDefinition
						getKKfz().atl2Bean(daten.getItem("kKfz"), factory);
					// AttributListenDefinition
						getKPkw().atl2Bean(daten.getItem("kPkw"), factory);
					// AttributListenDefinition
						getKLkw().atl2Bean(daten.getItem("kLkw"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setT(getT());
							klon._vKfzReise = getVKfzReise().clone();
							klon._vPkwReise = getVPkwReise().clone();
							klon._vLkwReise = getVLkwReise().clone();
							klon._kKfz = getKKfz().clone();
							klon._kPkw = getKPkw().clone();
							klon._kLkw = getKLkw().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.verkehrsDatenKurzZeitAbschnitt";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdVerkehrsDatenKurzZeitAbschnitt(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
