/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Verkehrsdaten (Kurzzeit) mit Intervallwerten (noch
					nicht normiert auf Stundenwerte) .
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class OdVerkehrsDatenKurzZeitIntervall extends AbstractOnlineDatensatz<OdVerkehrsDatenKurzZeitIntervall.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.PlausibilitaetsPruefungLogisch,
					Aspekte.MessWertErsetzung,
					Aspekte.PlausibilitaetsPruefungFormal,
					Aspekte.ExterneErfassung,
				};
			}
	
			/**
			 * Attributgruppe nach Modifikation durch die logische Plausibilitätsprüfung.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt PlausibilitaetsPruefungLogisch = new Aspekte("PlausibilitätsPrüfungLogisch", "asp.plausibilitätsPrüfungLogisch");
			
			/**
			 * Attributgruppe nach Modifikation durch die Messwertersetzung.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt MessWertErsetzung = new Aspekte("MessWertErsetzung", "asp.messWertErsetzung");
			
			/**
			 * Attributgruppe nach Modifikation durch die formale Plausibilitätsprüfung.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt PlausibilitaetsPruefungFormal = new Aspekte("PlausibilitätsPrüfungFormal", "asp.plausibilitätsPrüfungFormal");
			
			/**
			 * Attributgruppe wurde durch eine externe Erfassungseinheit geschrieben (z.B. TLS).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ExterneErfassung = new Aspekte("ExterneErfassung", "asp.externeErfassung");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	RelativerZeitstempel
				 _t
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttArtMittelwertbildung
				 _artMittelwertbildung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeIntervall
				 _qKfz
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeIntervall
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _vKfz
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeIntervall
				 _qLkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeIntervall
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _vLkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeIntervall
				 _qPkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeIntervall
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _vPkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlProzent
				 _b
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlProzent
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlZeitDauerMilliSekunden
				 _tNetto
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlZeitDauerMilliSekunden
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _sKfz
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _vgKfz
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
		
			/**
			Intervalldauer, mit dem die Werte erfasst
									wurden.
			<p>
			
			</p>
			
			@return der Wert von T.
			*/
				public 	RelativerZeitstempel
				 getT() {
				return _t;
			}
		
			/**
			Intervalldauer, mit dem die Werte erfasst
									wurden.
			<p>
			
			</p>
			
			@param _t der neue Wert von T.
			*/
			public void setT(	RelativerZeitstempel
			 _t) {
				this._t = _t;
			}
		
			/**
			Art der Mittelwertbildung (arithmetisch oder
									gleitend).
			<p>
			
			</p>
			
			@return der Wert von ArtMittelwertbildung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttArtMittelwertbildung
				 getArtMittelwertbildung() {
				return _artMittelwertbildung;
			}
		
			/**
			Art der Mittelwertbildung (arithmetisch oder
									gleitend).
			<p>
			
			</p>
			
			@param _artMittelwertbildung der neue Wert von ArtMittelwertbildung.
			*/
			public void setArtMittelwertbildung(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttArtMittelwertbildung
			 _artMittelwertbildung) {
				this._artMittelwertbildung = _artMittelwertbildung;
			}
		
			/**
			Fahrzeugmenge Kfz (mit Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von QKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeIntervall
				 getQKfz() {
				return _qKfz;
			}
		
			/**
			Fahrzeugmenge Kfz (mit Statusinformationen).
			<p>
			
			</p>
			
			@param _qKfz der neue Wert von QKfz.
			*/
			public void setQKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeIntervall
			 _qKfz) {
				this._qKfz = _qKfz;
			}
		
			/**
			Geschwindigkeit Kfz (mit Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von VKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getVKfz() {
				return _vKfz;
			}
		
			/**
			Geschwindigkeit Kfz (mit Statusinformationen).
			<p>
			
			</p>
			
			@param _vKfz der neue Wert von VKfz.
			*/
			public void setVKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _vKfz) {
				this._vKfz = _vKfz;
			}
		
			/**
			Fahrzeugmenge Lkw (mit Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von QLkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeIntervall
				 getQLkw() {
				return _qLkw;
			}
		
			/**
			Fahrzeugmenge Lkw (mit Statusinformationen).
			<p>
			
			</p>
			
			@param _qLkw der neue Wert von QLkw.
			*/
			public void setQLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeIntervall
			 _qLkw) {
				this._qLkw = _qLkw;
			}
		
			/**
			Geschwindigkeit Lkw (mit Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von VLkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getVLkw() {
				return _vLkw;
			}
		
			/**
			Geschwindigkeit Lkw (mit Statusinformationen).
			<p>
			
			</p>
			
			@param _vLkw der neue Wert von VLkw.
			*/
			public void setVLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _vLkw) {
				this._vLkw = _vLkw;
			}
		
			/**
			Fahrzeugmenge Pkw (mit Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von QPkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeIntervall
				 getQPkw() {
				return _qPkw;
			}
		
			/**
			Fahrzeugmenge Pkw (mit Statusinformationen).
			<p>
			
			</p>
			
			@param _qPkw der neue Wert von QPkw.
			*/
			public void setQPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeIntervall
			 _qPkw) {
				this._qPkw = _qPkw;
			}
		
			/**
			Geschwindigkeit Pkw (mit Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von VPkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getVPkw() {
				return _vPkw;
			}
		
			/**
			Geschwindigkeit Pkw (mit Statusinformationen).
			<p>
			
			</p>
			
			@param _vPkw der neue Wert von VPkw.
			*/
			public void setVPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _vPkw) {
				this._vPkw = _vPkw;
			}
		
			/**
			Belegungsgrad (mit Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von B.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlProzent
				 getB() {
				return _b;
			}
		
			/**
			Belegungsgrad (mit Statusinformationen).
			<p>
			
			</p>
			
			@param _b der neue Wert von B.
			*/
			public void setB(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlProzent
			 _b) {
				this._b = _b;
			}
		
			/**
			Mittlere Nettozeitlücke (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von TNetto.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlZeitDauerMilliSekunden
				 getTNetto() {
				return _tNetto;
			}
		
			/**
			Mittlere Nettozeitlücke (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@param _tNetto der neue Wert von TNetto.
			*/
			public void setTNetto(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlZeitDauerMilliSekunden
			 _tNetto) {
				this._tNetto = _tNetto;
			}
		
			/**
			Standardabweichung der Geschwindigkeit (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von SKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getSKfz() {
				return _sKfz;
			}
		
			/**
			Standardabweichung der Geschwindigkeit (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@param _sKfz der neue Wert von SKfz.
			*/
			public void setSKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _sKfz) {
				this._sKfz = _sKfz;
			}
		
			/**
			Geglätte mittlere Geschwindigkeit (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von VgKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getVgKfz() {
				return _vgKfz;
			}
		
			/**
			Geglätte mittlere Geschwindigkeit (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@param _vgKfz der neue Wert von VgKfz.
			*/
			public void setVgKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _vgKfz) {
				this._vgKfz = _vgKfz;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						datum.getTimeValue("T").setMillis(getT().getTime());
					// GanzzahlAttributTyp
					if (getArtMittelwertbildung() != null) {
		                if (getArtMittelwertbildung().isZustand()) {
		                    datum.getUnscaledValue("ArtMittelwertbildung").setText(getArtMittelwertbildung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ArtMittelwertbildung").set(getArtMittelwertbildung().getValue());
		                }
					}
					// AttributListenDefinition
						getQKfz().bean2Atl(datum.getItem("qKfz"), factory);
					// AttributListenDefinition
						getVKfz().bean2Atl(datum.getItem("vKfz"), factory);
					// AttributListenDefinition
						getQLkw().bean2Atl(datum.getItem("qLkw"), factory);
					// AttributListenDefinition
						getVLkw().bean2Atl(datum.getItem("vLkw"), factory);
					// AttributListenDefinition
						getQPkw().bean2Atl(datum.getItem("qPkw"), factory);
					// AttributListenDefinition
						getVPkw().bean2Atl(datum.getItem("vPkw"), factory);
					// AttributListenDefinition
						getB().bean2Atl(datum.getItem("b"), factory);
					// AttributListenDefinition
						getTNetto().bean2Atl(datum.getItem("tNetto"), factory);
					// AttributListenDefinition
						getSKfz().bean2Atl(datum.getItem("sKfz"), factory);
					// AttributListenDefinition
						getVgKfz().bean2Atl(datum.getItem("vgKfz"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						setT(new
							RelativerZeitstempel
							(daten.getTimeValue("T").getMillis()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("ArtMittelwertbildung").isState()) {
								setArtMittelwertbildung(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttArtMittelwertbildung
								.getZustand(daten.getScaledValue("ArtMittelwertbildung").getText()));
							} else {
							setArtMittelwertbildung(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttArtMittelwertbildung
							(daten.
								getUnscaledValue
							("ArtMittelwertbildung").
									byteValue
							()));
							}
					// AttributListenDefinition
						getQKfz().atl2Bean(daten.getItem("qKfz"), factory);
					// AttributListenDefinition
						getVKfz().atl2Bean(daten.getItem("vKfz"), factory);
					// AttributListenDefinition
						getQLkw().atl2Bean(daten.getItem("qLkw"), factory);
					// AttributListenDefinition
						getVLkw().atl2Bean(daten.getItem("vLkw"), factory);
					// AttributListenDefinition
						getQPkw().atl2Bean(daten.getItem("qPkw"), factory);
					// AttributListenDefinition
						getVPkw().atl2Bean(daten.getItem("vPkw"), factory);
					// AttributListenDefinition
						getB().atl2Bean(daten.getItem("b"), factory);
					// AttributListenDefinition
						getTNetto().atl2Bean(daten.getItem("tNetto"), factory);
					// AttributListenDefinition
						getSKfz().atl2Bean(daten.getItem("sKfz"), factory);
					// AttributListenDefinition
						getVgKfz().atl2Bean(daten.getItem("vgKfz"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setT(getT());
							klon.setArtMittelwertbildung(getArtMittelwertbildung());
							klon._qKfz = getQKfz().clone();
							klon._vKfz = getVKfz().clone();
							klon._qLkw = getQLkw().clone();
							klon._vLkw = getVLkw().clone();
							klon._qPkw = getQPkw().clone();
							klon._vPkw = getVPkw().clone();
							klon._b = getB().clone();
							klon._tNetto = getTNetto().clone();
							klon._sKfz = getSKfz().clone();
							klon._vgKfz = getVgKfz().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.verkehrsDatenKurzZeitIntervall";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdVerkehrsDatenKurzZeitIntervall(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
