/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zeitlich trendextrapolierte Verkehrsprognosedaten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class OdVerkehrsDatenKurzZeitTrendExtraPolationMq extends AbstractOnlineDatensatz<OdVerkehrsDatenKurzZeitTrendExtraPolationMq.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.PrognoseFlink,
					Aspekte.PrognoseNormal,
					Aspekte.PrognoseTraege,
				};
			}
	
			/**
			 * Prognosewertberechnung mit schwacher"Dämpfung", d.h.
						den Analysewerten"flink" folgend.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt PrognoseFlink = new Aspekte("PrognoseFlink", "asp.prognoseFlink");
			
			/**
			 * Prognosewertberechnung mit normaler"Dämpfung", d.h.
						den Analysewerten normal" folgend.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt PrognoseNormal = new Aspekte("PrognoseNormal", "asp.prognoseNormal");
			
			/**
			 * Prognosewertberechnung mit schwacher"Dämpfung", d.h.
						den Analysewerten"träge" folgend.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt PrognoseTraege = new Aspekte("PrognoseTräge", "asp.prognoseTräge");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 _qKfzP
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _vKfzP
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 _qLkwP
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _vLkwP
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 _qPkwP
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _vPkwP
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlProzent
				 _aLkwP
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlProzent
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				 _kKfzP
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				 _kLkwP
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				 _kPkwP
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBemessungsVerkehrsStaerkeStunde
				 _qBP
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBemessungsVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBemessungsFahrzeugDichte
				 _kBP
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBemessungsFahrzeugDichte
				()
				;
		
			/**
			Prognostizierte Fahrzeugmenge Kfz (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von QKfzP.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 getQKfzP() {
				return _qKfzP;
			}
		
			/**
			Prognostizierte Fahrzeugmenge Kfz (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@param _qKfzP der neue Wert von QKfzP.
			*/
			public void setQKfzP(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
			 _qKfzP) {
				this._qKfzP = _qKfzP;
			}
		
			/**
			Prognostizierte Geschwindigkeit Kfz (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von VKfzP.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getVKfzP() {
				return _vKfzP;
			}
		
			/**
			Prognostizierte Geschwindigkeit Kfz (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@param _vKfzP der neue Wert von VKfzP.
			*/
			public void setVKfzP(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _vKfzP) {
				this._vKfzP = _vKfzP;
			}
		
			/**
			Prognostizierte Fahrzeugmenge Lkw (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von QLkwP.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 getQLkwP() {
				return _qLkwP;
			}
		
			/**
			Prognostizierte Fahrzeugmenge Lkw (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@param _qLkwP der neue Wert von QLkwP.
			*/
			public void setQLkwP(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
			 _qLkwP) {
				this._qLkwP = _qLkwP;
			}
		
			/**
			Prognostizierte Geschwindigkeit Lkw (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von VLkwP.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getVLkwP() {
				return _vLkwP;
			}
		
			/**
			Prognostizierte Geschwindigkeit Lkw (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@param _vLkwP der neue Wert von VLkwP.
			*/
			public void setVLkwP(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _vLkwP) {
				this._vLkwP = _vLkwP;
			}
		
			/**
			Prognostizierte Fahrzeugmenge Pkw (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von QPkwP.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 getQPkwP() {
				return _qPkwP;
			}
		
			/**
			Prognostizierte Fahrzeugmenge Pkw (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@param _qPkwP der neue Wert von QPkwP.
			*/
			public void setQPkwP(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
			 _qPkwP) {
				this._qPkwP = _qPkwP;
			}
		
			/**
			Prognostizierte Geschwindigkeit Pkw (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von VPkwP.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getVPkwP() {
				return _vPkwP;
			}
		
			/**
			Prognostizierte Geschwindigkeit Pkw (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@param _vPkwP der neue Wert von VPkwP.
			*/
			public void setVPkwP(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _vPkwP) {
				this._vPkwP = _vPkwP;
			}
		
			/**
			Prognostizierte Lkw-Anteil (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von ALkwP.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlProzent
				 getALkwP() {
				return _aLkwP;
			}
		
			/**
			Prognostizierte Lkw-Anteil (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@param _aLkwP der neue Wert von ALkwP.
			*/
			public void setALkwP(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlProzent
			 _aLkwP) {
				this._aLkwP = _aLkwP;
			}
		
			/**
			Prognostizierte Dichte der Kfz (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von KKfzP.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				 getKKfzP() {
				return _kKfzP;
			}
		
			/**
			Prognostizierte Dichte der Kfz (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@param _kKfzP der neue Wert von KKfzP.
			*/
			public void setKKfzP(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
			 _kKfzP) {
				this._kKfzP = _kKfzP;
			}
		
			/**
			Prognostizierte Dichte der Lkw (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von KLkwP.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				 getKLkwP() {
				return _kLkwP;
			}
		
			/**
			Prognostizierte Dichte der Lkw (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@param _kLkwP der neue Wert von KLkwP.
			*/
			public void setKLkwP(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
			 _kLkwP) {
				this._kLkwP = _kLkwP;
			}
		
			/**
			Prognostizierte Dichte der Pkw (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von KPkwP.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
				 getKPkwP() {
				return _kPkwP;
			}
		
			/**
			Prognostizierte Dichte der Pkw (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@param _kPkwP der neue Wert von KPkwP.
			*/
			public void setKPkwP(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlFahrzeugDichte
			 _kPkwP) {
				this._kPkwP = _kPkwP;
			}
		
			/**
			Prognostizierte Bemessungsverkehrsstärke (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von QBP.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBemessungsVerkehrsStaerkeStunde
				 getQBP() {
				return _qBP;
			}
		
			/**
			Prognostizierte Bemessungsverkehrsstärke (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@param _qBP der neue Wert von QBP.
			*/
			public void setQBP(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBemessungsVerkehrsStaerkeStunde
			 _qBP) {
				this._qBP = _qBP;
			}
		
			/**
			Prognostizierte Bemessungsverkehrsdichte (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@return der Wert von KBP.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBemessungsFahrzeugDichte
				 getKBP() {
				return _kBP;
			}
		
			/**
			Prognostizierte Bemessungsverkehrsdichte (mit
									Statusinformationen).
			<p>
			
			</p>
			
			@param _kBP der neue Wert von KBP.
			*/
			public void setKBP(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlBemessungsFahrzeugDichte
			 _kBP) {
				this._kBP = _kBP;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getQKfzP().bean2Atl(datum.getItem("QKfzP"), factory);
					// AttributListenDefinition
						getVKfzP().bean2Atl(datum.getItem("VKfzP"), factory);
					// AttributListenDefinition
						getQLkwP().bean2Atl(datum.getItem("QLkwP"), factory);
					// AttributListenDefinition
						getVLkwP().bean2Atl(datum.getItem("VLkwP"), factory);
					// AttributListenDefinition
						getQPkwP().bean2Atl(datum.getItem("QPkwP"), factory);
					// AttributListenDefinition
						getVPkwP().bean2Atl(datum.getItem("VPkwP"), factory);
					// AttributListenDefinition
						getALkwP().bean2Atl(datum.getItem("ALkwP"), factory);
					// AttributListenDefinition
						getKKfzP().bean2Atl(datum.getItem("KKfzP"), factory);
					// AttributListenDefinition
						getKLkwP().bean2Atl(datum.getItem("KLkwP"), factory);
					// AttributListenDefinition
						getKPkwP().bean2Atl(datum.getItem("KPkwP"), factory);
					// AttributListenDefinition
						getQBP().bean2Atl(datum.getItem("QBP"), factory);
					// AttributListenDefinition
						getKBP().bean2Atl(datum.getItem("KBP"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getQKfzP().atl2Bean(daten.getItem("QKfzP"), factory);
					// AttributListenDefinition
						getVKfzP().atl2Bean(daten.getItem("VKfzP"), factory);
					// AttributListenDefinition
						getQLkwP().atl2Bean(daten.getItem("QLkwP"), factory);
					// AttributListenDefinition
						getVLkwP().atl2Bean(daten.getItem("VLkwP"), factory);
					// AttributListenDefinition
						getQPkwP().atl2Bean(daten.getItem("QPkwP"), factory);
					// AttributListenDefinition
						getVPkwP().atl2Bean(daten.getItem("VPkwP"), factory);
					// AttributListenDefinition
						getALkwP().atl2Bean(daten.getItem("ALkwP"), factory);
					// AttributListenDefinition
						getKKfzP().atl2Bean(daten.getItem("KKfzP"), factory);
					// AttributListenDefinition
						getKLkwP().atl2Bean(daten.getItem("KLkwP"), factory);
					// AttributListenDefinition
						getKPkwP().atl2Bean(daten.getItem("KPkwP"), factory);
					// AttributListenDefinition
						getQBP().atl2Bean(daten.getItem("QBP"), factory);
					// AttributListenDefinition
						getKBP().atl2Bean(daten.getItem("KBP"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._qKfzP = getQKfzP().clone();
							klon._vKfzP = getVKfzP().clone();
							klon._qLkwP = getQLkwP().clone();
							klon._vLkwP = getVLkwP().clone();
							klon._qPkwP = getQPkwP().clone();
							klon._vPkwP = getVPkwP().clone();
							klon._aLkwP = getALkwP().clone();
							klon._kKfzP = getKKfzP().clone();
							klon._kLkwP = getKLkwP().clone();
							klon._kPkwP = getKPkwP().clone();
							klon._qBP = getQBP().clone();
							klon._kBP = getKBP().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.verkehrsDatenKurzZeitTrendExtraPolationMq";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdVerkehrsDatenKurzZeitTrendExtraPolationMq(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
