/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Verkehrsdaten (Langzeit) mit Intervallwerten (nicht
					normiert auf Stundenwerte).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class OdVerkehrsDatenLangZeitIntervall extends AbstractOnlineDatensatz<OdVerkehrsDatenLangZeitIntervall.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.PlausibilitaetsPruefungLogisch,
					Aspekte.MessWertErsetzung,
					Aspekte.PlausibilitaetsPruefungFormal,
					Aspekte.ExterneErfassung,
				};
			}
	
			/**
			 * Attributgruppe nach Modifikation durch die logische Plausibilitätsprüfung.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt PlausibilitaetsPruefungLogisch = new Aspekte("PlausibilitätsPrüfungLogisch", "asp.plausibilitätsPrüfungLogisch");
			
			/**
			 * Attributgruppe nach Modifikation durch die Messwertersetzung.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt MessWertErsetzung = new Aspekte("MessWertErsetzung", "asp.messWertErsetzung");
			
			/**
			 * Attributgruppe nach Modifikation durch die formale Plausibilitätsprüfung.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt PlausibilitaetsPruefungFormal = new Aspekte("PlausibilitätsPrüfungFormal", "asp.plausibilitätsPrüfungFormal");
			
			/**
			 * Attributgruppe wurde durch eine externe Erfassungseinheit geschrieben (z.B. TLS).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ExterneErfassung = new Aspekte("ExterneErfassung", "asp.externeErfassung");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	RelativerZeitstempel
				 _t
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 _qKfz
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 _qPkwAe
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 _qKfzNk
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 _qPkwG
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 _qPkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 _qKrad
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 _qLfw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 _qLkwAe
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 _qPkwA
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 _qLkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 _qBus
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 _qLkwK
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 _qLkwA
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 _qSattelKfz
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _vKfz
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _vPkwAe
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _vKfzNk
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _vPkwG
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _vPkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _vKrad
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _vLfw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _vLkwAe
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _vPkwA
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _vLkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _vBus
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _vLkwK
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _vLkwA
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _vSattelKfz
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _sKfz
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _sPkwAe
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _sKfzNk
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _sPkwG
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _sPkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _sKrad
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _sLfw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _sLkwAe
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _sPkwA
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _sLkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _sBus
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _sLkwK
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _sLkwA
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _sSattelKfz
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _v85Kfz
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _v85PkwAe
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _v85KfzNk
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _v85PkwG
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _v85Pkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _v85Krad
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _v85Lfw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _v85LkwAe
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _v85PkwA
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _v85Lkw
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _v85Bus
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _v85LkwK
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _v85LkwA
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 _v85SattelKfz
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				()
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				> _qKfzGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				> _qPkwAeGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				> _qKfzNkGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				> _qPkwGGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				> _qPkwGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				> _qKradGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				> _qLfwGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				> _qLkwAeGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				> _qPkwAGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				> _qLkwGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				> _qBusGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				> _qLkwKGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				> _qLkwAGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				> _qSattelKfzGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				>(16, true);
		
			/**
			Intervalldauer, mit dem die Werte erfasst
									wurden.
			<p>
			
			</p>
			
			@return der Wert von T.
			*/
				public 	RelativerZeitstempel
				 getT() {
				return _t;
			}
		
			/**
			Intervalldauer, mit dem die Werte erfasst
									wurden.
			<p>
			
			</p>
			
			@param _t der neue Wert von T.
			*/
			public void setT(	RelativerZeitstempel
			 _t) {
				this._t = _t;
			}
		
			/**
			Fahrzeugmenge Kfz.
			<p>
			
			</p>
			
			@return der Wert von QKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 getQKfz() {
				return _qKfz;
			}
		
			/**
			Fahrzeugmenge Kfz.
			<p>
			
			</p>
			
			@param _qKfz der neue Wert von QKfz.
			*/
			public void setQKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
			 _qKfz) {
				this._qKfz = _qKfz;
			}
		
			/**
			Fahrzeugmenge Pkw ähnliche.
			<p>
			
			</p>
			
			@return der Wert von QPkwAe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 getQPkwAe() {
				return _qPkwAe;
			}
		
			/**
			Fahrzeugmenge Pkw ähnliche.
			<p>
			
			</p>
			
			@param _qPkwAe der neue Wert von QPkwAe.
			*/
			public void setQPkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
			 _qPkwAe) {
				this._qPkwAe = _qPkwAe;
			}
		
			/**
			Fahrzeugmenge Kfz nicht klassifiziert.
			<p>
			
			</p>
			
			@return der Wert von QKfzNk.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 getQKfzNk() {
				return _qKfzNk;
			}
		
			/**
			Fahrzeugmenge Kfz nicht klassifiziert.
			<p>
			
			</p>
			
			@param _qKfzNk der neue Wert von QKfzNk.
			*/
			public void setQKfzNk(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
			 _qKfzNk) {
				this._qKfzNk = _qKfzNk;
			}
		
			/**
			Fahrzeugmenge Pkw Gruppe (Motorräder, Pkw ,
									Lieferwagen).
			<p>
			
			</p>
			
			@return der Wert von QPkwG.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 getQPkwG() {
				return _qPkwG;
			}
		
			/**
			Fahrzeugmenge Pkw Gruppe (Motorräder, Pkw ,
									Lieferwagen).
			<p>
			
			</p>
			
			@param _qPkwG der neue Wert von QPkwG.
			*/
			public void setQPkwG(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
			 _qPkwG) {
				this._qPkwG = _qPkwG;
			}
		
			/**
			Fahrzeugmenge Pkw.
			<p>
			
			</p>
			
			@return der Wert von QPkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 getQPkw() {
				return _qPkw;
			}
		
			/**
			Fahrzeugmenge Pkw.
			<p>
			
			</p>
			
			@param _qPkw der neue Wert von QPkw.
			*/
			public void setQPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
			 _qPkw) {
				this._qPkw = _qPkw;
			}
		
			/**
			Fahrzeugmenge Krad.
			<p>
			
			</p>
			
			@return der Wert von QKrad.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 getQKrad() {
				return _qKrad;
			}
		
			/**
			Fahrzeugmenge Krad.
			<p>
			
			</p>
			
			@param _qKrad der neue Wert von QKrad.
			*/
			public void setQKrad(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
			 _qKrad) {
				this._qKrad = _qKrad;
			}
		
			/**
			Fahrzeugmenge Lieferwagen.
			<p>
			
			</p>
			
			@return der Wert von QLfw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 getQLfw() {
				return _qLfw;
			}
		
			/**
			Fahrzeugmenge Lieferwagen.
			<p>
			
			</p>
			
			@param _qLfw der neue Wert von QLfw.
			*/
			public void setQLfw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
			 _qLfw) {
				this._qLfw = _qLfw;
			}
		
			/**
			Fahrzeugmenge Lkw ähnliche.
			<p>
			
			</p>
			
			@return der Wert von QLkwAe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 getQLkwAe() {
				return _qLkwAe;
			}
		
			/**
			Fahrzeugmenge Lkw ähnliche.
			<p>
			
			</p>
			
			@param _qLkwAe der neue Wert von QLkwAe.
			*/
			public void setQLkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
			 _qLkwAe) {
				this._qLkwAe = _qLkwAe;
			}
		
			/**
			Fahrzeugmenge Pkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von QPkwA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 getQPkwA() {
				return _qPkwA;
			}
		
			/**
			Fahrzeugmenge Pkw mit Anhänger.
			<p>
			
			</p>
			
			@param _qPkwA der neue Wert von QPkwA.
			*/
			public void setQPkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
			 _qPkwA) {
				this._qPkwA = _qPkwA;
			}
		
			/**
			Fahrzeugmenge Lkw.
			<p>
			
			</p>
			
			@return der Wert von QLkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 getQLkw() {
				return _qLkw;
			}
		
			/**
			Fahrzeugmenge Lkw.
			<p>
			
			</p>
			
			@param _qLkw der neue Wert von QLkw.
			*/
			public void setQLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
			 _qLkw) {
				this._qLkw = _qLkw;
			}
		
			/**
			Fahrzeugmenge Busse.
			<p>
			
			</p>
			
			@return der Wert von QBus.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 getQBus() {
				return _qBus;
			}
		
			/**
			Fahrzeugmenge Busse.
			<p>
			
			</p>
			
			@param _qBus der neue Wert von QBus.
			*/
			public void setQBus(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
			 _qBus) {
				this._qBus = _qBus;
			}
		
			/**
			Fahrzeugmenge Lkw mit Anhänger und Sattel-Kfz.
			<p>
			
			</p>
			
			@return der Wert von QLkwK.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 getQLkwK() {
				return _qLkwK;
			}
		
			/**
			Fahrzeugmenge Lkw mit Anhänger und Sattel-Kfz.
			<p>
			
			</p>
			
			@param _qLkwK der neue Wert von QLkwK.
			*/
			public void setQLkwK(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
			 _qLkwK) {
				this._qLkwK = _qLkwK;
			}
		
			/**
			Fahrzeugmenge Lkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von QLkwA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 getQLkwA() {
				return _qLkwA;
			}
		
			/**
			Fahrzeugmenge Lkw mit Anhänger.
			<p>
			
			</p>
			
			@param _qLkwA der neue Wert von QLkwA.
			*/
			public void setQLkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
			 _qLkwA) {
				this._qLkwA = _qLkwA;
			}
		
			/**
			Fahrzeugmenge Sattel-Kfz.
			<p>
			
			</p>
			
			@return der Wert von QSattelKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				 getQSattelKfz() {
				return _qSattelKfz;
			}
		
			/**
			Fahrzeugmenge Sattel-Kfz.
			<p>
			
			</p>
			
			@param _qSattelKfz der neue Wert von QSattelKfz.
			*/
			public void setQSattelKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
			 _qSattelKfz) {
				this._qSattelKfz = _qSattelKfz;
			}
		
			/**
			Geschwindigkeit Kfz.
			<p>
			
			</p>
			
			@return der Wert von VKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getVKfz() {
				return _vKfz;
			}
		
			/**
			Geschwindigkeit Kfz.
			<p>
			
			</p>
			
			@param _vKfz der neue Wert von VKfz.
			*/
			public void setVKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _vKfz) {
				this._vKfz = _vKfz;
			}
		
			/**
			Geschwindigkeit Pkw ähnliche.
			<p>
			
			</p>
			
			@return der Wert von VPkwAe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getVPkwAe() {
				return _vPkwAe;
			}
		
			/**
			Geschwindigkeit Pkw ähnliche.
			<p>
			
			</p>
			
			@param _vPkwAe der neue Wert von VPkwAe.
			*/
			public void setVPkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _vPkwAe) {
				this._vPkwAe = _vPkwAe;
			}
		
			/**
			Geschwindigkeit Kfz nicht klassifiziert.
			<p>
			
			</p>
			
			@return der Wert von VKfzNk.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getVKfzNk() {
				return _vKfzNk;
			}
		
			/**
			Geschwindigkeit Kfz nicht klassifiziert.
			<p>
			
			</p>
			
			@param _vKfzNk der neue Wert von VKfzNk.
			*/
			public void setVKfzNk(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _vKfzNk) {
				this._vKfzNk = _vKfzNk;
			}
		
			/**
			Geschwindigkeit Pkw Gruppe (Motorräder, Pkw ,
									Lieferwagen).
			<p>
			
			</p>
			
			@return der Wert von VPkwG.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getVPkwG() {
				return _vPkwG;
			}
		
			/**
			Geschwindigkeit Pkw Gruppe (Motorräder, Pkw ,
									Lieferwagen).
			<p>
			
			</p>
			
			@param _vPkwG der neue Wert von VPkwG.
			*/
			public void setVPkwG(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _vPkwG) {
				this._vPkwG = _vPkwG;
			}
		
			/**
			Geschwindigkeit Pkw.
			<p>
			
			</p>
			
			@return der Wert von VPkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getVPkw() {
				return _vPkw;
			}
		
			/**
			Geschwindigkeit Pkw.
			<p>
			
			</p>
			
			@param _vPkw der neue Wert von VPkw.
			*/
			public void setVPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _vPkw) {
				this._vPkw = _vPkw;
			}
		
			/**
			Geschwindigkeit Krad.
			<p>
			
			</p>
			
			@return der Wert von VKrad.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getVKrad() {
				return _vKrad;
			}
		
			/**
			Geschwindigkeit Krad.
			<p>
			
			</p>
			
			@param _vKrad der neue Wert von VKrad.
			*/
			public void setVKrad(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _vKrad) {
				this._vKrad = _vKrad;
			}
		
			/**
			Geschwindigkeit Lieferwagen.
			<p>
			
			</p>
			
			@return der Wert von VLfw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getVLfw() {
				return _vLfw;
			}
		
			/**
			Geschwindigkeit Lieferwagen.
			<p>
			
			</p>
			
			@param _vLfw der neue Wert von VLfw.
			*/
			public void setVLfw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _vLfw) {
				this._vLfw = _vLfw;
			}
		
			/**
			Geschwindigkeit Lkw ähnliche.
			<p>
			
			</p>
			
			@return der Wert von VLkwAe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getVLkwAe() {
				return _vLkwAe;
			}
		
			/**
			Geschwindigkeit Lkw ähnliche.
			<p>
			
			</p>
			
			@param _vLkwAe der neue Wert von VLkwAe.
			*/
			public void setVLkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _vLkwAe) {
				this._vLkwAe = _vLkwAe;
			}
		
			/**
			Geschwindigkeit Pkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von VPkwA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getVPkwA() {
				return _vPkwA;
			}
		
			/**
			Geschwindigkeit Pkw mit Anhänger.
			<p>
			
			</p>
			
			@param _vPkwA der neue Wert von VPkwA.
			*/
			public void setVPkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _vPkwA) {
				this._vPkwA = _vPkwA;
			}
		
			/**
			Geschwindigkeit Lkw.
			<p>
			
			</p>
			
			@return der Wert von VLkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getVLkw() {
				return _vLkw;
			}
		
			/**
			Geschwindigkeit Lkw.
			<p>
			
			</p>
			
			@param _vLkw der neue Wert von VLkw.
			*/
			public void setVLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _vLkw) {
				this._vLkw = _vLkw;
			}
		
			/**
			Geschwindigkeit Busse.
			<p>
			
			</p>
			
			@return der Wert von VBus.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getVBus() {
				return _vBus;
			}
		
			/**
			Geschwindigkeit Busse.
			<p>
			
			</p>
			
			@param _vBus der neue Wert von VBus.
			*/
			public void setVBus(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _vBus) {
				this._vBus = _vBus;
			}
		
			/**
			Geschwindigkeit Lkw mit Anhänger und Sattel-Kfz.
			<p>
			
			</p>
			
			@return der Wert von VLkwK.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getVLkwK() {
				return _vLkwK;
			}
		
			/**
			Geschwindigkeit Lkw mit Anhänger und Sattel-Kfz.
			<p>
			
			</p>
			
			@param _vLkwK der neue Wert von VLkwK.
			*/
			public void setVLkwK(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _vLkwK) {
				this._vLkwK = _vLkwK;
			}
		
			/**
			Geschwindigkeit Lkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von VLkwA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getVLkwA() {
				return _vLkwA;
			}
		
			/**
			Geschwindigkeit Lkw mit Anhänger.
			<p>
			
			</p>
			
			@param _vLkwA der neue Wert von VLkwA.
			*/
			public void setVLkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _vLkwA) {
				this._vLkwA = _vLkwA;
			}
		
			/**
			Geschwindigkeit Sattel-Kfz.
			<p>
			
			</p>
			
			@return der Wert von VSattelKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getVSattelKfz() {
				return _vSattelKfz;
			}
		
			/**
			Geschwindigkeit Sattel-Kfz.
			<p>
			
			</p>
			
			@param _vSattelKfz der neue Wert von VSattelKfz.
			*/
			public void setVSattelKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _vSattelKfz) {
				this._vSattelKfz = _vSattelKfz;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Kfz.
			<p>
			
			</p>
			
			@return der Wert von SKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getSKfz() {
				return _sKfz;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Kfz.
			<p>
			
			</p>
			
			@param _sKfz der neue Wert von SKfz.
			*/
			public void setSKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _sKfz) {
				this._sKfz = _sKfz;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Pkw
									ähnliche.
			<p>
			
			</p>
			
			@return der Wert von SPkwAe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getSPkwAe() {
				return _sPkwAe;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Pkw
									ähnliche.
			<p>
			
			</p>
			
			@param _sPkwAe der neue Wert von SPkwAe.
			*/
			public void setSPkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _sPkwAe) {
				this._sPkwAe = _sPkwAe;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Kfz nicht
									klassifiziert.
			<p>
			
			</p>
			
			@return der Wert von SKfzNk.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getSKfzNk() {
				return _sKfzNk;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Kfz nicht
									klassifiziert.
			<p>
			
			</p>
			
			@param _sKfzNk der neue Wert von SKfzNk.
			*/
			public void setSKfzNk(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _sKfzNk) {
				this._sKfzNk = _sKfzNk;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Pkw
									Gruppe (Motorräder, Pkw , Lieferwagen).
			<p>
			
			</p>
			
			@return der Wert von SPkwG.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getSPkwG() {
				return _sPkwG;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Pkw
									Gruppe (Motorräder, Pkw , Lieferwagen).
			<p>
			
			</p>
			
			@param _sPkwG der neue Wert von SPkwG.
			*/
			public void setSPkwG(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _sPkwG) {
				this._sPkwG = _sPkwG;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Pkw.
			<p>
			
			</p>
			
			@return der Wert von SPkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getSPkw() {
				return _sPkw;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Pkw.
			<p>
			
			</p>
			
			@param _sPkw der neue Wert von SPkw.
			*/
			public void setSPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _sPkw) {
				this._sPkw = _sPkw;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Krad.
			<p>
			
			</p>
			
			@return der Wert von SKrad.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getSKrad() {
				return _sKrad;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Krad.
			<p>
			
			</p>
			
			@param _sKrad der neue Wert von SKrad.
			*/
			public void setSKrad(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _sKrad) {
				this._sKrad = _sKrad;
			}
		
			/**
			Standardabweichung der Geschwindigkeit
									Lieferwagen.
			<p>
			
			</p>
			
			@return der Wert von SLfw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getSLfw() {
				return _sLfw;
			}
		
			/**
			Standardabweichung der Geschwindigkeit
									Lieferwagen.
			<p>
			
			</p>
			
			@param _sLfw der neue Wert von SLfw.
			*/
			public void setSLfw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _sLfw) {
				this._sLfw = _sLfw;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Lkw
									ähnliche.
			<p>
			
			</p>
			
			@return der Wert von SLkwAe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getSLkwAe() {
				return _sLkwAe;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Lkw
									ähnliche.
			<p>
			
			</p>
			
			@param _sLkwAe der neue Wert von SLkwAe.
			*/
			public void setSLkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _sLkwAe) {
				this._sLkwAe = _sLkwAe;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Pkw mit
									Anhänger.
			<p>
			
			</p>
			
			@return der Wert von SPkwA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getSPkwA() {
				return _sPkwA;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Pkw mit
									Anhänger.
			<p>
			
			</p>
			
			@param _sPkwA der neue Wert von SPkwA.
			*/
			public void setSPkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _sPkwA) {
				this._sPkwA = _sPkwA;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Lkw.
			<p>
			
			</p>
			
			@return der Wert von SLkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getSLkw() {
				return _sLkw;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Lkw.
			<p>
			
			</p>
			
			@param _sLkw der neue Wert von SLkw.
			*/
			public void setSLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _sLkw) {
				this._sLkw = _sLkw;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Busse.
			<p>
			
			</p>
			
			@return der Wert von SBus.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getSBus() {
				return _sBus;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Busse.
			<p>
			
			</p>
			
			@param _sBus der neue Wert von SBus.
			*/
			public void setSBus(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _sBus) {
				this._sBus = _sBus;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Lkw mit
									Anhänger und Sattel-Kfz.
			<p>
			
			</p>
			
			@return der Wert von SLkwK.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getSLkwK() {
				return _sLkwK;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Lkw mit
									Anhänger und Sattel-Kfz.
			<p>
			
			</p>
			
			@param _sLkwK der neue Wert von SLkwK.
			*/
			public void setSLkwK(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _sLkwK) {
				this._sLkwK = _sLkwK;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Lkw mit
									Anhänger.
			<p>
			
			</p>
			
			@return der Wert von SLkwA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getSLkwA() {
				return _sLkwA;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Lkw mit
									Anhänger.
			<p>
			
			</p>
			
			@param _sLkwA der neue Wert von SLkwA.
			*/
			public void setSLkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _sLkwA) {
				this._sLkwA = _sLkwA;
			}
		
			/**
			Standardabweichung der Geschwindigkeit
									Sattel-Kfz.
			<p>
			
			</p>
			
			@return der Wert von SSattelKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getSSattelKfz() {
				return _sSattelKfz;
			}
		
			/**
			Standardabweichung der Geschwindigkeit
									Sattel-Kfz.
			<p>
			
			</p>
			
			@param _sSattelKfz der neue Wert von SSattelKfz.
			*/
			public void setSSattelKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _sSattelKfz) {
				this._sSattelKfz = _sSattelKfz;
			}
		
			/**
			v85-Geschwindigkeit Kfz.
			<p>
			
			</p>
			
			@return der Wert von V85Kfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getV85Kfz() {
				return _v85Kfz;
			}
		
			/**
			v85-Geschwindigkeit Kfz.
			<p>
			
			</p>
			
			@param _v85Kfz der neue Wert von V85Kfz.
			*/
			public void setV85Kfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _v85Kfz) {
				this._v85Kfz = _v85Kfz;
			}
		
			/**
			v85-Geschwindigkeit Pkw ähnliche.
			<p>
			
			</p>
			
			@return der Wert von V85PkwAe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getV85PkwAe() {
				return _v85PkwAe;
			}
		
			/**
			v85-Geschwindigkeit Pkw ähnliche.
			<p>
			
			</p>
			
			@param _v85PkwAe der neue Wert von V85PkwAe.
			*/
			public void setV85PkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _v85PkwAe) {
				this._v85PkwAe = _v85PkwAe;
			}
		
			/**
			v85-Geschwindigkeit Kfz nicht klassifiziert.
			<p>
			
			</p>
			
			@return der Wert von V85KfzNk.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getV85KfzNk() {
				return _v85KfzNk;
			}
		
			/**
			v85-Geschwindigkeit Kfz nicht klassifiziert.
			<p>
			
			</p>
			
			@param _v85KfzNk der neue Wert von V85KfzNk.
			*/
			public void setV85KfzNk(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _v85KfzNk) {
				this._v85KfzNk = _v85KfzNk;
			}
		
			/**
			v85-Geschwindigkeit Pkw Gruppe (Motorräder, Pkw
									, Lieferwagen).
			<p>
			
			</p>
			
			@return der Wert von V85PkwG.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getV85PkwG() {
				return _v85PkwG;
			}
		
			/**
			v85-Geschwindigkeit Pkw Gruppe (Motorräder, Pkw
									, Lieferwagen).
			<p>
			
			</p>
			
			@param _v85PkwG der neue Wert von V85PkwG.
			*/
			public void setV85PkwG(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _v85PkwG) {
				this._v85PkwG = _v85PkwG;
			}
		
			/**
			v85-Geschwindigkeit Pkw.
			<p>
			
			</p>
			
			@return der Wert von V85Pkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getV85Pkw() {
				return _v85Pkw;
			}
		
			/**
			v85-Geschwindigkeit Pkw.
			<p>
			
			</p>
			
			@param _v85Pkw der neue Wert von V85Pkw.
			*/
			public void setV85Pkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _v85Pkw) {
				this._v85Pkw = _v85Pkw;
			}
		
			/**
			v85-Geschwindigkeit Krad.
			<p>
			
			</p>
			
			@return der Wert von V85Krad.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getV85Krad() {
				return _v85Krad;
			}
		
			/**
			v85-Geschwindigkeit Krad.
			<p>
			
			</p>
			
			@param _v85Krad der neue Wert von V85Krad.
			*/
			public void setV85Krad(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _v85Krad) {
				this._v85Krad = _v85Krad;
			}
		
			/**
			v85-Geschwindigkeit Lieferwagen.
			<p>
			
			</p>
			
			@return der Wert von V85Lfw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getV85Lfw() {
				return _v85Lfw;
			}
		
			/**
			v85-Geschwindigkeit Lieferwagen.
			<p>
			
			</p>
			
			@param _v85Lfw der neue Wert von V85Lfw.
			*/
			public void setV85Lfw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _v85Lfw) {
				this._v85Lfw = _v85Lfw;
			}
		
			/**
			v85-Geschwindigkeit Lkw ähnliche.
			<p>
			
			</p>
			
			@return der Wert von V85LkwAe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getV85LkwAe() {
				return _v85LkwAe;
			}
		
			/**
			v85-Geschwindigkeit Lkw ähnliche.
			<p>
			
			</p>
			
			@param _v85LkwAe der neue Wert von V85LkwAe.
			*/
			public void setV85LkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _v85LkwAe) {
				this._v85LkwAe = _v85LkwAe;
			}
		
			/**
			v85-Geschwindigkeit Pkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von V85PkwA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getV85PkwA() {
				return _v85PkwA;
			}
		
			/**
			v85-Geschwindigkeit Pkw mit Anhänger.
			<p>
			
			</p>
			
			@param _v85PkwA der neue Wert von V85PkwA.
			*/
			public void setV85PkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _v85PkwA) {
				this._v85PkwA = _v85PkwA;
			}
		
			/**
			v85-Geschwindigkeit Lkw.
			<p>
			
			</p>
			
			@return der Wert von V85Lkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getV85Lkw() {
				return _v85Lkw;
			}
		
			/**
			v85-Geschwindigkeit Lkw.
			<p>
			
			</p>
			
			@param _v85Lkw der neue Wert von V85Lkw.
			*/
			public void setV85Lkw(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _v85Lkw) {
				this._v85Lkw = _v85Lkw;
			}
		
			/**
			v85-Geschwindigkeit Busse.
			<p>
			
			</p>
			
			@return der Wert von V85Bus.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getV85Bus() {
				return _v85Bus;
			}
		
			/**
			v85-Geschwindigkeit Busse.
			<p>
			
			</p>
			
			@param _v85Bus der neue Wert von V85Bus.
			*/
			public void setV85Bus(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _v85Bus) {
				this._v85Bus = _v85Bus;
			}
		
			/**
			v85-Geschwindigkeit Lkw mit Anhänger und
									Sattel-Kfz.
			<p>
			
			</p>
			
			@return der Wert von V85LkwK.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getV85LkwK() {
				return _v85LkwK;
			}
		
			/**
			v85-Geschwindigkeit Lkw mit Anhänger und
									Sattel-Kfz.
			<p>
			
			</p>
			
			@param _v85LkwK der neue Wert von V85LkwK.
			*/
			public void setV85LkwK(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _v85LkwK) {
				this._v85LkwK = _v85LkwK;
			}
		
			/**
			v85-Geschwindigkeit Lkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von V85LkwA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getV85LkwA() {
				return _v85LkwA;
			}
		
			/**
			v85-Geschwindigkeit Lkw mit Anhänger.
			<p>
			
			</p>
			
			@param _v85LkwA der neue Wert von V85LkwA.
			*/
			public void setV85LkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _v85LkwA) {
				this._v85LkwA = _v85LkwA;
			}
		
			/**
			v85-Geschwindigkeit Sattel-Kfz.
			<p>
			
			</p>
			
			@return der Wert von V85SattelKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
				 getV85SattelKfz() {
				return _v85SattelKfz;
			}
		
			/**
			v85-Geschwindigkeit Sattel-Kfz.
			<p>
			
			</p>
			
			@param _v85SattelKfz der neue Wert von V85SattelKfz.
			*/
			public void setV85SattelKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlGeschwindigkeit
			 _v85SattelKfz) {
				this._v85SattelKfz = _v85SattelKfz;
			}
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse Kfz.
			<p>
			
			</p>
			
			@return der Wert von QKfzGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				> getQKfzGeschwKlasse() {
				return _qKfzGeschwKlasse;
			}
		
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse Pkw
									ähnliche.
			<p>
			
			</p>
			
			@return der Wert von QPkwAeGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				> getQPkwAeGeschwKlasse() {
				return _qPkwAeGeschwKlasse;
			}
		
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse Kfz
									nicht klassifiziert.
			<p>
			
			</p>
			
			@return der Wert von QKfzNkGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				> getQKfzNkGeschwKlasse() {
				return _qKfzNkGeschwKlasse;
			}
		
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse Pkw
									Gruppe (Motorräder, Pkw , Lieferwagen).
			<p>
			
			</p>
			
			@return der Wert von QPkwGGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				> getQPkwGGeschwKlasse() {
				return _qPkwGGeschwKlasse;
			}
		
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse Pkw.
			<p>
			
			</p>
			
			@return der Wert von QPkwGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				> getQPkwGeschwKlasse() {
				return _qPkwGeschwKlasse;
			}
		
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse Krad.
			<p>
			
			</p>
			
			@return der Wert von QKradGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				> getQKradGeschwKlasse() {
				return _qKradGeschwKlasse;
			}
		
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse
									Lieferwagen.
			<p>
			
			</p>
			
			@return der Wert von QLfwGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				> getQLfwGeschwKlasse() {
				return _qLfwGeschwKlasse;
			}
		
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse Lkw
									ähnliche.
			<p>
			
			</p>
			
			@return der Wert von QLkwAeGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				> getQLkwAeGeschwKlasse() {
				return _qLkwAeGeschwKlasse;
			}
		
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse Pkw
									mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von QPkwAGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				> getQPkwAGeschwKlasse() {
				return _qPkwAGeschwKlasse;
			}
		
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse Lkw.
			<p>
			
			</p>
			
			@return der Wert von QLkwGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				> getQLkwGeschwKlasse() {
				return _qLkwGeschwKlasse;
			}
		
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse
									Busse.
			<p>
			
			</p>
			
			@return der Wert von QBusGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				> getQBusGeschwKlasse() {
				return _qBusGeschwKlasse;
			}
		
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse Lkw
									mit Anhänger und Sattel-Kfz.
			<p>
			
			</p>
			
			@return der Wert von QLkwKGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				> getQLkwKGeschwKlasse() {
				return _qLkwKGeschwKlasse;
			}
		
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse Lkw
									mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von QLkwAGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				> getQLkwAGeschwKlasse() {
				return _qLkwAGeschwKlasse;
			}
		
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse
									Sattel-Kfz.
			<p>
			
			</p>
			
			@return der Wert von QSattelKfzGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
				> getQSattelKfzGeschwKlasse() {
				return _qSattelKfzGeschwKlasse;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						datum.getTimeValue("T").setMillis(getT().getTime());
					// AttributListenDefinition
						getQKfz().bean2Atl(datum.getItem("qKfz"), factory);
					// AttributListenDefinition
						getQPkwAe().bean2Atl(datum.getItem("qPkwÄ"), factory);
					// AttributListenDefinition
						getQKfzNk().bean2Atl(datum.getItem("qKfzNk"), factory);
					// AttributListenDefinition
						getQPkwG().bean2Atl(datum.getItem("qPkwG"), factory);
					// AttributListenDefinition
						getQPkw().bean2Atl(datum.getItem("qPkw"), factory);
					// AttributListenDefinition
						getQKrad().bean2Atl(datum.getItem("qKrad"), factory);
					// AttributListenDefinition
						getQLfw().bean2Atl(datum.getItem("qLfw"), factory);
					// AttributListenDefinition
						getQLkwAe().bean2Atl(datum.getItem("qLkwÄ"), factory);
					// AttributListenDefinition
						getQPkwA().bean2Atl(datum.getItem("qPkwA"), factory);
					// AttributListenDefinition
						getQLkw().bean2Atl(datum.getItem("qLkw"), factory);
					// AttributListenDefinition
						getQBus().bean2Atl(datum.getItem("qBus"), factory);
					// AttributListenDefinition
						getQLkwK().bean2Atl(datum.getItem("qLkwK"), factory);
					// AttributListenDefinition
						getQLkwA().bean2Atl(datum.getItem("qLkwA"), factory);
					// AttributListenDefinition
						getQSattelKfz().bean2Atl(datum.getItem("qSattelKfz"), factory);
					// AttributListenDefinition
						getVKfz().bean2Atl(datum.getItem("vKfz"), factory);
					// AttributListenDefinition
						getVPkwAe().bean2Atl(datum.getItem("vPkwÄ"), factory);
					// AttributListenDefinition
						getVKfzNk().bean2Atl(datum.getItem("vKfzNk"), factory);
					// AttributListenDefinition
						getVPkwG().bean2Atl(datum.getItem("vPkwG"), factory);
					// AttributListenDefinition
						getVPkw().bean2Atl(datum.getItem("vPkw"), factory);
					// AttributListenDefinition
						getVKrad().bean2Atl(datum.getItem("vKrad"), factory);
					// AttributListenDefinition
						getVLfw().bean2Atl(datum.getItem("vLfw"), factory);
					// AttributListenDefinition
						getVLkwAe().bean2Atl(datum.getItem("vLkwÄ"), factory);
					// AttributListenDefinition
						getVPkwA().bean2Atl(datum.getItem("vPkwA"), factory);
					// AttributListenDefinition
						getVLkw().bean2Atl(datum.getItem("vLkw"), factory);
					// AttributListenDefinition
						getVBus().bean2Atl(datum.getItem("vBus"), factory);
					// AttributListenDefinition
						getVLkwK().bean2Atl(datum.getItem("vLkwK"), factory);
					// AttributListenDefinition
						getVLkwA().bean2Atl(datum.getItem("vLkwA"), factory);
					// AttributListenDefinition
						getVSattelKfz().bean2Atl(datum.getItem("vSattelKfz"), factory);
					// AttributListenDefinition
						getSKfz().bean2Atl(datum.getItem("sKfz"), factory);
					// AttributListenDefinition
						getSPkwAe().bean2Atl(datum.getItem("sPkwÄ"), factory);
					// AttributListenDefinition
						getSKfzNk().bean2Atl(datum.getItem("sKfzNk"), factory);
					// AttributListenDefinition
						getSPkwG().bean2Atl(datum.getItem("sPkwG"), factory);
					// AttributListenDefinition
						getSPkw().bean2Atl(datum.getItem("sPkw"), factory);
					// AttributListenDefinition
						getSKrad().bean2Atl(datum.getItem("sKrad"), factory);
					// AttributListenDefinition
						getSLfw().bean2Atl(datum.getItem("sLfw"), factory);
					// AttributListenDefinition
						getSLkwAe().bean2Atl(datum.getItem("sLkwÄ"), factory);
					// AttributListenDefinition
						getSPkwA().bean2Atl(datum.getItem("sPkwA"), factory);
					// AttributListenDefinition
						getSLkw().bean2Atl(datum.getItem("sLkw"), factory);
					// AttributListenDefinition
						getSBus().bean2Atl(datum.getItem("sBus"), factory);
					// AttributListenDefinition
						getSLkwK().bean2Atl(datum.getItem("sLkwK"), factory);
					// AttributListenDefinition
						getSLkwA().bean2Atl(datum.getItem("sLkwA"), factory);
					// AttributListenDefinition
						getSSattelKfz().bean2Atl(datum.getItem("sSattelKfz"), factory);
					// AttributListenDefinition
						getV85Kfz().bean2Atl(datum.getItem("v85Kfz"), factory);
					// AttributListenDefinition
						getV85PkwAe().bean2Atl(datum.getItem("v85PkwÄ"), factory);
					// AttributListenDefinition
						getV85KfzNk().bean2Atl(datum.getItem("v85KfzNk"), factory);
					// AttributListenDefinition
						getV85PkwG().bean2Atl(datum.getItem("v85PkwG"), factory);
					// AttributListenDefinition
						getV85Pkw().bean2Atl(datum.getItem("v85Pkw"), factory);
					// AttributListenDefinition
						getV85Krad().bean2Atl(datum.getItem("v85Krad"), factory);
					// AttributListenDefinition
						getV85Lfw().bean2Atl(datum.getItem("v85Lfw"), factory);
					// AttributListenDefinition
						getV85LkwAe().bean2Atl(datum.getItem("v85LkwÄ"), factory);
					// AttributListenDefinition
						getV85PkwA().bean2Atl(datum.getItem("v85PkwA"), factory);
					// AttributListenDefinition
						getV85Lkw().bean2Atl(datum.getItem("v85Lkw"), factory);
					// AttributListenDefinition
						getV85Bus().bean2Atl(datum.getItem("v85Bus"), factory);
					// AttributListenDefinition
						getV85LkwK().bean2Atl(datum.getItem("v85LkwK"), factory);
					// AttributListenDefinition
						getV85LkwA().bean2Atl(datum.getItem("v85LkwA"), factory);
					// AttributListenDefinition
						getV85SattelKfz().bean2Atl(datum.getItem("v85SattelKfz"), factory);
					// AttributListenDefinition
						final Data.Array arrayQKfzGeschwKlasse = datum.getArray("qKfzGeschwKlasse");
						arrayQKfzGeschwKlasse.setLength(getQKfzGeschwKlasse().size());
						for (int i = 0; i < arrayQKfzGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 atl = getQKfzGeschwKlasse().get(i);
							atl.bean2Atl(arrayQKfzGeschwKlasse.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayQPkwAeGeschwKlasse = datum.getArray("qPkwÄGeschwKlasse");
						arrayQPkwAeGeschwKlasse.setLength(getQPkwAeGeschwKlasse().size());
						for (int i = 0; i < arrayQPkwAeGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 atl = getQPkwAeGeschwKlasse().get(i);
							atl.bean2Atl(arrayQPkwAeGeschwKlasse.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayQKfzNkGeschwKlasse = datum.getArray("qKfzNkGeschwKlasse");
						arrayQKfzNkGeschwKlasse.setLength(getQKfzNkGeschwKlasse().size());
						for (int i = 0; i < arrayQKfzNkGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 atl = getQKfzNkGeschwKlasse().get(i);
							atl.bean2Atl(arrayQKfzNkGeschwKlasse.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayQPkwGGeschwKlasse = datum.getArray("qPkwGGeschwKlasse");
						arrayQPkwGGeschwKlasse.setLength(getQPkwGGeschwKlasse().size());
						for (int i = 0; i < arrayQPkwGGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 atl = getQPkwGGeschwKlasse().get(i);
							atl.bean2Atl(arrayQPkwGGeschwKlasse.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayQPkwGeschwKlasse = datum.getArray("qPkwGeschwKlasse");
						arrayQPkwGeschwKlasse.setLength(getQPkwGeschwKlasse().size());
						for (int i = 0; i < arrayQPkwGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 atl = getQPkwGeschwKlasse().get(i);
							atl.bean2Atl(arrayQPkwGeschwKlasse.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayQKradGeschwKlasse = datum.getArray("qKradGeschwKlasse");
						arrayQKradGeschwKlasse.setLength(getQKradGeschwKlasse().size());
						for (int i = 0; i < arrayQKradGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 atl = getQKradGeschwKlasse().get(i);
							atl.bean2Atl(arrayQKradGeschwKlasse.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayQLfwGeschwKlasse = datum.getArray("qLfwGeschwKlasse");
						arrayQLfwGeschwKlasse.setLength(getQLfwGeschwKlasse().size());
						for (int i = 0; i < arrayQLfwGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 atl = getQLfwGeschwKlasse().get(i);
							atl.bean2Atl(arrayQLfwGeschwKlasse.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayQLkwAeGeschwKlasse = datum.getArray("qLkwÄGeschwKlasse");
						arrayQLkwAeGeschwKlasse.setLength(getQLkwAeGeschwKlasse().size());
						for (int i = 0; i < arrayQLkwAeGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 atl = getQLkwAeGeschwKlasse().get(i);
							atl.bean2Atl(arrayQLkwAeGeschwKlasse.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayQPkwAGeschwKlasse = datum.getArray("qPkwAGeschwKlasse");
						arrayQPkwAGeschwKlasse.setLength(getQPkwAGeschwKlasse().size());
						for (int i = 0; i < arrayQPkwAGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 atl = getQPkwAGeschwKlasse().get(i);
							atl.bean2Atl(arrayQPkwAGeschwKlasse.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayQLkwGeschwKlasse = datum.getArray("qLkwGeschwKlasse");
						arrayQLkwGeschwKlasse.setLength(getQLkwGeschwKlasse().size());
						for (int i = 0; i < arrayQLkwGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 atl = getQLkwGeschwKlasse().get(i);
							atl.bean2Atl(arrayQLkwGeschwKlasse.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayQBusGeschwKlasse = datum.getArray("qBusGeschwKlasse");
						arrayQBusGeschwKlasse.setLength(getQBusGeschwKlasse().size());
						for (int i = 0; i < arrayQBusGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 atl = getQBusGeschwKlasse().get(i);
							atl.bean2Atl(arrayQBusGeschwKlasse.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayQLkwKGeschwKlasse = datum.getArray("qLkwKGeschwKlasse");
						arrayQLkwKGeschwKlasse.setLength(getQLkwKGeschwKlasse().size());
						for (int i = 0; i < arrayQLkwKGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 atl = getQLkwKGeschwKlasse().get(i);
							atl.bean2Atl(arrayQLkwKGeschwKlasse.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayQLkwAGeschwKlasse = datum.getArray("qLkwAGeschwKlasse");
						arrayQLkwAGeschwKlasse.setLength(getQLkwAGeschwKlasse().size());
						for (int i = 0; i < arrayQLkwAGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 atl = getQLkwAGeschwKlasse().get(i);
							atl.bean2Atl(arrayQLkwAGeschwKlasse.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayQSattelKfzGeschwKlasse = datum.getArray("qSattelKfzGeschwKlasse");
						arrayQSattelKfzGeschwKlasse.setLength(getQSattelKfzGeschwKlasse().size());
						for (int i = 0; i < arrayQSattelKfzGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 atl = getQSattelKfzGeschwKlasse().get(i);
							atl.bean2Atl(arrayQSattelKfzGeschwKlasse.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						setT(new
							RelativerZeitstempel
							(daten.getTimeValue("T").getMillis()));
					// AttributListenDefinition
						getQKfz().atl2Bean(daten.getItem("qKfz"), factory);
					// AttributListenDefinition
						getQPkwAe().atl2Bean(daten.getItem("qPkwÄ"), factory);
					// AttributListenDefinition
						getQKfzNk().atl2Bean(daten.getItem("qKfzNk"), factory);
					// AttributListenDefinition
						getQPkwG().atl2Bean(daten.getItem("qPkwG"), factory);
					// AttributListenDefinition
						getQPkw().atl2Bean(daten.getItem("qPkw"), factory);
					// AttributListenDefinition
						getQKrad().atl2Bean(daten.getItem("qKrad"), factory);
					// AttributListenDefinition
						getQLfw().atl2Bean(daten.getItem("qLfw"), factory);
					// AttributListenDefinition
						getQLkwAe().atl2Bean(daten.getItem("qLkwÄ"), factory);
					// AttributListenDefinition
						getQPkwA().atl2Bean(daten.getItem("qPkwA"), factory);
					// AttributListenDefinition
						getQLkw().atl2Bean(daten.getItem("qLkw"), factory);
					// AttributListenDefinition
						getQBus().atl2Bean(daten.getItem("qBus"), factory);
					// AttributListenDefinition
						getQLkwK().atl2Bean(daten.getItem("qLkwK"), factory);
					// AttributListenDefinition
						getQLkwA().atl2Bean(daten.getItem("qLkwA"), factory);
					// AttributListenDefinition
						getQSattelKfz().atl2Bean(daten.getItem("qSattelKfz"), factory);
					// AttributListenDefinition
						getVKfz().atl2Bean(daten.getItem("vKfz"), factory);
					// AttributListenDefinition
						getVPkwAe().atl2Bean(daten.getItem("vPkwÄ"), factory);
					// AttributListenDefinition
						getVKfzNk().atl2Bean(daten.getItem("vKfzNk"), factory);
					// AttributListenDefinition
						getVPkwG().atl2Bean(daten.getItem("vPkwG"), factory);
					// AttributListenDefinition
						getVPkw().atl2Bean(daten.getItem("vPkw"), factory);
					// AttributListenDefinition
						getVKrad().atl2Bean(daten.getItem("vKrad"), factory);
					// AttributListenDefinition
						getVLfw().atl2Bean(daten.getItem("vLfw"), factory);
					// AttributListenDefinition
						getVLkwAe().atl2Bean(daten.getItem("vLkwÄ"), factory);
					// AttributListenDefinition
						getVPkwA().atl2Bean(daten.getItem("vPkwA"), factory);
					// AttributListenDefinition
						getVLkw().atl2Bean(daten.getItem("vLkw"), factory);
					// AttributListenDefinition
						getVBus().atl2Bean(daten.getItem("vBus"), factory);
					// AttributListenDefinition
						getVLkwK().atl2Bean(daten.getItem("vLkwK"), factory);
					// AttributListenDefinition
						getVLkwA().atl2Bean(daten.getItem("vLkwA"), factory);
					// AttributListenDefinition
						getVSattelKfz().atl2Bean(daten.getItem("vSattelKfz"), factory);
					// AttributListenDefinition
						getSKfz().atl2Bean(daten.getItem("sKfz"), factory);
					// AttributListenDefinition
						getSPkwAe().atl2Bean(daten.getItem("sPkwÄ"), factory);
					// AttributListenDefinition
						getSKfzNk().atl2Bean(daten.getItem("sKfzNk"), factory);
					// AttributListenDefinition
						getSPkwG().atl2Bean(daten.getItem("sPkwG"), factory);
					// AttributListenDefinition
						getSPkw().atl2Bean(daten.getItem("sPkw"), factory);
					// AttributListenDefinition
						getSKrad().atl2Bean(daten.getItem("sKrad"), factory);
					// AttributListenDefinition
						getSLfw().atl2Bean(daten.getItem("sLfw"), factory);
					// AttributListenDefinition
						getSLkwAe().atl2Bean(daten.getItem("sLkwÄ"), factory);
					// AttributListenDefinition
						getSPkwA().atl2Bean(daten.getItem("sPkwA"), factory);
					// AttributListenDefinition
						getSLkw().atl2Bean(daten.getItem("sLkw"), factory);
					// AttributListenDefinition
						getSBus().atl2Bean(daten.getItem("sBus"), factory);
					// AttributListenDefinition
						getSLkwK().atl2Bean(daten.getItem("sLkwK"), factory);
					// AttributListenDefinition
						getSLkwA().atl2Bean(daten.getItem("sLkwA"), factory);
					// AttributListenDefinition
						getSSattelKfz().atl2Bean(daten.getItem("sSattelKfz"), factory);
					// AttributListenDefinition
						getV85Kfz().atl2Bean(daten.getItem("v85Kfz"), factory);
					// AttributListenDefinition
						getV85PkwAe().atl2Bean(daten.getItem("v85PkwÄ"), factory);
					// AttributListenDefinition
						getV85KfzNk().atl2Bean(daten.getItem("v85KfzNk"), factory);
					// AttributListenDefinition
						getV85PkwG().atl2Bean(daten.getItem("v85PkwG"), factory);
					// AttributListenDefinition
						getV85Pkw().atl2Bean(daten.getItem("v85Pkw"), factory);
					// AttributListenDefinition
						getV85Krad().atl2Bean(daten.getItem("v85Krad"), factory);
					// AttributListenDefinition
						getV85Lfw().atl2Bean(daten.getItem("v85Lfw"), factory);
					// AttributListenDefinition
						getV85LkwAe().atl2Bean(daten.getItem("v85LkwÄ"), factory);
					// AttributListenDefinition
						getV85PkwA().atl2Bean(daten.getItem("v85PkwA"), factory);
					// AttributListenDefinition
						getV85Lkw().atl2Bean(daten.getItem("v85Lkw"), factory);
					// AttributListenDefinition
						getV85Bus().atl2Bean(daten.getItem("v85Bus"), factory);
					// AttributListenDefinition
						getV85LkwK().atl2Bean(daten.getItem("v85LkwK"), factory);
					// AttributListenDefinition
						getV85LkwA().atl2Bean(daten.getItem("v85LkwA"), factory);
					// AttributListenDefinition
						getV85SattelKfz().atl2Bean(daten.getItem("v85SattelKfz"), factory);
					// AttributListenDefinition
						final Data.Array arrayQKfzGeschwKlasse = daten.getArray("qKfzGeschwKlasse");
						for (int i = 0; i < arrayQKfzGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 ();
							atl.atl2Bean(arrayQKfzGeschwKlasse.getItem(i), factory);
							getQKfzGeschwKlasse().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayQPkwAeGeschwKlasse = daten.getArray("qPkwÄGeschwKlasse");
						for (int i = 0; i < arrayQPkwAeGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 ();
							atl.atl2Bean(arrayQPkwAeGeschwKlasse.getItem(i), factory);
							getQPkwAeGeschwKlasse().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayQKfzNkGeschwKlasse = daten.getArray("qKfzNkGeschwKlasse");
						for (int i = 0; i < arrayQKfzNkGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 ();
							atl.atl2Bean(arrayQKfzNkGeschwKlasse.getItem(i), factory);
							getQKfzNkGeschwKlasse().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayQPkwGGeschwKlasse = daten.getArray("qPkwGGeschwKlasse");
						for (int i = 0; i < arrayQPkwGGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 ();
							atl.atl2Bean(arrayQPkwGGeschwKlasse.getItem(i), factory);
							getQPkwGGeschwKlasse().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayQPkwGeschwKlasse = daten.getArray("qPkwGeschwKlasse");
						for (int i = 0; i < arrayQPkwGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 ();
							atl.atl2Bean(arrayQPkwGeschwKlasse.getItem(i), factory);
							getQPkwGeschwKlasse().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayQKradGeschwKlasse = daten.getArray("qKradGeschwKlasse");
						for (int i = 0; i < arrayQKradGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 ();
							atl.atl2Bean(arrayQKradGeschwKlasse.getItem(i), factory);
							getQKradGeschwKlasse().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayQLfwGeschwKlasse = daten.getArray("qLfwGeschwKlasse");
						for (int i = 0; i < arrayQLfwGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 ();
							atl.atl2Bean(arrayQLfwGeschwKlasse.getItem(i), factory);
							getQLfwGeschwKlasse().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayQLkwAeGeschwKlasse = daten.getArray("qLkwÄGeschwKlasse");
						for (int i = 0; i < arrayQLkwAeGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 ();
							atl.atl2Bean(arrayQLkwAeGeschwKlasse.getItem(i), factory);
							getQLkwAeGeschwKlasse().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayQPkwAGeschwKlasse = daten.getArray("qPkwAGeschwKlasse");
						for (int i = 0; i < arrayQPkwAGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 ();
							atl.atl2Bean(arrayQPkwAGeschwKlasse.getItem(i), factory);
							getQPkwAGeschwKlasse().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayQLkwGeschwKlasse = daten.getArray("qLkwGeschwKlasse");
						for (int i = 0; i < arrayQLkwGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 ();
							atl.atl2Bean(arrayQLkwGeschwKlasse.getItem(i), factory);
							getQLkwGeschwKlasse().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayQBusGeschwKlasse = daten.getArray("qBusGeschwKlasse");
						for (int i = 0; i < arrayQBusGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 ();
							atl.atl2Bean(arrayQBusGeschwKlasse.getItem(i), factory);
							getQBusGeschwKlasse().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayQLkwKGeschwKlasse = daten.getArray("qLkwKGeschwKlasse");
						for (int i = 0; i < arrayQLkwKGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 ();
							atl.atl2Bean(arrayQLkwKGeschwKlasse.getItem(i), factory);
							getQLkwKGeschwKlasse().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayQLkwAGeschwKlasse = daten.getArray("qLkwAGeschwKlasse");
						for (int i = 0; i < arrayQLkwAGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 ();
							atl.atl2Bean(arrayQLkwAGeschwKlasse.getItem(i), factory);
							getQLkwAGeschwKlasse().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayQSattelKfzGeschwKlasse = daten.getArray("qSattelKfzGeschwKlasse");
						for (int i = 0; i < arrayQSattelKfzGeschwKlasse.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AtlVerkehrsStaerkeStunde
							 ();
							atl.atl2Bean(arrayQSattelKfzGeschwKlasse.getItem(i), factory);
							getQSattelKfzGeschwKlasse().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setT(getT());
							klon._qKfz = getQKfz().clone();
							klon._qPkwAe = getQPkwAe().clone();
							klon._qKfzNk = getQKfzNk().clone();
							klon._qPkwG = getQPkwG().clone();
							klon._qPkw = getQPkw().clone();
							klon._qKrad = getQKrad().clone();
							klon._qLfw = getQLfw().clone();
							klon._qLkwAe = getQLkwAe().clone();
							klon._qPkwA = getQPkwA().clone();
							klon._qLkw = getQLkw().clone();
							klon._qBus = getQBus().clone();
							klon._qLkwK = getQLkwK().clone();
							klon._qLkwA = getQLkwA().clone();
							klon._qSattelKfz = getQSattelKfz().clone();
							klon._vKfz = getVKfz().clone();
							klon._vPkwAe = getVPkwAe().clone();
							klon._vKfzNk = getVKfzNk().clone();
							klon._vPkwG = getVPkwG().clone();
							klon._vPkw = getVPkw().clone();
							klon._vKrad = getVKrad().clone();
							klon._vLfw = getVLfw().clone();
							klon._vLkwAe = getVLkwAe().clone();
							klon._vPkwA = getVPkwA().clone();
							klon._vLkw = getVLkw().clone();
							klon._vBus = getVBus().clone();
							klon._vLkwK = getVLkwK().clone();
							klon._vLkwA = getVLkwA().clone();
							klon._vSattelKfz = getVSattelKfz().clone();
							klon._sKfz = getSKfz().clone();
							klon._sPkwAe = getSPkwAe().clone();
							klon._sKfzNk = getSKfzNk().clone();
							klon._sPkwG = getSPkwG().clone();
							klon._sPkw = getSPkw().clone();
							klon._sKrad = getSKrad().clone();
							klon._sLfw = getSLfw().clone();
							klon._sLkwAe = getSLkwAe().clone();
							klon._sPkwA = getSPkwA().clone();
							klon._sLkw = getSLkw().clone();
							klon._sBus = getSBus().clone();
							klon._sLkwK = getSLkwK().clone();
							klon._sLkwA = getSLkwA().clone();
							klon._sSattelKfz = getSSattelKfz().clone();
							klon._v85Kfz = getV85Kfz().clone();
							klon._v85PkwAe = getV85PkwAe().clone();
							klon._v85KfzNk = getV85KfzNk().clone();
							klon._v85PkwG = getV85PkwG().clone();
							klon._v85Pkw = getV85Pkw().clone();
							klon._v85Krad = getV85Krad().clone();
							klon._v85Lfw = getV85Lfw().clone();
							klon._v85LkwAe = getV85LkwAe().clone();
							klon._v85PkwA = getV85PkwA().clone();
							klon._v85Lkw = getV85Lkw().clone();
							klon._v85Bus = getV85Bus().clone();
							klon._v85LkwK = getV85LkwK().clone();
							klon._v85LkwA = getV85LkwA().clone();
							klon._v85SattelKfz = getV85SattelKfz().clone();
						klon._qKfzGeschwKlasse = getQKfzGeschwKlasse().clone();
						klon._qPkwAeGeschwKlasse = getQPkwAeGeschwKlasse().clone();
						klon._qKfzNkGeschwKlasse = getQKfzNkGeschwKlasse().clone();
						klon._qPkwGGeschwKlasse = getQPkwGGeschwKlasse().clone();
						klon._qPkwGeschwKlasse = getQPkwGeschwKlasse().clone();
						klon._qKradGeschwKlasse = getQKradGeschwKlasse().clone();
						klon._qLfwGeschwKlasse = getQLfwGeschwKlasse().clone();
						klon._qLkwAeGeschwKlasse = getQLkwAeGeschwKlasse().clone();
						klon._qPkwAGeschwKlasse = getQPkwAGeschwKlasse().clone();
						klon._qLkwGeschwKlasse = getQLkwGeschwKlasse().clone();
						klon._qBusGeschwKlasse = getQBusGeschwKlasse().clone();
						klon._qLkwKGeschwKlasse = getQLkwKGeschwKlasse().clone();
						klon._qLkwAGeschwKlasse = getQLkwAGeschwKlasse().clone();
						klon._qSattelKfzGeschwKlasse = getQSattelKfzGeschwKlasse().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.verkehrsDatenLangZeitIntervall";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdVerkehrsDatenLangZeitIntervall(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
