/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Modellparameter für die Baustellensimulation.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 24
 */
public class PdBaustellenSimulationModell extends AbstractParameterDatensatz<PdBaustellenSimulationModell.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerTage
				 _prognoseHorizont
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerTage
				 _aktualisierungsIntervall
				;
				private 	RelativerZeitstempel
				 _iterationsSchrittweite
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
				 _faktorQ0
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 _laengePkw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 _laengeStauBeginn
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 _laengeStauAufhebung
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Prognosehorizont der Baustellenprognose (in
									Tagen).
			<p>
			
			</p>
			
			@return der Wert von PrognoseHorizont.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerTage
				 getPrognoseHorizont() {
				return _prognoseHorizont;
			}
		
			/**
			Prognosehorizont der Baustellenprognose (in
									Tagen).
			<p>
			
			</p>
			
			@param _prognoseHorizont der neue Wert von PrognoseHorizont.
			*/
			public void setPrognoseHorizont(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerTage
			 _prognoseHorizont) {
				this._prognoseHorizont = _prognoseHorizont;
			}
		
			/**
			Intervall der zyklischen Aktualisierung der
									Prognoseergebnisse (in Tagen).
			<p>
			
			</p>
			
			@return der Wert von AktualisierungsIntervall.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerTage
				 getAktualisierungsIntervall() {
				return _aktualisierungsIntervall;
			}
		
			/**
			Intervall der zyklischen Aktualisierung der
									Prognoseergebnisse (in Tagen).
			<p>
			
			</p>
			
			@param _aktualisierungsIntervall der neue Wert von AktualisierungsIntervall.
			*/
			public void setAktualisierungsIntervall(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerTage
			 _aktualisierungsIntervall) {
				this._aktualisierungsIntervall = _aktualisierungsIntervall;
			}
		
			/**
			Iterationsschrittweite für die
									Staulängenberechnung.
			<p>
			
			</p>
			
			@return der Wert von IterationsSchrittweite.
			*/
				public 	RelativerZeitstempel
				 getIterationsSchrittweite() {
				return _iterationsSchrittweite;
			}
		
			/**
			Iterationsschrittweite für die
									Staulängenberechnung.
			<p>
			
			</p>
			
			@param _iterationsSchrittweite der neue Wert von IterationsSchrittweite.
			*/
			public void setIterationsSchrittweite(	RelativerZeitstempel
			 _iterationsSchrittweite) {
				this._iterationsSchrittweite = _iterationsSchrittweite;
			}
		
			/**
			Faktor für die Anpassung von Q0 aus dem
									Fundamentaldiagramm.
			<p>
			
			</p>
			
			@return der Wert von FaktorQ0.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
				 getFaktorQ0() {
				return _faktorQ0;
			}
		
			/**
			Faktor für die Anpassung von Q0 aus dem
									Fundamentaldiagramm.
			<p>
			
			</p>
			
			@param _faktorQ0 der neue Wert von FaktorQ0.
			*/
			public void setFaktorQ0(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 _faktorQ0) {
				this._faktorQ0 = _faktorQ0;
			}
		
			/**
			Strecke, die ein Pkw im Stau beansprucht.
			<p>
			
			</p>
			
			@return der Wert von LaengePkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 getLaengePkw() {
				return _laengePkw;
			}
		
			/**
			Strecke, die ein Pkw im Stau beansprucht.
			<p>
			
			</p>
			
			@param _laengePkw der neue Wert von LaengePkw.
			*/
			public void setLaengePkw(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _laengePkw) {
				this._laengePkw = _laengePkw;
			}
		
			/**
			Stau wird erst prognostiziert, sobald diese
									Streckenlänge überstaut ist.
			<p>
			
			</p>
			
			@return der Wert von LaengeStauBeginn.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 getLaengeStauBeginn() {
				return _laengeStauBeginn;
			}
		
			/**
			Stau wird erst prognostiziert, sobald diese
									Streckenlänge überstaut ist.
			<p>
			
			</p>
			
			@param _laengeStauBeginn der neue Wert von LaengeStauBeginn.
			*/
			public void setLaengeStauBeginn(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _laengeStauBeginn) {
				this._laengeStauBeginn = _laengeStauBeginn;
			}
		
			/**
			Stau wird aufgehoben, sobald diese Staulänge
									diesen Wert unterschreitet.
			<p>
			
			</p>
			
			@return der Wert von LaengeStauAufhebung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
				 getLaengeStauAufhebung() {
				return _laengeStauAufhebung;
			}
		
			/**
			Stau wird aufgehoben, sobald diese Staulänge
									diesen Wert unterschreitet.
			<p>
			
			</p>
			
			@param _laengeStauAufhebung der neue Wert von LaengeStauAufhebung.
			*/
			public void setLaengeStauAufhebung(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _laengeStauAufhebung) {
				this._laengeStauAufhebung = _laengeStauAufhebung;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getPrognoseHorizont() != null) {
		                if (getPrognoseHorizont().isZustand()) {
		                    datum.getUnscaledValue("PrognoseHorizont").setText(getPrognoseHorizont().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("PrognoseHorizont").set(getPrognoseHorizont().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAktualisierungsIntervall() != null) {
		                if (getAktualisierungsIntervall().isZustand()) {
		                    datum.getUnscaledValue("AktualisierungsIntervall").setText(getAktualisierungsIntervall().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AktualisierungsIntervall").set(getAktualisierungsIntervall().getValue());
		                }
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("IterationsSchrittweite").setMillis(getIterationsSchrittweite().getTime());
					// GanzzahlAttributTyp
					if (getFaktorQ0() != null) {
		                if (getFaktorQ0().isZustand()) {
		                    datum.getUnscaledValue("FaktorQ0").setText(getFaktorQ0().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("FaktorQ0").set(getFaktorQ0().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getLaengePkw() != null) {
		                if (getLaengePkw().isZustand()) {
		                    datum.getUnscaledValue("LängePkw").setText(getLaengePkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("LängePkw").set(getLaengePkw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getLaengeStauBeginn() != null) {
		                if (getLaengeStauBeginn().isZustand()) {
		                    datum.getUnscaledValue("LängeStauBeginn").setText(getLaengeStauBeginn().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("LängeStauBeginn").set(getLaengeStauBeginn().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getLaengeStauAufhebung() != null) {
		                if (getLaengeStauAufhebung().isZustand()) {
		                    datum.getUnscaledValue("LängeStauAufhebung").setText(getLaengeStauAufhebung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("LängeStauAufhebung").set(getLaengeStauAufhebung().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("PrognoseHorizont").isState()) {
								setPrognoseHorizont(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerTage
								.getZustand(daten.getScaledValue("PrognoseHorizont").getText()));
							} else {
							setPrognoseHorizont(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerTage
							(daten.
								getUnscaledValue
							("PrognoseHorizont").
									longValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("AktualisierungsIntervall").isState()) {
								setAktualisierungsIntervall(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerTage
								.getZustand(daten.getScaledValue("AktualisierungsIntervall").getText()));
							} else {
							setAktualisierungsIntervall(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerTage
							(daten.
								getUnscaledValue
							("AktualisierungsIntervall").
									longValue
							()));
							}
					// ZeitstempelAttributTyp
						setIterationsSchrittweite(new
							RelativerZeitstempel
							(daten.getTimeValue("IterationsSchrittweite").getMillis()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("FaktorQ0").isState()) {
								setFaktorQ0(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
								.getZustand(daten.getScaledValue("FaktorQ0").getText()));
							} else {
							setFaktorQ0(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
							(daten.
								getUnscaledValue
							("FaktorQ0").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("LängePkw").isState()) {
								setLaengePkw(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
								.getZustand(daten.getScaledValue("LängePkw").getText()));
							} else {
							setLaengePkw(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							(daten.
								getUnscaledValue
							("LängePkw").
									longValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("LängeStauBeginn").isState()) {
								setLaengeStauBeginn(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
								.getZustand(daten.getScaledValue("LängeStauBeginn").getText()));
							} else {
							setLaengeStauBeginn(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							(daten.
								getUnscaledValue
							("LängeStauBeginn").
									longValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("LängeStauAufhebung").isState()) {
								setLaengeStauAufhebung(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
								.getZustand(daten.getScaledValue("LängeStauAufhebung").getText()));
							} else {
							setLaengeStauAufhebung(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							(daten.
								getUnscaledValue
							("LängeStauAufhebung").
									longValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setPrognoseHorizont(getPrognoseHorizont());
							klon.setAktualisierungsIntervall(getAktualisierungsIntervall());
							klon.setIterationsSchrittweite(getIterationsSchrittweite());
							klon.setFaktorQ0(getFaktorQ0());
							klon.setLaengePkw(getLaengePkw());
							klon.setLaengeStauBeginn(getLaengeStauBeginn());
							klon.setLaengeStauAufhebung(getLaengeStauAufhebung());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.baustellenSimulationModell";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdBaustellenSimulationModell(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
